/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.List;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.GeneticOperator;
import org.jgap.MutationRateCalculator;
import org.jgap.RandomGenerator;
import org.jgap.impl.CompositeGene;
import org.jgap.impl.DefaultMutationRateCalculator;

public class MutationOperator
implements GeneticOperator {
    protected int m_mutationRate;
    private MutationRateCalculator m_mutationRateCalc;

    public MutationOperator() {
        this.setMutationRateCalc(new DefaultMutationRateCalculator());
    }

    public MutationOperator(MutationRateCalculator a_mutationRateCalculator) {
        this.setMutationRateCalc(a_mutationRateCalculator);
    }

    public MutationOperator(int a_desiredMutationRate) {
        this.m_mutationRate = a_desiredMutationRate;
        this.setMutationRateCalc(null);
    }

    public void operate(Configuration a_activeConfiguration, Chromosome[] a_population, List a_candidateChromosomes) {
        if (this.m_mutationRate == 0 && this.m_mutationRateCalc == null) {
            return;
        }
        int currentRate = this.m_mutationRateCalc != null ? this.m_mutationRateCalc.calculateCurrentRate(a_activeConfiguration) : this.m_mutationRate;
        RandomGenerator generator = a_activeConfiguration.getRandomGenerator();
        int i = 0;
        while (i < a_population.length) {
            Gene[] genes = a_population[i].getGenes();
            Chromosome copyOfChromosome = null;
            int j = 0;
            while (j < genes.length) {
                if (generator.nextInt(currentRate) == 0) {
                    if (copyOfChromosome == null) {
                        copyOfChromosome = (Chromosome)a_population[i].clone();
                        a_candidateChromosomes.add(copyOfChromosome);
                        genes = copyOfChromosome.getGenes();
                    }
                    if (genes[j] instanceof CompositeGene) {
                        CompositeGene compositeGene = (CompositeGene)genes[j];
                        int k = 0;
                        while (k < compositeGene.size()) {
                            this.mutateGene(compositeGene.geneAt(k), generator);
                            ++k;
                        }
                    } else {
                        this.mutateGene(genes[j], generator);
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void mutateGene(Gene a_gene, RandomGenerator a_generator) {
        int k = 0;
        while (k < a_gene.size()) {
            double percentage = -1.0 + a_generator.nextDouble() * 2.0;
            a_gene.applyMutation(k, percentage);
            ++k;
        }
    }

    public MutationRateCalculator getMutationRateCalc() {
        return this.m_mutationRateCalc;
    }

    public void setMutationRateCalc(MutationRateCalculator m_mutationRateCalc) {
        this.m_mutationRateCalc = m_mutationRateCalc;
        if (m_mutationRateCalc != null) {
            this.m_mutationRate = 0;
        }
    }
}

