/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.StringTokenizer;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.RandomGenerator;
import org.jgap.UnsupportedRepresentationException;
import org.jgap.impl.NumberGene;

public class IntegerGene
extends NumberGene
implements Gene {
    protected static final long INTEGER_RANGE = 0xFFFFFFFFL;
    protected int m_upperBounds;
    protected int m_lowerBounds;
    protected long m_boundsUnitsToIntegerUnits;

    public IntegerGene() {
        this.m_lowerBounds = Integer.MIN_VALUE;
        this.m_upperBounds = Integer.MAX_VALUE;
        this.calculateBoundsUnitsToIntegerUnitsRatio();
    }

    public IntegerGene(int a_lowerBounds, int a_upperBounds) {
        this.m_lowerBounds = a_lowerBounds;
        this.m_upperBounds = a_upperBounds;
        this.calculateBoundsUnitsToIntegerUnitsRatio();
    }

    public Gene newGene(Configuration a_activeConfiguration) {
        return new IntegerGene(this.m_lowerBounds, this.m_upperBounds);
    }

    public String getPersistentRepresentation() throws UnsupportedOperationException {
        return String.valueOf(this.toString()) + ":" + this.m_lowerBounds + ":" + this.m_upperBounds;
    }

    public void setValueFromPersistentRepresentation(String a_representation) throws UnsupportedRepresentationException {
        if (a_representation != null) {
            StringTokenizer tokenizer = new StringTokenizer(a_representation, ":");
            if (tokenizer.countTokens() != 3) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: it does not contain three tokens.");
            }
            String valueRepresentation = tokenizer.nextToken();
            String lowerBoundRepresentation = tokenizer.nextToken();
            String upperBoundRepresentation = tokenizer.nextToken();
            if (valueRepresentation.equals("null")) {
                this.m_value = null;
            } else {
                try {
                    this.m_value = new Integer(Integer.parseInt(valueRepresentation));
                }
                catch (NumberFormatException e) {
                    throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 1 does not appear to be an integer value.");
                }
            }
            try {
                this.m_lowerBounds = Integer.parseInt(lowerBoundRepresentation);
            }
            catch (NumberFormatException e) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 2 does not appear to be an integer value.");
            }
            try {
                this.m_upperBounds = Integer.parseInt(upperBoundRepresentation);
            }
            catch (NumberFormatException e) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 3 does not appear to be an integer value.");
            }
            this.calculateBoundsUnitsToIntegerUnitsRatio();
        }
    }

    public int intValue() {
        return (Integer)this.m_value;
    }

    public void setToRandomValue(RandomGenerator a_numberGenerator) {
        this.m_value = new Integer(a_numberGenerator.nextInt());
        this.mapValueToWithinBounds();
    }

    protected int compareToNative(Object o1, Object o2) {
        return ((Integer)o1).compareTo(o2);
    }

    protected void mapValueToWithinBounds() {
        Integer i_value;
        if (this.m_value != null && ((i_value = (Integer)this.m_value) > this.m_upperBounds || i_value < this.m_lowerBounds)) {
            long differenceFromIntMin = Integer.MIN_VALUE + (long)i_value.intValue();
            int differenceFromBoundsMin = (int)(differenceFromIntMin / this.m_boundsUnitsToIntegerUnits);
            this.m_value = new Integer(this.m_upperBounds + differenceFromBoundsMin);
        }
    }

    protected void calculateBoundsUnitsToIntegerUnitsRatio() {
        int divisor = this.m_upperBounds - this.m_lowerBounds + 1;
        this.m_boundsUnitsToIntegerUnits = divisor == 0 ? 0xFFFFFFFFL : 0xFFFFFFFFL / (long)divisor;
    }

    public void applyMutation(int index, double a_percentage) {
        int newValue = (int)Math.round((double)this.intValue() * (1.0 + a_percentage));
        this.setAllele(new Integer(newValue));
    }
}

