/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.Random;
import org.jgap.RandomGenerator;

public class GaussianRandomGenerator
implements RandomGenerator {
    private static final String CVS_REVISION = "$Revision: 1.3 $";
    private static final double DELTA = 1.0E-7;
    private Random rn;
    private double m_mean;
    private double m_standardDeviation;

    public GaussianRandomGenerator() {
        this(0.0);
    }

    public GaussianRandomGenerator(double a_standardDeviation) {
        this.init();
        this.setGaussianStdDeviation(a_standardDeviation);
    }

    private void init() {
        this.rn = new Random();
    }

    public void setGaussianMean(double a_mean) {
        this.m_mean = a_mean;
    }

    public void setGaussianStdDeviation(double a_standardDeviation) {
        this.m_standardDeviation = a_standardDeviation;
    }

    public double getGaussianStdDeviation() {
        return this.m_standardDeviation;
    }

    public int nextInt() {
        return Math.min(0x7FFFFFFE, (int)Math.round(this.nextGaussian() * 2.147483647E9));
    }

    public int nextInt(int ceiling) {
        return Math.min(ceiling - 1, (int)Math.round(this.nextGaussian() * (double)ceiling));
    }

    public long nextLong() {
        return Math.min(0x7FFFFFFFFFFFFFFEL, Math.round(this.nextGaussian() * 9.223372036854776E18));
    }

    public double nextDouble() {
        return this.nextGaussian();
    }

    public float nextFloat() {
        return Math.min(Float.MAX_VALUE, (float)(this.nextGaussian() * 3.4028234663852886E38));
    }

    public boolean nextBoolean() {
        return this.nextGaussian() >= 0.5;
    }

    private double nextGaussian() {
        return this.rn.nextGaussian() * this.getGaussianStdDeviation();
    }
}

