/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.StringTokenizer;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.RandomGenerator;
import org.jgap.UnsupportedRepresentationException;
import org.jgap.impl.NumberGene;

public class DoubleGene
extends NumberGene
implements Gene {
    protected static final double DOUBLE_RANGE = Double.MAX_VALUE;
    protected double m_upperBounds;
    protected double m_lowerBounds;
    protected double m_boundsUnitsToDoubleUnits;

    public DoubleGene() {
        this.m_lowerBounds = Double.MIN_VALUE;
        this.m_upperBounds = Double.MAX_VALUE;
        this.calculateBoundsUnitsToDoubleUnitsRatio();
    }

    public DoubleGene(double a_lowerBounds, double a_upperBounds) {
        this.m_lowerBounds = a_lowerBounds;
        this.m_upperBounds = a_upperBounds;
        this.calculateBoundsUnitsToDoubleUnitsRatio();
    }

    public Gene newGene(Configuration a_activeConfiguration) {
        return new DoubleGene(this.m_lowerBounds, this.m_upperBounds);
    }

    public String getPersistentRepresentation() throws UnsupportedOperationException {
        return String.valueOf(this.toString()) + ":" + this.m_lowerBounds + ":" + this.m_upperBounds;
    }

    public void setValueFromPersistentRepresentation(String a_representation) throws UnsupportedRepresentationException {
        if (a_representation != null) {
            StringTokenizer tokenizer = new StringTokenizer(a_representation, ":");
            if (tokenizer.countTokens() != 3) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: it does not contain three tokens.");
            }
            String valueRepresentation = tokenizer.nextToken();
            String lowerBoundRepresentation = tokenizer.nextToken();
            String upperBoundRepresentation = tokenizer.nextToken();
            if (valueRepresentation.equals("null")) {
                this.m_value = null;
            } else {
                try {
                    this.m_value = new Double(Double.parseDouble(valueRepresentation));
                }
                catch (NumberFormatException e) {
                    throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 1 does not appear to be a double value.");
                }
            }
            try {
                this.m_lowerBounds = Double.parseDouble(lowerBoundRepresentation);
            }
            catch (NumberFormatException e) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 2 does not appear to be a double value.");
            }
            try {
                this.m_upperBounds = Double.parseDouble(upperBoundRepresentation);
            }
            catch (NumberFormatException e) {
                throw new UnsupportedRepresentationException("The format of the given persistent representation is not recognized: field 3 does not appear to be a double value.");
            }
            this.calculateBoundsUnitsToDoubleUnitsRatio();
        }
    }

    public double doubleValue() {
        return (Double)this.m_value;
    }

    public void setToRandomValue(RandomGenerator a_numberGenerator) {
        this.m_value = new Double(a_numberGenerator.nextDouble());
        this.mapValueToWithinBounds();
    }

    protected int compareToNative(Object o1, Object o2) {
        return ((Double)o1).compareTo(o2);
    }

    protected void mapValueToWithinBounds() {
        Double d_value;
        if (this.m_value != null && ((d_value = (Double)this.m_value) > this.m_upperBounds || d_value < this.m_lowerBounds)) {
            double differenceFromDoubleMin = Double.MIN_VALUE + d_value;
            double differenceFromBoundsMin = differenceFromDoubleMin / this.m_boundsUnitsToDoubleUnits;
            this.m_value = new Double(this.m_upperBounds + differenceFromBoundsMin);
        }
    }

    protected void calculateBoundsUnitsToDoubleUnitsRatio() {
        double divisor = this.m_upperBounds - this.m_lowerBounds + 1.0;
        this.m_boundsUnitsToDoubleUnits = divisor == 0.0 ? Double.MAX_VALUE : Double.MAX_VALUE / divisor;
    }

    public void applyMutation(int index, double a_percentage) {
        double newValue = this.doubleValue() * (1.0 + a_percentage);
        this.setAllele(new Double(newValue));
    }
}

