/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.StringTokenizer;
import java.util.Vector;
import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.RandomGenerator;
import org.jgap.UnsupportedRepresentationException;

public class CompositeGene
implements Gene {
    private static final String CVS_REVISION = "$Revision: 1.6 $";
    public static final String GENE_DELIMITER = "*";
    private Vector genes = new Vector();

    public void addGene(Gene a_gene) {
        this.addGene(a_gene, false);
    }

    public void addGene(Gene a_gene, boolean strict) {
        if (a_gene instanceof CompositeGene) {
            throw new IllegalArgumentException("It is not allowed to add a CompositeGene to a CompositeGene!");
        }
        boolean containsGene = !strict ? this.containsGeneByIdentity(a_gene) : this.genes.contains(a_gene);
        if (containsGene) {
            throw new IllegalArgumentException("The gene is already contained in the CompositeGene!");
        }
        this.genes.add(a_gene);
    }

    public boolean removeGeneByIdentity(Gene gene) {
        boolean result;
        int size = this.size();
        if (size < 1) {
            result = false;
        } else {
            result = false;
            int i = 0;
            while (i < size) {
                if (this.geneAt(i) == gene) {
                    this.genes.remove(i);
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public boolean removeGene(Gene gene) {
        return this.genes.remove(gene);
    }

    public void cleanup() {
        int i = 0;
        while (i < this.genes.size()) {
            Gene gene = (Gene)this.genes.get(i);
            gene.cleanup();
            ++i;
        }
    }

    public void setToRandomValue(RandomGenerator a_numberGenerator) {
        int i = 0;
        while (i < this.genes.size()) {
            Gene gene = (Gene)this.genes.get(i);
            gene.setToRandomValue(a_numberGenerator);
            ++i;
        }
    }

    public void setValueFromPersistentRepresentation(String a_representation) throws UnsupportedRepresentationException {
        if (a_representation != null) {
            StringTokenizer tokenizer = new StringTokenizer(a_representation, GENE_DELIMITER);
            int numberGenes = tokenizer.countTokens();
            try {
                int i = 0;
                while (i < numberGenes) {
                    String singleGene = tokenizer.nextToken();
                    StringTokenizer geneTypeTokenizer = new StringTokenizer(singleGene, ":");
                    String geneTypeClass = geneTypeTokenizer.nextToken();
                    Class<?> clazz = Class.forName(geneTypeClass);
                    Gene gene = (Gene)clazz.newInstance();
                    String rep = "";
                    while (geneTypeTokenizer.hasMoreTokens()) {
                        if (rep.length() > 0) {
                            rep = String.valueOf(rep) + ":";
                        }
                        rep = String.valueOf(rep) + geneTypeTokenizer.nextToken();
                    }
                    gene.setValueFromPersistentRepresentation(rep);
                    this.addGene(gene);
                    ++i;
                }
            }
            catch (Exception ex) {
                throw new UnsupportedRepresentationException(ex.getCause().getMessage());
            }
        }
    }

    public String getPersistentRepresentation() throws UnsupportedOperationException {
        String result = "";
        int i = 0;
        while (i < this.genes.size()) {
            Gene gene = (Gene)this.genes.get(i);
            result = String.valueOf(result) + gene.getClass().getName();
            result = String.valueOf(result) + ":";
            result = String.valueOf(result) + gene.getPersistentRepresentation();
            if (i < this.genes.size() - 1) {
                result = String.valueOf(result) + GENE_DELIMITER;
            }
            ++i;
        }
        return result;
    }

    public Object getAllele() {
        Vector<Object> alleles = new Vector<Object>();
        int i = 0;
        while (i < this.genes.size()) {
            Gene gene = (Gene)this.genes.get(i);
            alleles.add(gene.getAllele());
            ++i;
        }
        return alleles;
    }

    public void setAllele(Object a_newValue) {
        if (!(a_newValue instanceof Vector)) {
            throw new IllegalArgumentException("The expected type of the allele is a Vector.");
        }
        Vector alleles = (Vector)a_newValue;
        int i = 0;
        while (i < alleles.size()) {
            Gene gene = (Gene)this.genes.get(i);
            gene.setAllele(alleles.elementAt(i));
            ++i;
        }
    }

    public Gene newGene(Configuration a_activeConfiguration) {
        CompositeGene compositeGene = new CompositeGene();
        int geneSize = this.genes.size();
        int i = 0;
        while (i < geneSize) {
            Gene gene = (Gene)this.genes.get(i);
            compositeGene.addGene(gene.newGene(a_activeConfiguration), false);
            ++i;
        }
        return compositeGene;
    }

    public int compareTo(Object other) {
        CompositeGene otherCompositeGene = (CompositeGene)other;
        if (otherCompositeGene == null) {
            return 1;
        }
        if (otherCompositeGene.isEmpty()) {
            return this.isEmpty() ? 0 : 1;
        }
        int numberGenes = Math.min(this.size(), otherCompositeGene.size());
        int i = 0;
        while (i < numberGenes) {
            Gene gene1 = this.geneAt(i);
            Gene gene2 = otherCompositeGene.geneAt(i);
            if (gene1 == null) {
                if (gene2 != null) {
                    return -1;
                }
            } else {
                int result = gene1.compareTo(gene2);
                if (result != 0) {
                    return result;
                }
            }
            ++i;
        }
        if (this.size() == otherCompositeGene.size()) {
            return 0;
        }
        return this.size() > otherCompositeGene.size() ? 1 : -1;
    }

    public boolean equals(Object other) {
        try {
            return this.compareTo(other) == 0;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public String toString() {
        if (this.genes.isEmpty()) {
            return "null";
        }
        String result = "";
        int i = 0;
        while (i < this.genes.size()) {
            Gene gene = (Gene)this.genes.get(i);
            result = String.valueOf(result) + gene;
            if (i < this.genes.size() - 1) {
                result = String.valueOf(result) + GENE_DELIMITER;
            }
            ++i;
        }
        return result;
    }

    public boolean isEmpty() {
        return this.genes.isEmpty();
    }

    public Gene geneAt(int index) {
        return (Gene)this.genes.get(index);
    }

    public int size() {
        return this.genes.size();
    }

    public boolean containsGeneByIdentity(Gene gene) {
        boolean result;
        int size = this.size();
        if (size < 1) {
            result = false;
        } else {
            result = false;
            int i = 0;
            while (i < size) {
                if (this.geneAt(i) == gene) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public void applyMutation(int index, double a_percentage) {
        int i = 0;
        if (i < this.size()) {
            throw new RuntimeException("applyMutation may not be called for a CompositeGene. Call this method for each gene contained in the CompositeGene.");
        }
    }
}

