/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.Random;
import org.jgap.RandomGenerator;

public class CauchyRandomGenerator
implements RandomGenerator {
    private static final String CVS_REVISION = "$Revision: 1.2 $";
    private static final double DELTA = 1.0E-7;
    private double m_standardDistribution;
    private Random rn = new Random();

    public CauchyRandomGenerator() {
        this(1.0);
    }

    public CauchyRandomGenerator(double a_standardDistribution) {
        this.m_standardDistribution = a_standardDistribution;
    }

    private int calculateDensity() {
        double v1 = 10.0 * this.nextDouble() - 5.0;
        double rate = Math.PI * (1.0 + v1 * v1);
        int result = (int)Math.round(rate);
        return result;
    }

    public int nextInt() {
        return Math.min(0x7FFFFFFE, (int)Math.round(this.nextCauchy() * 2.147483647E9));
    }

    public int nextInt(int ceiling) {
        return Math.min(ceiling - 1, (int)Math.round(this.nextCauchy() * (double)ceiling));
    }

    public long nextLong() {
        return Math.min(0x7FFFFFFFFFFFFFFEL, Math.round(this.nextCauchy() * 9.223372036854776E18));
    }

    public double nextDouble() {
        return this.nextCauchy();
    }

    public float nextFloat() {
        return Math.min(Float.MAX_VALUE, (float)(this.nextCauchy() * 3.4028234663852886E38));
    }

    public boolean nextBoolean() {
        return this.nextCauchy() >= 0.5;
    }

    public double nextCauchy() {
        return this.calculateDensity();
    }

    public void setCauchyStandardDeviation(double a_standardDeviation) {
        this.m_standardDistribution = a_standardDeviation;
    }

    public double getCauchyStandardDeviation() {
        return this.m_standardDistribution;
    }
}

