/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import org.jgap.Configuration;
import org.jgap.Gene;
import org.jgap.RandomGenerator;
import org.jgap.UnsupportedRepresentationException;

public class BooleanGene
implements Gene {
    protected static final Boolean TRUE_BOOLEAN = new Boolean(true);
    protected static final Boolean FALSE_BOOLEAN = new Boolean(false);
    protected Boolean m_value = null;

    public Gene newGene(Configuration a_activeConfiguration) {
        return new BooleanGene();
    }

    public void setAllele(Object a_newValue) {
        this.m_value = (Boolean)a_newValue;
    }

    public String getPersistentRepresentation() throws UnsupportedOperationException {
        return this.toString();
    }

    public void setValueFromPersistentRepresentation(String a_representation) throws UnsupportedRepresentationException {
        if (a_representation != null) {
            if (a_representation.equals("null")) {
                this.m_value = null;
            } else if (a_representation.equals("true")) {
                this.m_value = TRUE_BOOLEAN;
            } else if (a_representation.equals("false")) {
                this.m_value = FALSE_BOOLEAN;
            } else {
                throw new UnsupportedRepresentationException("Unknown boolean gene representation: " + a_representation);
            }
        }
    }

    public Object getAllele() {
        return this.m_value;
    }

    public boolean booleanValue() {
        return this.m_value;
    }

    public void setToRandomValue(RandomGenerator a_numberGenerator) {
        this.m_value = a_numberGenerator.nextBoolean() ? TRUE_BOOLEAN : FALSE_BOOLEAN;
    }

    public int compareTo(Object other) {
        BooleanGene otherBooleanGene = (BooleanGene)other;
        if (otherBooleanGene == null) {
            return 1;
        }
        if (otherBooleanGene.m_value == null) {
            return this.m_value == null ? 0 : 1;
        }
        if (!this.m_value.booleanValue()) {
            if (!otherBooleanGene.m_value.booleanValue()) {
                return 0;
            }
            return -1;
        }
        if (otherBooleanGene.m_value.booleanValue()) {
            return 0;
        }
        return 1;
    }

    public boolean equals(Object other) {
        try {
            return this.compareTo(other) == 0;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    public int hashCode() {
        if (this.m_value == null) {
            return 0;
        }
        return this.m_value.hashCode();
    }

    public String toString() {
        if (this.m_value == null) {
            return "null";
        }
        return this.m_value.toString();
    }

    public void cleanup() {
    }

    public int size() {
        return 1;
    }

    public void applyMutation(int index, double a_percentage) {
        if (a_percentage >= 0.0) {
            if (!this.m_value.booleanValue()) {
                this.m_value = new Boolean(true);
            }
        } else if (this.m_value.booleanValue()) {
            this.m_value = new Boolean(false);
        }
    }
}

