/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.NaturalSelector;

public class BestChromosomesSelector
implements NaturalSelector {
    private static final String CVS_REVISION = "$Revision: 1.2 $";
    private List chromosomes = new Vector();
    private boolean needsSorting = false;
    private FitnessValueComparator fitnessValueComparator = new FitnessValueComparator();

    public synchronized void add(Configuration a_activeConfigurator, Chromosome a_chromosomeToAdd) {
        if (this.chromosomes.contains(a_chromosomeToAdd)) {
            return;
        }
        a_chromosomeToAdd.setIsSelectedForNextGeneration(false);
        this.chromosomes.add(a_chromosomeToAdd);
        this.needsSorting = true;
    }

    public synchronized Chromosome[] select(Configuration a_activeConfiguration, int a_howManyToSelect) {
        if (this.needsSorting) {
            Collections.sort(this.chromosomes, this.fitnessValueComparator);
            this.needsSorting = false;
        }
        if (this.chromosomes.size() < a_howManyToSelect) {
            a_howManyToSelect = this.chromosomes.size();
        }
        Chromosome[] selections = new Chromosome[a_howManyToSelect];
        int i = 0;
        while (i < a_howManyToSelect) {
            Chromosome selectedChromosome = (Chromosome)this.chromosomes.get(i);
            selectedChromosome.setIsSelectedForNextGeneration(true);
            selections[i] = selectedChromosome;
            ++i;
        }
        return selections;
    }

    public synchronized void empty() {
        this.chromosomes.clear();
        this.needsSorting = false;
    }

    private class FitnessValueComparator
    implements Comparator {
        FitnessValueComparator() {
        }

        public int compare(Object first, Object second) {
            Chromosome chrom1 = (Chromosome)first;
            Chromosome chrom2 = (Chromosome)second;
            if (chrom1.getFitnessValue() < chrom2.getFitnessValue()) {
                return 1;
            }
            if (chrom1.getFitnessValue() > chrom2.getFitnessValue()) {
                return -1;
            }
            return 0;
        }
    }
}

