/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jgap.BulkFitnessFunction;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.DefaultFitnessEvaluator;
import org.jgap.FitnessEvaluator;
import org.jgap.GeneticOperator;
import org.jgap.InvalidConfigurationException;
import org.jgap.event.GeneticEvent;

public class Genotype
implements Serializable {
    protected transient Configuration m_activeConfiguration;
    protected Chromosome[] m_chromosomes;
    protected transient List m_workingPool;
    private FitnessEvaluator m_fitnessEvaluator;

    public Genotype(Configuration a_activeConfiguration, Chromosome[] a_initialChromosomes) throws InvalidConfigurationException {
        this(a_activeConfiguration, a_initialChromosomes, new DefaultFitnessEvaluator());
    }

    public Genotype(Configuration a_activeConfiguration, Chromosome[] a_initialChromosomes, FitnessEvaluator a_fitnessEvaluator) throws InvalidConfigurationException {
        if (a_activeConfiguration == null) {
            throw new IllegalArgumentException("The Configuration instance may not be null.");
        }
        if (a_initialChromosomes == null) {
            throw new IllegalArgumentException("The array of Chromosomes may not be null.");
        }
        if (a_fitnessEvaluator == null) {
            throw new IllegalArgumentException("The fitness evaluator may not be null.");
        }
        int i = 0;
        while (i < a_initialChromosomes.length) {
            if (a_initialChromosomes[i] == null) {
                throw new IllegalArgumentException("The Gene instance at index " + i + " of the array of " + "Chromosomes is null. No Gene instance in this array " + "may be null.");
            }
            ++i;
        }
        a_activeConfiguration.lockSettings();
        this.m_chromosomes = a_initialChromosomes;
        this.m_activeConfiguration = a_activeConfiguration;
        this.m_fitnessEvaluator = a_fitnessEvaluator;
        this.m_workingPool = new ArrayList();
    }

    public void setActiveConfiguration(Configuration a_activeConfiguration) throws InvalidConfigurationException {
        if (this.m_activeConfiguration == null) {
            if (a_activeConfiguration == null) {
                throw new InvalidConfigurationException("The given Configuration object may not be null.");
            }
            a_activeConfiguration.lockSettings();
            this.m_activeConfiguration = a_activeConfiguration;
            this.m_workingPool = new ArrayList();
            int i = 0;
            while (i < this.m_chromosomes.length) {
                this.m_chromosomes[i].setActiveConfiguration(this.m_activeConfiguration);
                ++i;
            }
        }
    }

    public synchronized Chromosome[] getChromosomes() {
        return this.m_chromosomes;
    }

    public synchronized Chromosome getFittestChromosome() {
        if (this.m_chromosomes.length == 0) {
            return null;
        }
        Chromosome fittestChromosome = this.m_chromosomes[0];
        int fittestValue = fittestChromosome.getFitnessValue();
        int i = 1;
        while (i < this.m_chromosomes.length) {
            if (this.m_fitnessEvaluator.isFitter(this.m_chromosomes[i].getFitnessValue(), fittestValue)) {
                fittestChromosome = this.m_chromosomes[i];
                fittestValue = fittestChromosome.getFitnessValue();
            }
            ++i;
        }
        return fittestChromosome;
    }

    public synchronized void evolve() {
        this.verifyConfigurationAvailable();
        Iterator<Chromosome> iterator1 = Arrays.asList(this.m_chromosomes).iterator();
        while (iterator1.hasNext()) {
            Chromosome currentChromosome = iterator1.next();
            this.m_activeConfiguration.getNaturalSelector().add(this.m_activeConfiguration, currentChromosome);
        }
        if (this.m_activeConfiguration.getNaturalSelectors(true).size() > 0) {
            this.m_chromosomes = this.m_activeConfiguration.getNaturalSelectors(true).get(0).select(this.m_activeConfiguration, this.m_activeConfiguration.getPopulationSize());
            this.m_activeConfiguration.getEventManager().fireGeneticEvent(new GeneticEvent("genotype_evolved_event", this));
            this.m_activeConfiguration.getNaturalSelector().empty();
        }
        List geneticOperators = this.m_activeConfiguration.getGeneticOperators();
        Iterator operatorIterator = geneticOperators.iterator();
        while (operatorIterator.hasNext()) {
            ((GeneticOperator)operatorIterator.next()).operate(this.m_activeConfiguration, this.m_chromosomes, this.m_workingPool);
        }
        BulkFitnessFunction bulkFunction = this.m_activeConfiguration.getBulkFitnessFunction();
        if (bulkFunction != null) {
            Chromosome[] candidateChromosomes = this.m_workingPool.toArray(new Chromosome[this.m_workingPool.size()]);
            bulkFunction.evaluate(candidateChromosomes);
        }
        Iterator iterator = this.m_workingPool.iterator();
        while (iterator.hasNext()) {
            Chromosome currentChromosome = (Chromosome)iterator.next();
            this.m_activeConfiguration.getNaturalSelectors(false).get(0).add(this.m_activeConfiguration, currentChromosome);
        }
        if (this.m_activeConfiguration.getNaturalSelectors(false).size() > 0) {
            this.m_chromosomes = this.m_activeConfiguration.getNaturalSelectors(false).get(0).select(this.m_activeConfiguration, this.m_chromosomes.length);
            this.m_activeConfiguration.getEventManager().fireGeneticEvent(new GeneticEvent("genotype_evolved_event", this));
            Iterator workingPoolIterator = this.m_workingPool.iterator();
            while (workingPoolIterator.hasNext()) {
                Chromosome currentChromosome = (Chromosome)workingPoolIterator.next();
                if (currentChromosome.isSelectedForNextGeneration()) continue;
                currentChromosome.cleanup();
            }
            this.m_workingPool.clear();
            this.m_activeConfiguration.getNaturalSelectors(false).get(0).empty();
        }
    }

    public void evolve(int a_numberOfEvolutions) {
        int i = 0;
        while (i < a_numberOfEvolutions) {
            this.evolve();
            ++i;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.m_chromosomes.length) {
            buffer.append(this.m_chromosomes[i].toString());
            buffer.append(" [");
            buffer.append(this.m_chromosomes[i].getFitnessValue());
            buffer.append(']');
            buffer.append('\n');
            ++i;
        }
        return buffer.toString();
    }

    public static Genotype randomInitialGenotype(Configuration a_activeConfiguration) throws InvalidConfigurationException {
        if (a_activeConfiguration == null) {
            throw new IllegalArgumentException("The Configuration instance may not be null.");
        }
        a_activeConfiguration.lockSettings();
        int populationSize = a_activeConfiguration.getPopulationSize();
        Chromosome[] chromosomes = new Chromosome[populationSize];
        int i = 0;
        while (i < populationSize) {
            chromosomes[i] = Chromosome.randomInitialChromosome(a_activeConfiguration);
            ++i;
        }
        return new Genotype(a_activeConfiguration, chromosomes);
    }

    public boolean equals(Object other) {
        try {
            if (other == null) {
                return false;
            }
            Genotype otherGenotype = (Genotype)other;
            if (this.m_chromosomes.length != otherGenotype.m_chromosomes.length) {
                return false;
            }
            Arrays.sort(this.m_chromosomes);
            Arrays.sort(otherGenotype.m_chromosomes);
            int i = 0;
            while (i < this.m_chromosomes.length) {
                if (!this.m_chromosomes[i].equals(otherGenotype.m_chromosomes[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private void verifyConfigurationAvailable() {
        if (this.m_activeConfiguration == null) {
            throw new IllegalStateException("The active Configuration object must be set on this Genotype prior to invocation of other operations.");
        }
    }

    public FitnessEvaluator getFitnessEvaluator() {
        return this.m_fitnessEvaluator;
    }
}

