/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jgap.BulkFitnessFunction;
import org.jgap.Chromosome;
import org.jgap.FitnessFunction;
import org.jgap.Gene;
import org.jgap.GeneticOperator;
import org.jgap.InvalidConfigurationException;
import org.jgap.NaturalSelector;
import org.jgap.RandomGenerator;
import org.jgap.event.EventManager;
import org.jgap.impl.ChainOfSelectors;
import org.jgap.impl.ChromosomePool;

public class Configuration {
    private FitnessFunction m_objectiveFunction;
    private BulkFitnessFunction m_bulkObjectiveFunction;
    private Chromosome m_sampleChromosome;
    private RandomGenerator m_randomGenerator;
    private EventManager m_eventManager;
    private ChromosomePool m_chromosomePool;
    private List m_geneticOperators = new ArrayList();
    private int m_chromosomeSize;
    private int m_populationSize;
    private boolean m_settingsLocked;
    private ChainOfSelectors m_preSelectors = new ChainOfSelectors();
    private ChainOfSelectors m_postSelectors = new ChainOfSelectors();

    public synchronized void setFitnessFunction(FitnessFunction a_functionToSet) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_functionToSet == null) {
            throw new InvalidConfigurationException("The FitnessFunction instance may not be null.");
        }
        if (this.m_bulkObjectiveFunction != null) {
            throw new InvalidConfigurationException("The bulk fitness function and normal fitness function may not both be set.");
        }
        this.m_objectiveFunction = a_functionToSet;
    }

    public FitnessFunction getFitnessFunction() {
        return this.m_objectiveFunction;
    }

    public synchronized void setBulkFitnessFunction(BulkFitnessFunction a_functionToSet) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_functionToSet == null) {
            throw new InvalidConfigurationException("The BulkFitnessFunction instance may not be null.");
        }
        if (this.m_objectiveFunction != null) {
            throw new InvalidConfigurationException("The bulk fitness function and normal fitness function may not both be set.");
        }
        this.m_bulkObjectiveFunction = a_functionToSet;
    }

    public BulkFitnessFunction getBulkFitnessFunction() {
        return this.m_bulkObjectiveFunction;
    }

    public void setSampleChromosome(Chromosome a_sampleChromosomeToSet) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_sampleChromosomeToSet == null) {
            throw new InvalidConfigurationException("The sample Chromosome instance may not be null.");
        }
        this.m_sampleChromosome = a_sampleChromosomeToSet;
        this.m_chromosomeSize = this.m_sampleChromosome.size();
    }

    public Chromosome getSampleChromosome() {
        return this.m_sampleChromosome;
    }

    public int getChromosomeSize() {
        return this.m_chromosomeSize;
    }

    public synchronized void setNaturalSelector(NaturalSelector a_selectorToSet) throws InvalidConfigurationException {
        this.addNaturalSelector(a_selectorToSet, false);
    }

    public NaturalSelector getNaturalSelector() {
        return this.getNaturalSelectors(false).get(0);
    }

    public ChainOfSelectors getNaturalSelectors(boolean processBeforeGeneticOperators) {
        if (processBeforeGeneticOperators) {
            return this.m_preSelectors;
        }
        return this.m_postSelectors;
    }

    public synchronized void setRandomGenerator(RandomGenerator a_generatorToSet) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_generatorToSet == null) {
            throw new InvalidConfigurationException("The RandomGenerator instance may not be null.");
        }
        this.m_randomGenerator = a_generatorToSet;
    }

    public RandomGenerator getRandomGenerator() {
        return this.m_randomGenerator;
    }

    public synchronized void addGeneticOperator(GeneticOperator a_operatorToAdd) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_operatorToAdd == null) {
            throw new InvalidConfigurationException("The GeneticOperator instance may not be null.");
        }
        this.m_geneticOperators.add(a_operatorToAdd);
    }

    public List getGeneticOperators() {
        return this.m_geneticOperators;
    }

    public synchronized void setPopulationSize(int a_sizeOfPopulation) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_sizeOfPopulation < 1) {
            throw new InvalidConfigurationException("The population size must be positive.");
        }
        this.m_populationSize = a_sizeOfPopulation;
    }

    public int getPopulationSize() {
        return this.m_populationSize;
    }

    public void setEventManager(EventManager a_eventManagerToSet) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (a_eventManagerToSet == null) {
            throw new InvalidConfigurationException("The EventManager instance may not be null.");
        }
        this.m_eventManager = a_eventManagerToSet;
    }

    public EventManager getEventManager() {
        return this.m_eventManager;
    }

    public void setChromosomePool(ChromosomePool a_chromosomePoolToSet) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        this.m_chromosomePool = a_chromosomePoolToSet;
    }

    public ChromosomePool getChromosomePool() {
        return this.m_chromosomePool;
    }

    public synchronized void lockSettings() throws InvalidConfigurationException {
        if (!this.m_settingsLocked) {
            this.verifyStateIsValid();
            this.m_geneticOperators = Collections.unmodifiableList(this.m_geneticOperators);
            this.m_settingsLocked = true;
        }
    }

    public boolean isLocked() {
        return this.m_settingsLocked;
    }

    public synchronized void verifyStateIsValid() throws InvalidConfigurationException {
        if (this.m_objectiveFunction == null && this.m_bulkObjectiveFunction == null) {
            throw new InvalidConfigurationException("A desired fitness function or bulk fitness function must be specified in the active configuration.");
        }
        if (this.m_sampleChromosome == null) {
            throw new InvalidConfigurationException("A sample instance of the desired Chromosome setup must be specified in the active configuration.");
        }
        if (this.m_preSelectors.size() == 0 && this.m_postSelectors.size() == 0) {
            throw new InvalidConfigurationException("At least one desired natural selector must be specified in the active configuration.");
        }
        if (this.m_randomGenerator == null) {
            throw new InvalidConfigurationException("A desired random number generator must be specified in the active configuration.");
        }
        if (this.m_eventManager == null) {
            throw new InvalidConfigurationException("A desired event manager must be specified in the active configuration.");
        }
        if (this.m_geneticOperators.isEmpty()) {
            throw new InvalidConfigurationException("At least one genetic operator must be specified in the configuration.");
        }
        if (this.m_chromosomeSize <= 0) {
            throw new InvalidConfigurationException("A chromosome size greater than zero must be specified in the active configuration.");
        }
        if (this.m_populationSize <= 0) {
            throw new InvalidConfigurationException("A genotype size greater than zero must be specified in the active configuration.");
        }
        Gene[] sampleGenes = this.m_sampleChromosome.getGenes();
        int i = 0;
        while (i < sampleGenes.length) {
            Gene sampleCopy = sampleGenes[i].newGene(this);
            sampleCopy.setAllele(sampleGenes[i].getAllele());
            if (!sampleCopy.equals(sampleGenes[i])) {
                throw new InvalidConfigurationException("The sample Gene at gene position (locus) " + i + " does not appear to have a working equals() method. " + "When tested, the method returned false when comparing " + "the sample gene with a gene of the same type and " + "possessing the same value (allele).");
            }
            ++i;
        }
    }

    protected void verifyChangesAllowed() throws InvalidConfigurationException {
        if (this.m_settingsLocked) {
            throw new InvalidConfigurationException("This Configuration object is locked. Settings may not be altered.");
        }
    }

    public void addNaturalSelector(NaturalSelector a_selector, boolean processBeforeGeneticOperators) throws InvalidConfigurationException {
        this.verifyChangesAllowed();
        if (processBeforeGeneticOperators) {
            this.m_preSelectors.addNaturalSelector(a_selector);
        } else {
            this.m_postSelectors.addNaturalSelector(a_selector);
        }
    }
}

