/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.io.Serializable;
import org.jgap.Configuration;
import org.jgap.FitnessFunction;
import org.jgap.Gene;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.impl.ChromosomePool;

public class Chromosome
implements Comparable,
Cloneable,
Serializable {
    protected transient Configuration m_activeConfiguration = null;
    private Object m_applicationData = null;
    protected Gene[] m_genes = null;
    protected boolean m_isSelectedForNextGeneration = false;
    protected int m_fitnessValue = -1;
    private int m_hashCode = 0;

    public Chromosome(Gene a_sampleGene, int a_desiredSize) {
        if (a_sampleGene == null) {
            throw new IllegalArgumentException("Sample Gene cannot be null.");
        }
        if (a_desiredSize <= 0) {
            throw new IllegalArgumentException("Chromosome size must be positive.");
        }
        this.m_genes = new Gene[a_desiredSize];
        int i = 0;
        while (i < this.m_genes.length) {
            this.m_genes[i] = a_sampleGene.newGene(null);
            ++i;
        }
        this.m_activeConfiguration = null;
    }

    public Chromosome(Gene[] a_initialGenes) {
        if (a_initialGenes == null) {
            throw new IllegalArgumentException("The given array of genes cannot be null.");
        }
        int i = 0;
        while (i < a_initialGenes.length) {
            if (a_initialGenes[i] == null) {
                throw new IllegalArgumentException("The gene at index " + i + " in the given array of " + "genes was found to be null. No genes in the array " + "may be null.");
            }
            ++i;
        }
        this.m_genes = a_initialGenes;
        this.m_activeConfiguration = null;
    }

    public Chromosome(Configuration a_activeConfiguration, Gene[] a_initialGenes) throws InvalidConfigurationException {
        if (a_initialGenes == null) {
            throw new IllegalArgumentException("The given array of genes cannot be null.");
        }
        int i = 0;
        while (i < a_initialGenes.length) {
            if (a_initialGenes[i] == null) {
                throw new IllegalArgumentException("The gene at index " + i + " in the given array of " + "genes was found to be null. No genes in the array " + "may be null.");
            }
            ++i;
        }
        if (a_activeConfiguration == null) {
            throw new InvalidConfigurationException("Configuration instance must not be null");
        }
        a_activeConfiguration.lockSettings();
        this.m_activeConfiguration = a_activeConfiguration;
        this.m_genes = a_initialGenes;
    }

    public void setActiveConfiguration(Configuration a_activeConfiguration) throws InvalidConfigurationException {
        if (this.m_activeConfiguration == null) {
            if (a_activeConfiguration == null) {
                throw new InvalidConfigurationException("The given Configuration object may not be null.");
            }
            a_activeConfiguration.lockSettings();
            this.m_activeConfiguration = a_activeConfiguration;
        }
    }

    public synchronized Object clone() {
        Chromosome copy;
        if (this.m_activeConfiguration == null) {
            throw new IllegalStateException("The active Configuration object must be set on this Chromosome prior to invocation of the clone() method.");
        }
        ChromosomePool pool = this.m_activeConfiguration.getChromosomePool();
        if (pool != null && (copy = pool.acquireChromosome()) != null) {
            Gene[] genes = copy.getGenes();
            int i = 0;
            while (i < genes.length) {
                genes[i].setAllele(this.m_genes[i].getAllele());
                ++i;
            }
            return copy;
        }
        Gene[] copyOfGenes = new Gene[this.m_genes.length];
        int i = 0;
        while (i < copyOfGenes.length) {
            copyOfGenes[i] = this.m_genes[i].newGene(this.m_activeConfiguration);
            copyOfGenes[i].setAllele(this.m_genes[i].getAllele());
            ++i;
        }
        try {
            return new Chromosome(this.m_activeConfiguration, copyOfGenes);
        }
        catch (InvalidConfigurationException e) {
            throw new RuntimeException("Fatal Error: clone method produced an InvalidConfigurationException. This should never happen.Please report this as a bug to the JGAP team.");
        }
    }

    public synchronized Gene getGene(int a_desiredLocus) {
        return this.m_genes[a_desiredLocus];
    }

    public synchronized Gene[] getGenes() {
        return this.m_genes;
    }

    public int size() {
        return this.m_genes.length;
    }

    public int getFitnessValue() {
        if (this.m_fitnessValue < 0) {
            if (this.m_activeConfiguration == null) {
                throw new IllegalStateException("The active Configuration object must be set on this Chromosome prior to invocation of the getFitnessValue() method.");
            }
            FitnessFunction normalFitnessFunction = this.m_activeConfiguration.getFitnessFunction();
            if (normalFitnessFunction != null) {
                this.m_fitnessValue = normalFitnessFunction.getFitnessValue(this);
            }
        }
        return this.m_fitnessValue;
    }

    public void setFitnessValue(int a_newFitnessValue) {
        if (a_newFitnessValue > 0) {
            this.m_fitnessValue = a_newFitnessValue;
        }
    }

    public String toString() {
        StringBuffer representation = new StringBuffer();
        representation.append("[ ");
        int i = 0;
        while (i < this.m_genes.length - 1) {
            representation.append(this.m_genes[i].toString());
            representation.append(", ");
            ++i;
        }
        representation.append(this.m_genes[this.m_genes.length - 1].toString());
        representation.append(" ]");
        return representation.toString();
    }

    public static Chromosome randomInitialChromosome(Configuration a_activeConfiguration) throws InvalidConfigurationException {
        Chromosome randomChromosome;
        if (a_activeConfiguration == null) {
            throw new IllegalArgumentException("Configuration instance must not be null");
        }
        a_activeConfiguration.lockSettings();
        ChromosomePool pool = a_activeConfiguration.getChromosomePool();
        if (pool != null && (randomChromosome = pool.acquireChromosome()) != null) {
            Gene[] genes = randomChromosome.getGenes();
            RandomGenerator generator = a_activeConfiguration.getRandomGenerator();
            int i = 0;
            while (i < genes.length) {
                genes[i].setToRandomValue(generator);
                ++i;
            }
            return randomChromosome;
        }
        Chromosome sampleChromosome = a_activeConfiguration.getSampleChromosome();
        Gene[] sampleGenes = sampleChromosome.getGenes();
        Gene[] newGenes = new Gene[sampleGenes.length];
        RandomGenerator generator = a_activeConfiguration.getRandomGenerator();
        int i = 0;
        while (i < newGenes.length) {
            newGenes[i] = sampleGenes[i].newGene(a_activeConfiguration);
            newGenes[i].setToRandomValue(generator);
            ++i;
        }
        return new Chromosome(a_activeConfiguration, newGenes);
    }

    public boolean equals(Object other) {
        if (other != null && !this.getClass().getName().equals(other.getClass().getName())) {
            return false;
        }
        try {
            return this.compareTo(other) == 0;
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    public int hashCode() {
        if (this.m_hashCode == 0) {
            int i = 0;
            while (i < this.m_genes.length) {
                this.m_hashCode ^= this.m_genes[i].hashCode();
                ++i;
            }
        }
        return this.m_hashCode;
    }

    public int compareTo(Object other) {
        if (other == null) {
            return 1;
        }
        Chromosome otherChromosome = (Chromosome)other;
        Gene[] otherGenes = otherChromosome.m_genes;
        if (otherGenes.length != this.m_genes.length) {
            return this.m_genes.length - otherGenes.length;
        }
        int i = 0;
        while (i < this.m_genes.length) {
            int comparison = this.m_genes[i].compareTo(otherGenes[i]);
            if (comparison != 0) {
                return comparison;
            }
            ++i;
        }
        return 0;
    }

    public void setIsSelectedForNextGeneration(boolean a_isSelected) {
        this.m_isSelectedForNextGeneration = a_isSelected;
    }

    public boolean isSelectedForNextGeneration() {
        return this.m_isSelectedForNextGeneration;
    }

    public void cleanup() {
        this.m_fitnessValue = -1;
        this.m_hashCode = 0;
        this.m_isSelectedForNextGeneration = false;
        if (this.m_activeConfiguration == null) {
            throw new IllegalStateException("The active Configuration object must be set on this Chromosome prior to invocation of the cleanup() method.");
        }
        ChromosomePool pool = this.m_activeConfiguration.getChromosomePool();
        if (pool != null) {
            pool.releaseChromosome(this);
        } else {
            int i = 0;
            while (i < this.m_genes.length) {
                this.m_genes[i].cleanup();
                ++i;
            }
        }
    }

    public void setApplicationData(Object a_newData) {
        this.m_applicationData = a_newData;
    }

    public Object getApplicationData() {
        return this.m_applicationData;
    }
}

