/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.$Stack;
import com.bulletphysics.collision.shapes.ConvexShape;
import com.bulletphysics.linearmath.MiscUtil;
import com.bulletphysics.linearmath.convexhull.HullDesc;
import com.bulletphysics.linearmath.convexhull.HullFlags;
import com.bulletphysics.linearmath.convexhull.HullLibrary;
import com.bulletphysics.linearmath.convexhull.HullResult;
import com.bulletphysics.util.IntArrayList;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeHull {
    protected List<Vector3f> vertices = new ArrayList<Vector3f>();
    protected IntArrayList indices = new IntArrayList();
    protected int numIndices;
    protected ConvexShape shape;
    private static int NUM_UNITSPHERE_POINTS = 42;
    private static List<Vector3f> unitSpherePoints = new ArrayList<Vector3f>();

    public ShapeHull(ConvexShape shape) {
        this.shape = shape;
        this.vertices.clear();
        this.indices.clear();
        this.numIndices = 0;
    }

    public boolean buildHull(float f) {
        $Stack $Stack = $Stack.INSTANCE;
        try {
            int i;
            int i2;
            $Stack.push$javax$vecmath$Vector3f();
            Vector3f norm = $Stack.get$javax$vecmath$Vector3f();
            int numSampleDirections = NUM_UNITSPHERE_POINTS;
            int numPDA = this.shape.getNumPreferredPenetrationDirections();
            if (numPDA != 0) {
                for (i2 = 0; i2 < numPDA; ++i2) {
                    this.shape.getPreferredPenetrationDirection(i2, norm);
                    unitSpherePoints.get(numSampleDirections).set((Tuple3f)norm);
                    ++numSampleDirections;
                }
            }
            ArrayList<Vector3f> supportPoints = new ArrayList<Vector3f>();
            MiscUtil.resize(supportPoints, NUM_UNITSPHERE_POINTS + 20, Vector3f.class);
            for (i2 = 0; i2 < numSampleDirections; ++i2) {
                this.shape.localGetSupportingVertex(unitSpherePoints.get(i2), (Vector3f)supportPoints.get(i2));
            }
            HullDesc hd = new HullDesc();
            hd.flags = HullFlags.TRIANGLES;
            hd.vcount = numSampleDirections;
            hd.vertices = supportPoints;
            HullLibrary hl = new HullLibrary();
            HullResult hr = new HullResult();
            if (!hl.createConvexHull(hd, hr)) {
                $Stack.pop$javax$vecmath$Vector3f();
                return false;
            }
            MiscUtil.resize(this.vertices, hr.numOutputVertices, Vector3f.class);
            for (i = 0; i < hr.numOutputVertices; ++i) {
                this.vertices.get(i).set((Tuple3f)hr.outputVertices.get(i));
            }
            this.numIndices = hr.numIndices;
            MiscUtil.resize(this.indices, this.numIndices, 0);
            for (i = 0; i < this.numIndices; ++i) {
                this.indices.set(i, hr.indices.get(i));
            }
            hl.releaseResult(hr);
            $Stack.pop$javax$vecmath$Vector3f();
            return true;
        }
        catch (Throwable throwable) {
            $Stack.pop$javax$vecmath$Vector3f();
            throw throwable;
        }
    }

    public int numTriangles() {
        return this.numIndices / 3;
    }

    public int numVertices() {
        return this.vertices.size();
    }

    public int numIndices() {
        return this.numIndices;
    }

    public List<Vector3f> getVertexPointer() {
        return this.vertices;
    }

    public IntArrayList getIndexPointer() {
        return this.indices;
    }

    static {
        unitSpherePoints.add(new Vector3f(0.0f, -0.0f, -1.0f));
        unitSpherePoints.add(new Vector3f(0.723608f, -0.525725f, -0.447219f));
        unitSpherePoints.add(new Vector3f(-0.276388f, -0.850649f, -0.447219f));
        unitSpherePoints.add(new Vector3f(-0.894426f, -0.0f, -0.447216f));
        unitSpherePoints.add(new Vector3f(-0.276388f, 0.850649f, -0.44722f));
        unitSpherePoints.add(new Vector3f(0.723608f, 0.525725f, -0.447219f));
        unitSpherePoints.add(new Vector3f(0.276388f, -0.850649f, 0.44722f));
        unitSpherePoints.add(new Vector3f(-0.723608f, -0.525725f, 0.447219f));
        unitSpherePoints.add(new Vector3f(-0.723608f, 0.525725f, 0.447219f));
        unitSpherePoints.add(new Vector3f(0.276388f, 0.850649f, 0.447219f));
        unitSpherePoints.add(new Vector3f(0.894426f, 0.0f, 0.447216f));
        unitSpherePoints.add(new Vector3f(-0.0f, 0.0f, 1.0f));
        unitSpherePoints.add(new Vector3f(0.425323f, -0.309011f, -0.850654f));
        unitSpherePoints.add(new Vector3f(-0.162456f, -0.499995f, -0.850654f));
        unitSpherePoints.add(new Vector3f(0.262869f, -0.809012f, -0.525738f));
        unitSpherePoints.add(new Vector3f(0.425323f, 0.309011f, -0.850654f));
        unitSpherePoints.add(new Vector3f(0.850648f, -0.0f, -0.525736f));
        unitSpherePoints.add(new Vector3f(-0.52573f, -0.0f, -0.850652f));
        unitSpherePoints.add(new Vector3f(-0.68819f, -0.499997f, -0.525736f));
        unitSpherePoints.add(new Vector3f(-0.162456f, 0.499995f, -0.850654f));
        unitSpherePoints.add(new Vector3f(-0.68819f, 0.499997f, -0.525736f));
        unitSpherePoints.add(new Vector3f(0.262869f, 0.809012f, -0.525738f));
        unitSpherePoints.add(new Vector3f(0.951058f, 0.309013f, 0.0f));
        unitSpherePoints.add(new Vector3f(0.951058f, -0.309013f, 0.0f));
        unitSpherePoints.add(new Vector3f(0.587786f, -0.809017f, 0.0f));
        unitSpherePoints.add(new Vector3f(0.0f, -1.0f, 0.0f));
        unitSpherePoints.add(new Vector3f(-0.587786f, -0.809017f, 0.0f));
        unitSpherePoints.add(new Vector3f(-0.951058f, -0.309013f, -0.0f));
        unitSpherePoints.add(new Vector3f(-0.951058f, 0.309013f, -0.0f));
        unitSpherePoints.add(new Vector3f(-0.587786f, 0.809017f, -0.0f));
        unitSpherePoints.add(new Vector3f(-0.0f, 1.0f, -0.0f));
        unitSpherePoints.add(new Vector3f(0.587786f, 0.809017f, -0.0f));
        unitSpherePoints.add(new Vector3f(0.68819f, -0.499997f, 0.525736f));
        unitSpherePoints.add(new Vector3f(-0.262869f, -0.809012f, 0.525738f));
        unitSpherePoints.add(new Vector3f(-0.850648f, 0.0f, 0.525736f));
        unitSpherePoints.add(new Vector3f(-0.262869f, 0.809012f, 0.525738f));
        unitSpherePoints.add(new Vector3f(0.68819f, 0.499997f, 0.525736f));
        unitSpherePoints.add(new Vector3f(0.52573f, 0.0f, 0.850652f));
        unitSpherePoints.add(new Vector3f(0.162456f, -0.499995f, 0.850654f));
        unitSpherePoints.add(new Vector3f(-0.425323f, -0.309011f, 0.850654f));
        unitSpherePoints.add(new Vector3f(-0.425323f, 0.309011f, 0.850654f));
        unitSpherePoints.add(new Vector3f(0.162456f, 0.499995f, 0.850654f));
        MiscUtil.resize(unitSpherePoints, NUM_UNITSPHERE_POINTS + 20, Vector3f.class);
    }
}

