/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.shapes;

import com.bulletphysics.$Stack;
import com.bulletphysics.collision.broadphase.BroadphaseNativeType;
import com.bulletphysics.collision.shapes.CollisionShape;
import com.bulletphysics.collision.shapes.CompoundShapeChild;
import com.bulletphysics.collision.shapes.OptimizedBvh;
import com.bulletphysics.linearmath.MatrixUtil;
import com.bulletphysics.linearmath.Transform;
import com.bulletphysics.linearmath.VectorUtil;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundShape
extends CollisionShape {
    private final List<CompoundShapeChild> children = new ArrayList<CompoundShapeChild>();
    private final Vector3f localAabbMin = new Vector3f(1.0E30f, 1.0E30f, 1.0E30f);
    private final Vector3f localAabbMax = new Vector3f(-1.0E30f, -1.0E30f, -1.0E30f);
    private OptimizedBvh aabbTree = null;
    private float collisionMargin = 0.0f;
    protected final Vector3f localScaling = new Vector3f(1.0f, 1.0f, 1.0f);

    /*
     * WARNING - void declaration
     */
    public void addChildShape(Transform transform, CollisionShape collisionShape) {
        $Stack $Stack = $Stack.INSTANCE;
        try {
            void shape;
            void localTransform;
            $Stack.push$javax$vecmath$Vector3f();
            CompoundShapeChild child = new CompoundShapeChild();
            child.transform.set((Transform)localTransform);
            child.childShape = shape;
            child.childShapeType = shape.getShapeType();
            child.childMargin = shape.getMargin();
            this.children.add(child);
            Vector3f _localAabbMin = $Stack.get$javax$vecmath$Vector3f();
            Vector3f _localAabbMax = $Stack.get$javax$vecmath$Vector3f();
            shape.getAabb((Transform)localTransform, _localAabbMin, _localAabbMax);
            VectorUtil.setMin(this.localAabbMin, _localAabbMin);
            VectorUtil.setMax(this.localAabbMax, _localAabbMax);
            $Stack.pop$javax$vecmath$Vector3f();
            return;
        }
        catch (Throwable throwable) {
            $Stack.pop$javax$vecmath$Vector3f();
            throw throwable;
        }
    }

    public void removeChildShape(CollisionShape shape) {
        boolean done_removing;
        block0: do {
            done_removing = true;
            for (int i = 0; i < this.children.size(); ++i) {
                if (this.children.get((int)i).childShape != shape) continue;
                this.children.remove(i);
                done_removing = false;
                continue block0;
            }
        } while (!done_removing);
        this.recalculateLocalAabb();
    }

    public int getNumChildShapes() {
        return this.children.size();
    }

    public CollisionShape getChildShape(int index) {
        return this.children.get((int)index).childShape;
    }

    public Transform getChildTransform(int index, Transform out) {
        out.set(this.children.get((int)index).transform);
        return out;
    }

    public List<CompoundShapeChild> getChildList() {
        return this.children;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void getAabb(Transform transform, Vector3f vector3f, Vector3f vector3f2) {
        $Stack $Stack = $Stack.INSTANCE;
        try {
            void aabbMax;
            void aabbMin;
            void trans;
            $Stack $Stack2 = $Stack;
            $Stack2.push$javax$vecmath$Vector3f();
            $Stack2.push$javax$vecmath$Matrix3f();
            Vector3f localHalfExtents = $Stack.get$javax$vecmath$Vector3f();
            localHalfExtents.sub((Tuple3f)this.localAabbMax, (Tuple3f)this.localAabbMin);
            localHalfExtents.scale(0.5f);
            Vector3f localCenter = $Stack.get$javax$vecmath$Vector3f();
            localCenter.add((Tuple3f)this.localAabbMax, (Tuple3f)this.localAabbMin);
            localCenter.scale(0.5f);
            Matrix3f abs_b = $Stack.get$javax$vecmath$Matrix3f(trans.basis);
            MatrixUtil.absolute(abs_b);
            Vector3f center = $Stack.get$javax$vecmath$Vector3f(localCenter);
            trans.transform(center);
            Vector3f tmp = $Stack.get$javax$vecmath$Vector3f();
            Vector3f extent = $Stack.get$javax$vecmath$Vector3f();
            abs_b.getRow(0, tmp);
            extent.x = tmp.dot(localHalfExtents);
            abs_b.getRow(1, tmp);
            extent.y = tmp.dot(localHalfExtents);
            abs_b.getRow(2, tmp);
            extent.z = tmp.dot(localHalfExtents);
            extent.x += this.getMargin();
            extent.y += this.getMargin();
            extent.z += this.getMargin();
            aabbMin.sub((Tuple3f)center, (Tuple3f)extent);
            aabbMax.add((Tuple3f)center, (Tuple3f)extent);
            $Stack $Stack3 = $Stack;
            $Stack3.pop$javax$vecmath$Vector3f();
            $Stack3.pop$javax$vecmath$Matrix3f();
            return;
        }
        catch (Throwable throwable) {
            $Stack $Stack4 = $Stack;
            $Stack4.pop$javax$vecmath$Vector3f();
            $Stack4.pop$javax$vecmath$Matrix3f();
            throw throwable;
        }
    }

    public void recalculateLocalAabb() {
        $Stack $Stack = $Stack.INSTANCE;
        try {
            $Stack.push$javax$vecmath$Vector3f();
            this.localAabbMin.set(1.0E30f, 1.0E30f, 1.0E30f);
            this.localAabbMax.set(-1.0E30f, -1.0E30f, -1.0E30f);
            Vector3f tmpLocalAabbMin = $Stack.get$javax$vecmath$Vector3f();
            Vector3f tmpLocalAabbMax = $Stack.get$javax$vecmath$Vector3f();
            for (int j = 0; j < this.children.size(); ++j) {
                this.children.get((int)j).childShape.getAabb(this.children.get((int)j).transform, tmpLocalAabbMin, tmpLocalAabbMax);
                for (int i = 0; i < 3; ++i) {
                    if (VectorUtil.getCoord(this.localAabbMin, i) > VectorUtil.getCoord(tmpLocalAabbMin, i)) {
                        VectorUtil.setCoord(this.localAabbMin, i, VectorUtil.getCoord(tmpLocalAabbMin, i));
                    }
                    if (!(VectorUtil.getCoord(this.localAabbMax, i) < VectorUtil.getCoord(tmpLocalAabbMax, i))) continue;
                    VectorUtil.setCoord(this.localAabbMax, i, VectorUtil.getCoord(tmpLocalAabbMax, i));
                }
            }
            $Stack.pop$javax$vecmath$Vector3f();
            return;
        }
        catch (Throwable throwable) {
            $Stack.pop$javax$vecmath$Vector3f();
            throw throwable;
        }
    }

    @Override
    public void setLocalScaling(Vector3f scaling) {
        this.localScaling.set((Tuple3f)scaling);
    }

    @Override
    public Vector3f getLocalScaling(Vector3f out) {
        out.set((Tuple3f)this.localScaling);
        return out;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void calculateLocalInertia(float f, Vector3f vector3f) {
        $Stack $Stack = $Stack.INSTANCE;
        try {
            void mass;
            $Stack $Stack2 = $Stack;
            $Stack2.push$com$bulletphysics$linearmath$Transform();
            $Stack2.push$javax$vecmath$Vector3f();
            Transform ident = $Stack.get$com$bulletphysics$linearmath$Transform();
            ident.setIdentity();
            Vector3f aabbMin = $Stack.get$javax$vecmath$Vector3f();
            Vector3f aabbMax = $Stack.get$javax$vecmath$Vector3f();
            this.getAabb(ident, aabbMin, aabbMax);
            Vector3f halfExtents = $Stack.get$javax$vecmath$Vector3f();
            halfExtents.sub((Tuple3f)aabbMax, (Tuple3f)aabbMin);
            halfExtents.scale(0.5f);
            float lx = 2.0f * halfExtents.x;
            float ly = 2.0f * halfExtents.y;
            float lz = 2.0f * halfExtents.z;
            inertia.x = mass / 12.0f * (ly * ly + lz * lz);
            inertia.y = mass / 12.0f * (lx * lx + lz * lz);
            inertia.z = mass / 12.0f * (lx * lx + ly * ly);
            $Stack $Stack3 = $Stack;
            $Stack3.pop$com$bulletphysics$linearmath$Transform();
            $Stack3.pop$javax$vecmath$Vector3f();
            return;
        }
        catch (Throwable throwable) {
            $Stack $Stack4 = $Stack;
            $Stack4.pop$com$bulletphysics$linearmath$Transform();
            $Stack4.pop$javax$vecmath$Vector3f();
            throw throwable;
        }
    }

    @Override
    public BroadphaseNativeType getShapeType() {
        return BroadphaseNativeType.COMPOUND_SHAPE_PROXYTYPE;
    }

    @Override
    public void setMargin(float margin) {
        this.collisionMargin = margin;
    }

    @Override
    public float getMargin() {
        return this.collisionMargin;
    }

    @Override
    public String getName() {
        return "Compound";
    }

    public OptimizedBvh getAabbTree() {
        return this.aabbTree;
    }
}

