/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics.collision.narrowphase;

import com.bulletphysics.BulletStats;
import com.bulletphysics.collision.narrowphase.ConvexPenetrationDepthSolver;
import com.bulletphysics.collision.narrowphase.DiscreteCollisionDetectorInterface;
import com.bulletphysics.collision.narrowphase.SimplexSolverInterface;
import com.bulletphysics.collision.shapes.ConvexShape;
import com.bulletphysics.linearmath.IDebugDraw;
import com.bulletphysics.linearmath.MatrixUtil;
import com.bulletphysics.linearmath.Transform;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

public class GjkPairDetector
extends DiscreteCollisionDetectorInterface {
    private static final float REL_ERROR2 = 1.0E-6f;
    private final Vector3f cachedSeparatingAxis = new Vector3f();
    private ConvexPenetrationDepthSolver penetrationDepthSolver;
    private SimplexSolverInterface simplexSolver;
    private ConvexShape minkowskiA;
    private ConvexShape minkowskiB;
    private boolean ignoreMargin;
    public int lastUsedMethod;
    public int curIter;
    public int degenerateSimplex;
    public int catchDegeneracies;
    private static final Vector3f $stackTemp0 = new Vector3f();
    private static final Vector3f $stackTemp1 = new Vector3f();
    private static final Vector3f $stackTemp2 = new Vector3f();
    private static final Vector3f $stackTemp3 = new Vector3f();
    private static final Transform $stackTemp4 = new Transform();
    private static final Transform $stackTemp5 = new Transform();
    private static final Vector3f $stackTemp6 = new Vector3f();
    private static final Vector3f $stackTemp7 = new Vector3f();
    private static final Vector3f $stackTemp8 = new Vector3f();
    private static final Vector3f $stackTemp9 = new Vector3f();
    private static final Vector3f $stackTemp10 = new Vector3f();
    private static final Vector3f $stackTemp11 = new Vector3f();
    private static final Vector3f $stackTemp12 = new Vector3f();
    private static final Vector3f $stackTemp13 = new Vector3f();
    private static final Vector3f $stackTemp14 = new Vector3f();
    private static final Vector3f $stackTemp15 = new Vector3f();
    private static final Vector3f $stackTemp16 = new Vector3f();

    public void init(ConvexShape objectA, ConvexShape objectB, SimplexSolverInterface simplexSolver, ConvexPenetrationDepthSolver penetrationDepthSolver) {
        this.cachedSeparatingAxis.set(0.0f, 0.0f, 1.0f);
        this.ignoreMargin = false;
        this.lastUsedMethod = -1;
        this.catchDegeneracies = 1;
        this.penetrationDepthSolver = penetrationDepthSolver;
        this.simplexSolver = simplexSolver;
        this.minkowskiA = objectA;
        this.minkowskiB = objectB;
    }

    public void getClosestPoints(DiscreteCollisionDetectorInterface.ClosestPointInput input, DiscreteCollisionDetectorInterface.Result output, IDebugDraw debugDraw, boolean swapResults) {
        boolean catchDegeneratePenetrationCase;
        Vector3f tmpNormalInB;
        Vector3f tmpPointOnB;
        Vector3f tmpPointOnA;
        float margin;
        float squaredDistance;
        boolean checkPenetration;
        boolean checkSimplex;
        boolean isValid;
        float marginB;
        float marginA;
        Vector3f positionOffset;
        Transform localTransB;
        Transform localTransA;
        Vector3f pointOnB;
        Vector3f pointOnA;
        Vector3f normalInB;
        float distance;
        Vector3f tmp;
        block21: {
            boolean check;
            tmp = $stackTemp0;
            distance = 0.0f;
            normalInB = $stackTemp1;
            normalInB.set(0.0f, 0.0f, 0.0f);
            pointOnA = $stackTemp2;
            pointOnB = $stackTemp3;
            Transform transform = $stackTemp4;
            transform.set(input.transformA);
            localTransA = transform;
            Transform transform2 = $stackTemp5;
            transform2.set(input.transformB);
            localTransB = transform2;
            positionOffset = $stackTemp6;
            positionOffset.add((Tuple3f)localTransA.origin, (Tuple3f)localTransB.origin);
            positionOffset.scale(0.5f);
            localTransA.origin.sub((Tuple3f)positionOffset);
            localTransB.origin.sub((Tuple3f)positionOffset);
            marginA = this.minkowskiA.getMargin();
            marginB = this.minkowskiB.getMargin();
            ++BulletStats.gNumGjkChecks;
            if (this.ignoreMargin) {
                marginA = 0.0f;
                marginB = 0.0f;
            }
            this.curIter = 0;
            int gGjkMaxIter = 1000;
            this.cachedSeparatingAxis.set(0.0f, 1.0f, 0.0f);
            isValid = false;
            checkSimplex = false;
            checkPenetration = true;
            this.degenerateSimplex = 0;
            this.lastUsedMethod = -1;
            squaredDistance = Float.MAX_VALUE;
            float delta = 0.0f;
            margin = marginA + marginB;
            this.simplexSolver.reset();
            Vector3f seperatingAxisInA = $stackTemp7;
            Vector3f seperatingAxisInB = $stackTemp8;
            Vector3f pInA = $stackTemp9;
            Vector3f qInB = $stackTemp10;
            Vector3f pWorld = $stackTemp11;
            Vector3f qWorld = $stackTemp12;
            Vector3f w = $stackTemp13;
            tmpPointOnA = $stackTemp14;
            tmpPointOnB = $stackTemp15;
            tmpNormalInB = $stackTemp16;
            do {
                seperatingAxisInA.negate((Tuple3f)this.cachedSeparatingAxis);
                MatrixUtil.transposeTransform(seperatingAxisInA, seperatingAxisInA, input.transformA.basis);
                seperatingAxisInB.set((Tuple3f)this.cachedSeparatingAxis);
                MatrixUtil.transposeTransform(seperatingAxisInB, seperatingAxisInB, input.transformB.basis);
                this.minkowskiA.localGetSupportingVertexWithoutMargin(seperatingAxisInA, pInA);
                this.minkowskiB.localGetSupportingVertexWithoutMargin(seperatingAxisInB, qInB);
                pWorld.set((Tuple3f)pInA);
                localTransA.transform(pWorld);
                qWorld.set((Tuple3f)qInB);
                localTransB.transform(qWorld);
                w.sub((Tuple3f)pWorld, (Tuple3f)qWorld);
                delta = this.cachedSeparatingAxis.dot(w);
                if (delta > 0.0f && delta * delta > squaredDistance * input.maximumDistanceSquared) {
                    checkPenetration = false;
                    break block21;
                }
                if (this.simplexSolver.inSimplex(w)) {
                    this.degenerateSimplex = 1;
                    checkSimplex = true;
                    break block21;
                }
                float f0 = squaredDistance - delta;
                float f1 = squaredDistance * 1.0E-6f;
                if (f0 <= f1) {
                    if (f0 <= 0.0f) {
                        this.degenerateSimplex = 2;
                    }
                    checkSimplex = true;
                    break block21;
                }
                this.simplexSolver.addVertex(w, pWorld, qWorld);
                if (!this.simplexSolver.closest(this.cachedSeparatingAxis)) {
                    this.degenerateSimplex = 3;
                    checkSimplex = true;
                    break block21;
                }
                if (this.cachedSeparatingAxis.lengthSquared() < 1.0E-6f) {
                    this.degenerateSimplex = 6;
                    checkSimplex = true;
                    break block21;
                }
                float previousSquaredDistance = squaredDistance;
                if (previousSquaredDistance - (squaredDistance = this.cachedSeparatingAxis.lengthSquared()) <= 1.1920929E-7f * previousSquaredDistance) {
                    this.simplexSolver.backup_closest(this.cachedSeparatingAxis);
                    checkSimplex = true;
                    break block21;
                }
                if (this.curIter++ > gGjkMaxIter) break block21;
            } while (check = !this.simplexSolver.fullSimplex());
            this.simplexSolver.backup_closest(this.cachedSeparatingAxis);
        }
        if (checkSimplex) {
            this.simplexSolver.compute_points(pointOnA, pointOnB);
            normalInB.sub((Tuple3f)pointOnA, (Tuple3f)pointOnB);
            float lenSqr = this.cachedSeparatingAxis.lengthSquared();
            if (lenSqr < 1.0E-4f) {
                this.degenerateSimplex = 5;
            }
            if (lenSqr > 1.4210855E-14f) {
                float rlen = 1.0f / (float)Math.sqrt(lenSqr);
                normalInB.scale(rlen);
                float s = (float)Math.sqrt(squaredDistance);
                assert (s > 0.0f);
                tmp.scale(marginA / s, (Tuple3f)this.cachedSeparatingAxis);
                pointOnA.sub((Tuple3f)tmp);
                tmp.scale(marginB / s, (Tuple3f)this.cachedSeparatingAxis);
                pointOnB.add((Tuple3f)tmp);
                distance = 1.0f / rlen - margin;
                isValid = true;
                this.lastUsedMethod = 1;
            } else {
                this.lastUsedMethod = 2;
            }
        }
        boolean bl = catchDegeneratePenetrationCase = this.catchDegeneracies != 0 && this.penetrationDepthSolver != null && this.degenerateSimplex != 0 && distance + margin < 0.01f;
        if (checkPenetration && (!isValid || catchDegeneratePenetrationCase) && this.penetrationDepthSolver != null) {
            ++BulletStats.gNumDeepPenetrationChecks;
            boolean isValid2 = this.penetrationDepthSolver.calcPenDepth(this.simplexSolver, this.minkowskiA, this.minkowskiB, localTransA, localTransB, this.cachedSeparatingAxis, tmpPointOnA, tmpPointOnB, debugDraw);
            if (isValid2) {
                tmpNormalInB.sub((Tuple3f)tmpPointOnB, (Tuple3f)tmpPointOnA);
                float lenSqr = tmpNormalInB.lengthSquared();
                if (lenSqr > 1.4210855E-14f) {
                    tmpNormalInB.scale(1.0f / (float)Math.sqrt(lenSqr));
                    tmp.sub((Tuple3f)tmpPointOnA, (Tuple3f)tmpPointOnB);
                    float distance2 = -tmp.length();
                    if (!isValid || distance2 < distance) {
                        distance = distance2;
                        pointOnA.set((Tuple3f)tmpPointOnA);
                        pointOnB.set((Tuple3f)tmpPointOnB);
                        normalInB.set((Tuple3f)tmpNormalInB);
                        isValid = true;
                        this.lastUsedMethod = 3;
                    }
                } else {
                    this.lastUsedMethod = 4;
                }
            } else {
                this.lastUsedMethod = 5;
            }
        }
        if (isValid) {
            tmp.add((Tuple3f)pointOnB, (Tuple3f)positionOffset);
            output.addContactPoint(normalInB, tmp, distance);
        }
    }

    public void setMinkowskiA(ConvexShape minkA) {
        this.minkowskiA = minkA;
    }

    public void setMinkowskiB(ConvexShape minkB) {
        this.minkowskiB = minkB;
    }

    public void setCachedSeperatingAxis(Vector3f seperatingAxis) {
        this.cachedSeparatingAxis.set((Tuple3f)seperatingAxis);
    }

    public void setPenetrationDepthSolver(ConvexPenetrationDepthSolver penetrationDepthSolver) {
        this.penetrationDepthSolver = penetrationDepthSolver;
    }

    public void setIgnoreMargin(boolean ignoreMargin) {
        this.ignoreMargin = ignoreMargin;
    }
}

