/*
 * Decompiled with CFR 0.152.
 */
package com.bulletphysics;

import com.bulletphysics.ContactAddedCallback;
import com.bulletphysics.ContactDestroyedCallback;
import com.bulletphysics.ContactProcessedCallback;

public class BulletGlobals {
    public static final boolean DEBUG = false;
    public static final float CONVEX_DISTANCE_MARGIN = 0.04f;
    public static final float FLT_EPSILON = 1.1920929E-7f;
    public static final float SIMD_EPSILON = 1.1920929E-7f;
    public static final float SIMD_2_PI = (float)Math.PI * 2;
    public static final float SIMD_PI = (float)Math.PI;
    public static final float SIMD_HALF_PI = 1.5707964f;
    public static final float SIMD_RADS_PER_DEG = (float)Math.PI / 180;
    public static final float SIMD_DEGS_PER_RAD = 57.295776f;
    public static final float SIMD_INFINITY = Float.MAX_VALUE;
    private static ContactDestroyedCallback gContactDestroyedCallback;
    private static ContactAddedCallback gContactAddedCallback;
    private static ContactProcessedCallback gContactProcessedCallback;
    private static float contactBreakingThreshold;
    private static float deactivationTime;
    private static boolean disableDeactivation;

    public static ContactAddedCallback getContactAddedCallback() {
        return gContactAddedCallback;
    }

    public static void setContactAddedCallback(ContactAddedCallback callback) {
        gContactAddedCallback = callback;
    }

    public static ContactDestroyedCallback getContactDestroyedCallback() {
        return gContactDestroyedCallback;
    }

    public static void setContactDestroyedCallback(ContactDestroyedCallback callback) {
        gContactDestroyedCallback = callback;
    }

    public static ContactProcessedCallback getContactProcessedCallback() {
        return gContactProcessedCallback;
    }

    public static void setContactProcessedCallback(ContactProcessedCallback callback) {
        gContactProcessedCallback = callback;
    }

    public static float getContactBreakingThreshold() {
        return contactBreakingThreshold;
    }

    public static void setContactBreakingThreshold(float threshold) {
        contactBreakingThreshold = threshold;
    }

    public static float getDeactivationTime() {
        return deactivationTime;
    }

    public static void setDeactivationTime(float time) {
        deactivationTime = time;
    }

    public static boolean isDeactivationDisabled() {
        return disableDeactivation;
    }

    public static void setDeactivationDisabled(boolean disable) {
        disableDeactivation = disable;
    }

    static {
        contactBreakingThreshold = 0.02f;
        deactivationTime = 2.0f;
        disableDeactivation = false;
    }
}

