/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.builder;

import java.util.List;
import javax.vecmath.MismatchedSizeException;
import org.geotools.referencing.operation.builder.MappedPosition;
import org.geotools.referencing.operation.builder.ProjectiveTransformBuilder;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;

public class AffineTransformBuilder
extends ProjectiveTransformBuilder {
    protected AffineTransformBuilder() {
    }

    public AffineTransformBuilder(List<MappedPosition> vectors) throws MismatchedSizeException, MismatchedDimensionException, MismatchedReferenceSystemException {
        super.setMappedPositions(vectors);
    }

    @Override
    public int getMinimumPointCount() {
        return 3;
    }

    @Override
    protected GeneralMatrix getProjectiveMatrix() {
        GeneralMatrix M = new GeneralMatrix(3, 3);
        double[] param = this.calculateLSM();
        double[] m0 = new double[]{param[0], param[1], param[2]};
        double[] m1 = new double[]{param[3], param[4], param[5]};
        double[] m2 = new double[]{0.0, 0.0, 1.0};
        M.setRow(0, m0);
        M.setRow(1, m1);
        M.setRow(2, m2);
        return M;
    }

    @Override
    protected void fillAMatrix() {
        int j;
        this.A = new GeneralMatrix(2 * this.getSourcePoints().length, 6);
        int numRow = this.getSourcePoints().length * 2;
        for (j = 0; j < numRow / 2; ++j) {
            this.A.setRow(j, new double[]{this.getSourcePoints()[j].getCoordinate()[0], this.getSourcePoints()[j].getCoordinate()[1], 1.0, 0.0, 0.0, 0.0});
        }
        for (j = numRow / 2; j < numRow; ++j) {
            this.A.setRow(j, new double[]{0.0, 0.0, 0.0, this.getSourcePoints()[j - numRow / 2].getCoordinate()[0], this.getSourcePoints()[j - numRow / 2].getCoordinate()[1], 1.0});
        }
    }
}

