/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso;

import java.util.Collection;
import org.geotools.metadata.iso.MetadataEntity;
import org.opengis.metadata.Datatype;
import org.opengis.metadata.ExtendedElementInformation;
import org.opengis.metadata.Obligation;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.util.InternationalString;

public class ExtendedElementInformationImpl
extends MetadataEntity
implements ExtendedElementInformation {
    private static final long serialVersionUID = -935396252908733907L;
    private String name;
    private String shortName;
    private Integer domainCode;
    private InternationalString definition;
    private Obligation obligation;
    private InternationalString condition;
    private Datatype dataType;
    private Integer maximumOccurrence;
    private InternationalString domainValue;
    private Collection<String> parentEntity;
    private InternationalString rule;
    private Collection<InternationalString> rationales;
    private Collection<ResponsibleParty> sources;

    public ExtendedElementInformationImpl() {
    }

    public ExtendedElementInformationImpl(ExtendedElementInformation source) {
        super(source);
    }

    public ExtendedElementInformationImpl(String name, InternationalString definition, InternationalString condition, Datatype dataType, Collection<String> parentEntity, InternationalString rule, Collection<? extends ResponsibleParty> sources) {
        this.setName(name);
        this.setDefinition(definition);
        this.setCondition(condition);
        this.setDataType(dataType);
        this.setParentEntity(parentEntity);
        this.setRule(rule);
        this.setSources(sources);
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setName(String newValue) {
        this.checkWritePermission();
        this.name = newValue;
    }

    public String getShortName() {
        return this.shortName;
    }

    public synchronized void setShortName(String newValue) {
        this.checkWritePermission();
        this.shortName = newValue;
    }

    public Integer getDomainCode() {
        return this.domainCode;
    }

    public synchronized void setDomainCode(Integer newValue) {
        this.checkWritePermission();
        this.domainCode = newValue;
    }

    public InternationalString getDefinition() {
        return this.definition;
    }

    public synchronized void setDefinition(InternationalString newValue) {
        this.checkWritePermission();
        this.definition = newValue;
    }

    public Obligation getObligation() {
        return this.obligation;
    }

    public synchronized void setObligation(Obligation newValue) {
        this.checkWritePermission();
        this.obligation = newValue;
    }

    public InternationalString getCondition() {
        return this.condition;
    }

    public synchronized void setCondition(InternationalString newValue) {
        this.checkWritePermission();
        this.condition = newValue;
    }

    public Datatype getDataType() {
        return this.dataType;
    }

    public synchronized void setDataType(Datatype newValue) {
        this.checkWritePermission();
        this.dataType = newValue;
    }

    public Integer getMaximumOccurrence() {
        return this.maximumOccurrence;
    }

    public synchronized void setMaximumOccurrence(Integer newValue) {
        this.checkWritePermission();
        this.maximumOccurrence = newValue;
    }

    public InternationalString getDomainValue() {
        return this.domainValue;
    }

    public synchronized void setDomainValue(InternationalString newValue) {
        this.checkWritePermission();
        this.domainValue = newValue;
    }

    public synchronized Collection<String> getParentEntity() {
        this.parentEntity = this.nonNullCollection(this.parentEntity, String.class);
        return this.parentEntity;
    }

    public synchronized void setParentEntity(Collection<? extends String> newValues) {
        this.parentEntity = this.copyCollection(newValues, this.parentEntity, String.class);
    }

    public InternationalString getRule() {
        return this.rule;
    }

    public synchronized void setRule(InternationalString newValue) {
        this.checkWritePermission();
        this.rule = newValue;
    }

    public synchronized Collection<InternationalString> getRationales() {
        this.rationales = this.nonNullCollection(this.rationales, InternationalString.class);
        return this.rationales;
    }

    public synchronized void setRationales(Collection<? extends InternationalString> newValues) {
        this.rationales = this.copyCollection(newValues, this.rationales, InternationalString.class);
    }

    public synchronized Collection<ResponsibleParty> getSources() {
        this.sources = this.nonNullCollection(this.sources, ResponsibleParty.class);
        return this.sources;
    }

    public synchronized void setSources(Collection<? extends ResponsibleParty> newValues) {
        this.sources = this.copyCollection(newValues, this.sources, ResponsibleParty.class);
    }
}

