/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.xml;

public class XMLUtils {
    public static String removeXMLInvalidChars(String in) {
        if (in == null || "".equals(in)) {
            return in;
        }
        int lenght = in.length();
        int invalid = 0;
        for (int i = 0; i < lenght; ++i) {
            char current = in.charAt(i);
            if (XMLUtils.isXMLValidChar(current)) continue;
            ++invalid;
        }
        if (invalid > 0) {
            StringBuilder out = new StringBuilder(in.length() - invalid);
            for (int i = 0; i < lenght; ++i) {
                char current = in.charAt(i);
                if (!XMLUtils.isXMLValidChar(current)) continue;
                out.append(current);
            }
            in = out.toString();
        }
        return in;
    }

    private static boolean isXMLValidChar(char c) {
        return c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff';
    }
}

