/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import org.geotools.factory.Hints;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;

public class NumericConverterFactory
implements ConverterFactory {
    static HashMap<Class, Class> primitiveToWrapper = new HashMap();

    public Converter createConverter(Class source, Class target, Hints hints) {
        source = NumericConverterFactory.primitiveToWrapperClass(source);
        target = NumericConverterFactory.primitiveToWrapperClass(target);
        if (!Number.class.isAssignableFrom(source) && !String.class.isAssignableFrom(source)) {
            return null;
        }
        if (Long.class.equals((Object)target) || Integer.class.equals((Object)target) || Short.class.equals((Object)target) || Byte.class.equals((Object)target) || BigInteger.class.equals((Object)target) || BigDecimal.class.equals((Object)target) || Double.class.equals((Object)target) || Float.class.equals((Object)target) || Number.class.equals((Object)target)) {
            Object safeConversion;
            if (hints != null && (safeConversion = hints.get((Object)ConverterFactory.SAFE_CONVERSION)) instanceof Boolean && ((Boolean)safeConversion).booleanValue()) {
                return new SafeNumericConverter();
            }
            return new NumericConverter();
        }
        return null;
    }

    static String toIntegral(String s) {
        int radex = -1;
        for (int i = s.length() - 1; i > 0; --i) {
            char ch = s.charAt(i);
            if (Character.isDigit(ch) || '-' == ch) continue;
            radex = i;
            break;
        }
        if (radex != -1) {
            return s.substring(0, radex);
        }
        return s;
    }

    static Class primitiveToWrapperClass(Class primitive) {
        if (primitive.isPrimitive()) {
            Class wrapper = primitiveToWrapper.get(primitive);
            primitive = wrapper != null ? wrapper : primitive;
        }
        return primitive;
    }

    static {
        primitiveToWrapper.put(Byte.TYPE, Byte.class);
        primitiveToWrapper.put(Short.TYPE, Short.class);
        primitiveToWrapper.put(Integer.TYPE, Integer.class);
        primitiveToWrapper.put(Long.TYPE, Long.class);
        primitiveToWrapper.put(Float.TYPE, Float.class);
        primitiveToWrapper.put(Double.TYPE, Double.class);
        primitiveToWrapper.put(Boolean.TYPE, Boolean.class);
    }

    class NumericConverter
    implements Converter {
        NumericConverter() {
        }

        public Object convert(Object source, Class target) throws Exception {
            target = NumericConverterFactory.primitiveToWrapperClass(target);
            if (source instanceof Number) {
                Number s = (Number)source;
                if (Long.class.equals((Object)target)) {
                    return new Long(s.longValue());
                }
                if (Integer.class.equals((Object)target)) {
                    return new Integer(s.intValue());
                }
                if (Short.class.equals((Object)target)) {
                    return new Short(s.shortValue());
                }
                if (Byte.class.equals((Object)target)) {
                    return new Byte(s.byteValue());
                }
                if (BigInteger.class.equals((Object)target)) {
                    return BigInteger.valueOf(s.longValue());
                }
                if (Double.class.equals((Object)target)) {
                    return new Double(s.toString());
                }
                if (Float.class.equals((Object)target)) {
                    return new Float(s.toString());
                }
                if (BigDecimal.class.equals((Object)target)) {
                    return new BigDecimal(s.toString());
                }
                if (Number.class.equals((Object)target)) {
                    try {
                        return new Integer(s.toString());
                    }
                    catch (Exception e) {
                        try {
                            return new BigInteger(s.toString());
                        }
                        catch (Exception e2) {
                            try {
                                return new Double(s.toString());
                            }
                            catch (Exception e3) {
                                try {
                                    return new BigDecimal(s.toString());
                                }
                                catch (Exception e4) {}
                            }
                        }
                    }
                }
            } else if (source instanceof String) {
                String s = (String)source;
                s = s.trim();
                String integral = NumericConverterFactory.toIntegral(s);
                if (Double.class.equals((Object)target)) {
                    return new Double(s);
                }
                if (Float.class.equals((Object)target)) {
                    return new Float(s);
                }
                if (BigDecimal.class.equals((Object)target)) {
                    return new BigDecimal(s);
                }
                if (Long.class.equals((Object)target)) {
                    return new Long(integral);
                }
                if (Integer.class.equals((Object)target)) {
                    return new Integer(integral);
                }
                if (Short.class.equals((Object)target)) {
                    return new Short(integral);
                }
                if (Byte.class.equals((Object)target)) {
                    return new Byte(integral);
                }
                if (BigInteger.class.equals((Object)target)) {
                    return new BigInteger(integral);
                }
                if (Number.class.equals((Object)target)) {
                    if (integral.equals(s)) {
                        try {
                            return new Integer(integral);
                        }
                        catch (Exception e) {
                            try {
                                return new BigInteger(integral);
                            }
                            catch (Exception e5) {
                                // empty catch block
                            }
                        }
                    }
                    try {
                        return new Double(s);
                    }
                    catch (Exception e) {
                        try {
                            return new BigDecimal(s);
                        }
                        catch (Exception e6) {
                            // empty catch block
                        }
                    }
                }
            }
            return null;
        }
    }

    class SafeNumericConverter
    implements Converter {
        SafeNumericConverter() {
        }

        public <T> T convert(Object source, Class<T> target) throws Exception {
            target = NumericConverterFactory.primitiveToWrapperClass(target);
            if (source instanceof Number) {
                Number number = (Number)source;
                Class<?> c = number.getClass();
                if (BigDecimal.class.equals((Object)target)) {
                    return (T)new BigDecimal(source.toString());
                }
                if (Double.class.equals((Object)target)) {
                    if (c != BigDecimal.class && c != BigInteger.class) {
                        if (c == Float.class) {
                            return (T)new Double(number.toString());
                        }
                        return (T)Double.valueOf(number.doubleValue());
                    }
                } else if (Float.class.equals((Object)target)) {
                    if (c == Float.class || c == Integer.class || c == Short.class || c == Byte.class) {
                        return (T)Float.valueOf(number.floatValue());
                    }
                } else if (BigInteger.class.equals((Object)target)) {
                    if (BigInteger.class.isAssignableFrom(c) || c == Long.class || c == Integer.class || c == Short.class || c == Byte.class) {
                        return (T)new BigInteger(number.toString());
                    }
                } else if (Long.class.equals((Object)target)) {
                    if (c == Long.class || c == Integer.class || c == Short.class || c == Byte.class) {
                        return (T)Long.valueOf(number.longValue());
                    }
                } else if (Integer.class.equals((Object)target)) {
                    if (c == Integer.class || c == Short.class || c == Byte.class) {
                        return (T)Integer.valueOf(number.intValue());
                    }
                } else if (Short.class.equals((Object)target)) {
                    if (c == Short.class || c == Byte.class) {
                        return (T)Short.valueOf(number.shortValue());
                    }
                } else if (Byte.class.equals((Object)target) && c == Byte.class) {
                    return (T)Byte.valueOf(number.byteValue());
                }
            } else if (source instanceof String) {
                String src = (String)source;
                try {
                    Byte x;
                    if (BigDecimal.class.isAssignableFrom(target)) {
                        return (T)new BigDecimal(src);
                    }
                    if (target == Double.class) {
                        Double x2 = new Double(src);
                        if (x2.toString().equals(src)) {
                            return (T)x2;
                        }
                    } else if (target == Float.class) {
                        Float x3 = new Float(src);
                        if (x3.toString().equals(src)) {
                            return (T)x3;
                        }
                    } else if (BigInteger.class.isAssignableFrom(target)) {
                        BigInteger x4 = new BigInteger(src);
                        if (x4.toString().equals(src)) {
                            return (T)x4;
                        }
                    } else if (target == Long.class) {
                        Long x5 = new Long(src);
                        if (x5.toString().equals(src)) {
                            return (T)x5;
                        }
                    } else if (target == Integer.class) {
                        Integer x6 = new Integer(src);
                        if (x6.toString().equals(src)) {
                            return (T)x6;
                        }
                    } else if (target == Short.class) {
                        Short x7 = new Short(src);
                        if (x7.toString().equals(src)) {
                            return (T)x7;
                        }
                    } else if (target == Byte.class && (x = new Byte(src)).toString().equals(src)) {
                        return (T)x;
                    }
                }
                catch (Exception ex) {
                    return null;
                }
            }
            return null;
        }
    }
}

