/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.styling;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.measure.unit.Unit;
import javax.swing.Icon;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.styling.AnchorPoint;
import org.geotools.styling.AnchorPointImpl;
import org.geotools.styling.ChannelSelection;
import org.geotools.styling.ChannelSelectionImpl;
import org.geotools.styling.ColorMapImpl;
import org.geotools.styling.ColorReplacementImpl;
import org.geotools.styling.ContrastEnhancementImpl;
import org.geotools.styling.DescriptionImpl;
import org.geotools.styling.DisplacementImpl;
import org.geotools.styling.ExtensionSymbolizer;
import org.geotools.styling.ExternalGraphic;
import org.geotools.styling.ExternalGraphicImpl;
import org.geotools.styling.ExternalMarkImpl;
import org.geotools.styling.FeatureTypeStyleImpl;
import org.geotools.styling.FillImpl;
import org.geotools.styling.FontImpl;
import org.geotools.styling.GraphicImpl;
import org.geotools.styling.HaloImpl;
import org.geotools.styling.LinePlacementImpl;
import org.geotools.styling.LineSymbolizerImpl;
import org.geotools.styling.Mark;
import org.geotools.styling.MarkImpl;
import org.geotools.styling.PointPlacementImpl;
import org.geotools.styling.PointSymbolizerImpl;
import org.geotools.styling.PolygonSymbolizerImpl;
import org.geotools.styling.RasterSymbolizerImpl;
import org.geotools.styling.RuleImpl;
import org.geotools.styling.SelectedChannelTypeImpl;
import org.geotools.styling.ShadedReliefImpl;
import org.geotools.styling.StrokeImpl;
import org.geotools.styling.StyleImpl;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizerImpl;
import org.geotools.styling.VendorSymbolizerImpl;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.Id;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.PropertyName;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.style.ColorMap;
import org.opengis.style.ColorReplacement;
import org.opengis.style.ContrastEnhancement;
import org.opengis.style.ContrastMethod;
import org.opengis.style.Description;
import org.opengis.style.Displacement;
import org.opengis.style.ExternalMark;
import org.opengis.style.FeatureTypeStyle;
import org.opengis.style.Fill;
import org.opengis.style.Font;
import org.opengis.style.Graphic;
import org.opengis.style.GraphicFill;
import org.opengis.style.GraphicLegend;
import org.opengis.style.GraphicStroke;
import org.opengis.style.GraphicalSymbol;
import org.opengis.style.Halo;
import org.opengis.style.LabelPlacement;
import org.opengis.style.LineSymbolizer;
import org.opengis.style.OverlapBehavior;
import org.opengis.style.PointSymbolizer;
import org.opengis.style.PolygonSymbolizer;
import org.opengis.style.RasterSymbolizer;
import org.opengis.style.Rule;
import org.opengis.style.SelectedChannelType;
import org.opengis.style.SemanticType;
import org.opengis.style.ShadedRelief;
import org.opengis.style.Stroke;
import org.opengis.style.StyleFactory;
import org.opengis.style.TextSymbolizer;
import org.opengis.util.InternationalString;

public class StyleFactoryImpl2
implements StyleFactory {
    private FilterFactory2 filterFactory;

    public StyleFactoryImpl2() {
        this(CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints()));
    }

    protected StyleFactoryImpl2(FilterFactory2 factory) {
        this.filterFactory = factory;
    }

    public AnchorPoint anchorPoint(Expression x, Expression y) {
        return new AnchorPointImpl((FilterFactory)this.filterFactory, x, y);
    }

    public ChannelSelection channelSelection(SelectedChannelType gray) {
        ChannelSelectionImpl channelSelection = new ChannelSelectionImpl();
        channelSelection.setGrayChannel(gray);
        return channelSelection;
    }

    public ChannelSelectionImpl channelSelection(SelectedChannelType red, SelectedChannelType green, SelectedChannelType blue) {
        ChannelSelectionImpl channelSelection = new ChannelSelectionImpl();
        channelSelection.setRGBChannels(red, green, blue);
        return channelSelection;
    }

    public ColorMapImpl colorMap(Expression propertyName, Expression ... mapping) {
        Expression[] arguments = new Expression[mapping.length + 2];
        arguments[0] = propertyName;
        for (int i = 0; i < mapping.length; ++i) {
            arguments[i + 1] = mapping[i];
        }
        Function function = this.filterFactory.function("Categorize", arguments);
        ColorMapImpl colorMap = new ColorMapImpl(function);
        return colorMap;
    }

    public ColorReplacementImpl colorReplacement(Expression propertyName, Expression ... mapping) {
        Expression[] arguments = new Expression[mapping.length + 2];
        arguments[0] = propertyName;
        for (int i = 0; i < mapping.length; ++i) {
            arguments[i + 1] = mapping[i];
        }
        Function function = this.filterFactory.function("Recode", arguments);
        ColorReplacementImpl colorMap = new ColorReplacementImpl(function);
        return colorMap;
    }

    public ContrastEnhancementImpl contrastEnhancement(Expression gamma, ContrastMethod method) {
        return new ContrastEnhancementImpl(this.filterFactory, gamma, method);
    }

    public DescriptionImpl description(InternationalString title, InternationalString description) {
        return new DescriptionImpl(title, description);
    }

    public DisplacementImpl displacement(Expression dx, Expression dy) {
        return new DisplacementImpl(dx, dy);
    }

    public ExternalGraphic externalGraphic(Icon inline, Collection<ColorReplacement> replacements) {
        ExternalGraphicImpl externalGraphic = new ExternalGraphicImpl(inline, replacements, null);
        return externalGraphic;
    }

    public ExternalGraphic externalGraphic(OnLineResource resource, String format, Collection<ColorReplacement> replacements) {
        ExternalGraphicImpl externalGraphic = new ExternalGraphicImpl(null, replacements, resource);
        externalGraphic.setFormat(format);
        return externalGraphic;
    }

    public ExternalMarkImpl externalMark(Icon inline) {
        return new ExternalMarkImpl(inline);
    }

    public ExternalMarkImpl externalMark(OnLineResource resource, String format, int markIndex) {
        return new ExternalMarkImpl(resource, format, markIndex);
    }

    public FeatureTypeStyleImpl featureTypeStyle(String name, Description description, Id definedFor, Set<Name> featureTypeNames, Set<SemanticType> types, List<Rule> rules) {
        FeatureTypeStyleImpl featureTypeStyle = new FeatureTypeStyleImpl();
        featureTypeStyle.setName(name);
        if (description != null && description.getTitle() != null) {
            featureTypeStyle.setTitle(description.getTitle().toString());
        }
        if (description != null && description.getAbstract() != null) {
            featureTypeStyle.setAbstract(description.getAbstract().toString());
        }
        featureTypeStyle.featureTypeNames().addAll(featureTypeNames);
        featureTypeStyle.semanticTypeIdentifiers().addAll(types);
        for (Rule rule : rules) {
            if (rule instanceof RuleImpl) {
                featureTypeStyle.rules().add((RuleImpl)rule);
                continue;
            }
            featureTypeStyle.rules().add(new RuleImpl(rule));
        }
        return featureTypeStyle;
    }

    public FillImpl fill(GraphicFill graphicFill, Expression color, Expression opacity) {
        FillImpl fill = new FillImpl((FilterFactory)this.filterFactory);
        fill.setGraphicFill((Graphic)graphicFill);
        fill.setColor(color);
        fill.setOpacity(opacity);
        return fill;
    }

    public FontImpl font(List<Expression> family, Expression style, Expression weight, Expression size) {
        FontImpl font = new FontImpl();
        font.getFamily().addAll(family);
        font.setStyle(style);
        font.setWeight(weight);
        font.setSize(size);
        return font;
    }

    public GraphicImpl graphic(List<GraphicalSymbol> symbols, Expression opacity, Expression size, Expression rotation, org.opengis.style.AnchorPoint anchor, Displacement disp) {
        GraphicImpl graphic = new GraphicImpl((FilterFactory)this.filterFactory);
        if (symbols != null) {
            for (GraphicalSymbol graphicalSymbol : symbols) {
                if (graphicalSymbol instanceof ExternalGraphic) {
                    graphic.graphicalSymbols().add(ExternalGraphicImpl.cast(graphicalSymbol));
                    continue;
                }
                if (!(graphicalSymbol instanceof Mark)) continue;
                graphic.graphicalSymbols().add((GraphicalSymbol)MarkImpl.cast(graphicalSymbol));
            }
        }
        graphic.setOpacity(opacity);
        graphic.setSize(size);
        graphic.setRotation(rotation);
        graphic.setAnchorPoint(anchor);
        graphic.setDisplacement(disp);
        return graphic;
    }

    public GraphicImpl graphicFill(List<GraphicalSymbol> symbols, Expression opacity, Expression size, Expression rotation, org.opengis.style.AnchorPoint anchorPoint, Displacement displacement) {
        GraphicImpl graphicFill = new GraphicImpl((FilterFactory)this.filterFactory);
        if (symbols != null) {
            for (GraphicalSymbol graphicalSymbol : symbols) {
                if (graphicalSymbol instanceof ExternalGraphic) {
                    graphicFill.graphicalSymbols().add(ExternalGraphicImpl.cast(graphicalSymbol));
                    continue;
                }
                if (!(graphicalSymbol instanceof Mark)) continue;
                graphicFill.graphicalSymbols().add((GraphicalSymbol)MarkImpl.cast(graphicalSymbol));
            }
        }
        graphicFill.setOpacity(opacity);
        graphicFill.setSize(size);
        graphicFill.setRotation(rotation);
        graphicFill.setAnchorPoint(anchorPoint);
        graphicFill.setDisplacement(displacement);
        return graphicFill;
    }

    public GraphicImpl graphicLegend(List<GraphicalSymbol> symbols, Expression opacity, Expression size, Expression rotation, org.opengis.style.AnchorPoint anchorPoint, Displacement displacement) {
        GraphicImpl graphicLegend = new GraphicImpl((FilterFactory)this.filterFactory);
        if (symbols != null) {
            for (GraphicalSymbol graphicalSymbol : symbols) {
                if (graphicalSymbol instanceof ExternalGraphic) {
                    graphicLegend.graphicalSymbols().add(ExternalGraphicImpl.cast(graphicalSymbol));
                    continue;
                }
                if (!(graphicalSymbol instanceof Mark)) continue;
                graphicLegend.graphicalSymbols().add((GraphicalSymbol)MarkImpl.cast(graphicalSymbol));
            }
        }
        graphicLegend.setOpacity(opacity);
        graphicLegend.setSize(size);
        graphicLegend.setRotation(rotation);
        graphicLegend.setAnchorPoint(anchorPoint);
        graphicLegend.setDisplacement(displacement);
        return graphicLegend;
    }

    public GraphicImpl graphicStroke(List<GraphicalSymbol> symbols, Expression opacity, Expression size, Expression rotation, org.opengis.style.AnchorPoint anchorPoint, Displacement displacement, Expression initialGap, Expression gap) {
        GraphicImpl graphicStroke = new GraphicImpl((FilterFactory)this.filterFactory);
        if (symbols != null) {
            for (GraphicalSymbol graphicalSymbol : symbols) {
                if (graphicalSymbol instanceof ExternalGraphic) {
                    graphicStroke.graphicalSymbols().add(ExternalGraphicImpl.cast(graphicalSymbol));
                    continue;
                }
                if (!(graphicalSymbol instanceof Mark)) continue;
                graphicStroke.graphicalSymbols().add((GraphicalSymbol)MarkImpl.cast(graphicalSymbol));
            }
        }
        graphicStroke.setOpacity(opacity);
        graphicStroke.setSize(size);
        graphicStroke.setRotation(rotation);
        graphicStroke.setAnchorPoint(anchorPoint);
        graphicStroke.setDisplacement(displacement);
        graphicStroke.setInitialGap(initialGap);
        graphicStroke.setGap(gap);
        return graphicStroke;
    }

    public HaloImpl halo(Fill fill, Expression radius) {
        HaloImpl halo = new HaloImpl();
        halo.setFill(fill);
        halo.setRadius(radius);
        return halo;
    }

    public LinePlacementImpl linePlacement(Expression offset, Expression initialGap, Expression gap, boolean repeated, boolean aligned, boolean generalizedLine) {
        LinePlacementImpl placement = new LinePlacementImpl((FilterFactory)this.filterFactory);
        placement.setPerpendicularOffset(offset);
        placement.setInitialGap(initialGap);
        placement.setGap(gap);
        placement.setRepeated(repeated);
        placement.setAligned(aligned);
        placement.setGeneralized(generalizedLine);
        return placement;
    }

    public LineSymbolizerImpl lineSymbolizer(String name, Expression geometry, Description description, Unit<?> unit, Stroke stroke, Expression offset) {
        LineSymbolizerImpl copy = new LineSymbolizerImpl();
        copy.setDescription(description);
        copy.setGeometry(geometry);
        copy.setName(name);
        copy.setPerpendicularOffset(offset);
        copy.setStroke(stroke);
        copy.setUnitOfMeasure(unit);
        return copy;
    }

    public MarkImpl mark(Expression wellKnownName, Fill fill, Stroke stroke) {
        MarkImpl mark = new MarkImpl((FilterFactory)this.filterFactory, null);
        mark.setWellKnownName(wellKnownName);
        mark.setFill(fill);
        mark.setStroke(stroke);
        return mark;
    }

    public MarkImpl mark(ExternalMark externalMark, Fill fill, Stroke stroke) {
        MarkImpl mark = new MarkImpl();
        mark.setExternalMark(externalMark);
        mark.setFill(fill);
        mark.setStroke(stroke);
        return mark;
    }

    public PointPlacementImpl pointPlacement(org.opengis.style.AnchorPoint anchor, Displacement displacement, Expression rotation) {
        PointPlacementImpl pointPlacment = new PointPlacementImpl((FilterFactory)this.filterFactory);
        pointPlacment.setAnchorPoint(anchor);
        pointPlacment.setDisplacement(displacement);
        pointPlacment.setRotation(rotation);
        return pointPlacment;
    }

    public PointSymbolizerImpl pointSymbolizer(String name, Expression geometry, Description description, Unit<?> unit, Graphic graphic) {
        PointSymbolizerImpl copy = new PointSymbolizerImpl();
        copy.setDescription(description);
        copy.setGeometryPropertyName(((PropertyName)geometry).getPropertyName());
        copy.setGraphic(graphic);
        copy.setName(name);
        copy.setUnitOfMeasure(unit);
        return copy;
    }

    public PolygonSymbolizerImpl polygonSymbolizer(String name, Expression geometry, Description description, Unit<?> unit, Stroke stroke, Fill fill, Displacement displacement, Expression offset) {
        PolygonSymbolizerImpl polygonSymbolizer = new PolygonSymbolizerImpl();
        polygonSymbolizer.setStroke(stroke);
        polygonSymbolizer.setDescription(description);
        polygonSymbolizer.setDisplacement(displacement);
        polygonSymbolizer.setFill(fill);
        polygonSymbolizer.setGeometryPropertyName(((PropertyName)geometry).getPropertyName());
        polygonSymbolizer.setName(name);
        polygonSymbolizer.setPerpendicularOffset(offset);
        polygonSymbolizer.setUnitOfMeasure(unit);
        return polygonSymbolizer;
    }

    public RasterSymbolizerImpl rasterSymbolizer(String name, Expression geometry, Description description, Unit<?> unit, Expression opacity, org.opengis.style.ChannelSelection channelSelection, OverlapBehavior overlapsBehaviour, ColorMap colorMap, ContrastEnhancement contrast, ShadedRelief shaded, org.opengis.style.Symbolizer outline) {
        RasterSymbolizerImpl rasterSymbolizer = new RasterSymbolizerImpl((FilterFactory)this.filterFactory);
        rasterSymbolizer.setChannelSelection(channelSelection);
        rasterSymbolizer.setColorMap(colorMap);
        rasterSymbolizer.setContrastEnhancement(contrast);
        rasterSymbolizer.setDescription(description);
        if (geometry != null) {
            rasterSymbolizer.setGeometryPropertyName(((PropertyName)geometry).getPropertyName());
        } else {
            rasterSymbolizer.setGeometryPropertyName(null);
        }
        rasterSymbolizer.setImageOutline(outline);
        rasterSymbolizer.setName(name);
        rasterSymbolizer.setOpacity(opacity);
        rasterSymbolizer.setOverlapBehavior(overlapsBehaviour);
        rasterSymbolizer.setShadedRelief(shaded);
        rasterSymbolizer.setUnitOfMeasure(unit);
        return rasterSymbolizer;
    }

    public ExtensionSymbolizer extensionSymbolizer(String name, String propertyName, Description description, Unit<?> unit, String extensionName, Map<String, Expression> parameters) {
        VendorSymbolizerImpl extension = new VendorSymbolizerImpl();
        extension.setName(name);
        extension.setGeometryPropertyName(propertyName);
        extension.setDescription(description);
        extension.setUnitOfMeasure(unit);
        extension.setExtensionName(extensionName);
        extension.getParameters().putAll(parameters);
        return extension;
    }

    static Symbolizer cast(org.opengis.style.Symbolizer symbolizer) {
        if (symbolizer instanceof PolygonSymbolizer) {
            return PolygonSymbolizerImpl.cast(symbolizer);
        }
        if (symbolizer instanceof LineSymbolizer) {
            return LineSymbolizerImpl.cast(symbolizer);
        }
        if (symbolizer instanceof PointSymbolizer) {
            return PointSymbolizerImpl.cast(symbolizer);
        }
        if (symbolizer instanceof RasterSymbolizer) {
            return RasterSymbolizerImpl.cast(symbolizer);
        }
        if (symbolizer instanceof TextSymbolizer) {
            return TextSymbolizerImpl.cast(symbolizer);
        }
        if (symbolizer instanceof org.opengis.style.ExtensionSymbolizer) {
            ExtensionSymbolizer extensionSymbolizer = (ExtensionSymbolizer)symbolizer;
            String name = extensionSymbolizer.getExtensionName();
            return null;
        }
        return null;
    }

    public RuleImpl rule(String name, Description description, GraphicLegend legend, double min, double max, List<org.opengis.style.Symbolizer> symbolizers, Filter filter) {
        RuleImpl rule = new RuleImpl();
        rule.setName(name);
        rule.setDescription(description);
        rule.setLegend(legend);
        rule.setMinScaleDenominator(min);
        rule.setMaxScaleDenominator(max);
        if (symbolizers != null) {
            for (org.opengis.style.Symbolizer symbolizer : symbolizers) {
                rule.symbolizers().add(StyleFactoryImpl2.cast(symbolizer));
            }
        }
        if (filter != null) {
            rule.setFilter(filter);
            rule.setElseFilter(false);
        } else {
            rule.setElseFilter(true);
        }
        return rule;
    }

    public SelectedChannelTypeImpl selectedChannelType(String channelName, ContrastEnhancement contrastEnhancement) {
        SelectedChannelTypeImpl selectedChannelType = new SelectedChannelTypeImpl((FilterFactory)this.filterFactory);
        selectedChannelType.setChannelName(channelName);
        selectedChannelType.setContrastEnhancement(contrastEnhancement);
        return selectedChannelType;
    }

    public ShadedReliefImpl shadedRelief(Expression reliefFactor, boolean brightnessOnly) {
        ShadedReliefImpl shadedRelief = new ShadedReliefImpl((FilterFactory)this.filterFactory);
        shadedRelief.setReliefFactor(reliefFactor);
        shadedRelief.setBrightnessOnly(brightnessOnly);
        return shadedRelief;
    }

    public StrokeImpl stroke(Expression color, Expression opacity, Expression width, Expression join, Expression cap, float[] dashes, Expression offset) {
        StrokeImpl stroke = new StrokeImpl((FilterFactory)this.filterFactory);
        stroke.setColor(color);
        stroke.setOpacity(opacity);
        stroke.setWidth(width);
        stroke.setLineJoin(join);
        stroke.setLineCap(cap);
        stroke.setDashArray(dashes);
        stroke.setDashOffset(offset);
        return stroke;
    }

    public StrokeImpl stroke(GraphicFill fill, Expression color, Expression opacity, Expression width, Expression join, Expression cap, float[] dashes, Expression offset) {
        StrokeImpl stroke = new StrokeImpl((FilterFactory)this.filterFactory);
        stroke.setGraphicFill((Graphic)fill);
        stroke.setColor(color);
        stroke.setOpacity(opacity);
        stroke.setWidth(width);
        stroke.setLineJoin(join);
        stroke.setLineCap(cap);
        stroke.setDashArray(dashes);
        stroke.setDashOffset(offset);
        return stroke;
    }

    public StrokeImpl stroke(GraphicStroke stroke, Expression color, Expression opacity, Expression width, Expression join, Expression cap, float[] dashes, Expression offset) {
        StrokeImpl s = new StrokeImpl((FilterFactory)this.filterFactory);
        s.setColor(color);
        s.setWidth(width);
        s.setOpacity(opacity);
        s.setLineJoin(join);
        s.setLineCap(cap);
        s.setDashArray(dashes);
        s.setDashOffset(offset);
        s.setGraphicStroke((Graphic)GraphicImpl.cast((Graphic)stroke));
        return s;
    }

    public StyleImpl style(String name, Description description, boolean isDefault, List<FeatureTypeStyle> featureTypeStyles, org.opengis.style.Symbolizer defaultSymbolizer) {
        StyleImpl style = new StyleImpl();
        style.setName(name);
        style.setDescription(description);
        style.setDefault(isDefault);
        if (featureTypeStyles != null) {
            for (FeatureTypeStyle featureTypeStyle : featureTypeStyles) {
                style.featureTypeStyles().add(FeatureTypeStyleImpl.cast(featureTypeStyle));
            }
        }
        style.setDefaultSpecification(StyleFactoryImpl2.cast(defaultSymbolizer));
        return style;
    }

    public TextSymbolizerImpl textSymbolizer(String name, Expression geometry, Description description, Unit<?> unit, Expression label, Font font, LabelPlacement placement, Halo halo, Fill fill) {
        TextSymbolizerImpl tSymb = new TextSymbolizerImpl((FilterFactory)this.filterFactory);
        tSymb.setName(name);
        tSymb.setFill(fill);
        tSymb.setUnitOfMeasure(unit);
        tSymb.setFont(font);
        tSymb.setGeometryPropertyName(((PropertyName)geometry).getPropertyName());
        tSymb.setHalo(halo);
        tSymb.setLabel(label);
        tSymb.setLabelPlacement(placement);
        tSymb.setDescription(description);
        return tSymb;
    }
}

