/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.BinaryExpression;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;

public class ExpressionTypeVisitor
implements ExpressionVisitor {
    static final Map<Class<?>, List<Class<?>>> PROMOTIONS = new HashMap<Class<?>, List<Class<?>>>(){
        {
            this.put(Byte.class, Arrays.asList(Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, BigInteger.class, BigDecimal.class));
            this.put(Short.class, Arrays.asList(Short.class, Integer.class, Long.class, Float.class, Double.class, BigInteger.class, BigDecimal.class));
            this.put(Integer.class, Arrays.asList(Integer.class, Long.class, Float.class, Double.class, BigInteger.class, BigDecimal.class));
            this.put(Long.class, Arrays.asList(Long.class, Double.class, BigInteger.class, BigDecimal.class));
            this.put(Float.class, Arrays.asList(Float.class, Double.class, BigDecimal.class));
            this.put(Double.class, Arrays.asList(Double.class, BigDecimal.class));
            this.put(BigInteger.class, Arrays.asList(BigInteger.class, BigDecimal.class));
        }
    };
    FeatureType featureType;

    public ExpressionTypeVisitor(FeatureType featureType) {
        this.featureType = featureType;
    }

    public Object visit(NilExpression expression, Object extraData) {
        return Object.class;
    }

    public Object visit(Add expression, Object extraData) {
        return this.visitBinaryExpression((BinaryExpression)expression);
    }

    public Object visit(Divide expression, Object extraData) {
        return this.visitBinaryExpression((BinaryExpression)expression);
    }

    public Object visit(Multiply expression, Object extraData) {
        return this.visitBinaryExpression((BinaryExpression)expression);
    }

    public Object visit(Subtract expression, Object extraData) {
        return this.visitBinaryExpression((BinaryExpression)expression);
    }

    protected Class<?> visitBinaryExpression(BinaryExpression expression) {
        Class type1 = (Class)expression.getExpression1().accept((ExpressionVisitor)this, null);
        Class type2 = (Class)expression.getExpression2().accept((ExpressionVisitor)this, null);
        return this.largestType(type1, type2);
    }

    private Class<?> largestType(Class<?> type1, Class<?> type2) {
        if (type1.isAssignableFrom(type2)) {
            return type1;
        }
        if (type2.isAssignableFrom(type1)) {
            return type2;
        }
        if (Number.class.isAssignableFrom(type1) && Number.class.isAssignableFrom(type2)) {
            List<Class<?>> c1 = PROMOTIONS.get(type1);
            List<Class<?>> c2 = PROMOTIONS.get(type2);
            if (c1 == null || c2 == null) {
                return Object.class;
            }
            ArrayList intersection = new ArrayList(c1);
            intersection.retainAll(c2);
            if (intersection.isEmpty()) {
                return Object.class;
            }
            return (Class)intersection.get(0);
        }
        return this.getCommonSuperclass(type1, type2);
    }

    Class<?> getCommonSuperclass(Class<?> c1, Class<?> c2) {
        Class<?> curr = c1;
        while (!curr.isAssignableFrom(c2)) {
            curr = curr.getSuperclass();
        }
        return curr;
    }

    public Object visit(Function expression, Object extraData) {
        FunctionName name = expression.getFunctionName();
        if (name != null && name.getReturn() != null) {
            return name.getReturn().getType();
        }
        return Object.class;
    }

    public Object visit(Literal expression, Object extraData) {
        if (expression.getValue() != null) {
            return expression.getValue().getClass();
        }
        return Object.class;
    }

    public Object visit(PropertyName expression, Object extraData) {
        AttributeDescriptor ad = (AttributeDescriptor)expression.evaluate((Object)this.featureType, AttributeDescriptor.class);
        if (ad != null) {
            return ad.getType().getBinding();
        }
        return Object.class;
    }
}

