/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.MinVisitor;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.function.CollectionFeatureMemberFilterVisitor;
import org.geotools.util.logging.Logging;
import org.opengis.feature.FeatureVisitor;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;

public class Collection_MinFunction
extends FunctionExpressionImpl {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.filter.function");
    SimpleFeatureCollection previousFeatureCollection = null;
    Object min = null;
    public static FunctionName NAME = new FunctionNameImpl("Collection_Min", FunctionNameImpl.parameter("min", Comparable.class), FunctionNameImpl.parameter("expression", Comparable.class));

    public Collection_MinFunction() {
        super(NAME);
    }

    static CalcResult calculateMin(SimpleFeatureCollection collection, Expression expression) throws IllegalFilterException, IOException {
        MinVisitor minVisitor = new MinVisitor(expression);
        collection.accepts((FeatureVisitor)minVisitor, null);
        return minVisitor.getResult();
    }

    public void setParameters(List args) {
        Expression expr = (Expression)args.get(0);
        expr = (Expression)expr.accept((ExpressionVisitor)new CollectionFeatureMemberFilterVisitor(), null);
        args.set(0, expr);
        super.setParameters(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object evaluate(Object feature) {
        SimpleFeatureCollection featureCollection;
        if (feature == null) {
            return new Integer(0);
        }
        Expression expr = this.getExpression(0);
        SimpleFeatureCollection simpleFeatureCollection = featureCollection = (SimpleFeatureCollection)feature;
        synchronized (simpleFeatureCollection) {
            if (featureCollection != this.previousFeatureCollection) {
                this.previousFeatureCollection = featureCollection;
                this.min = null;
                try {
                    CalcResult result = Collection_MinFunction.calculateMin(featureCollection, expr);
                    if (result != null) {
                        this.min = result.getValue();
                    }
                }
                catch (IllegalFilterException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINER, e.getLocalizedMessage(), e);
                }
            }
        }
        return this.min;
    }

    public void setExpression(Expression e) {
        this.setParameters((List)Collections.singletonList(e));
    }
}

