/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.FeatureWriterIterator;
import org.geotools.data.store.NoContentIterator;
import org.geotools.feature.CollectionEvent;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureReaderIterator;
import org.geotools.feature.collection.DelegateSimpleFeatureIterator;
import org.geotools.feature.collection.SubFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

public abstract class DataFeatureCollection
implements SimpleFeatureCollection {
    static Logger LOGGER = Logging.getLogger((String)"org.geotools.data");
    private static int unique = 0;
    private final Set open = new HashSet();
    protected List listeners = new ArrayList();
    protected String id;
    protected SimpleFeatureType schema;

    protected DataFeatureCollection() {
        this("features" + unique++);
    }

    protected DataFeatureCollection(String id) {
        this(id, null);
    }

    protected DataFeatureCollection(String id, SimpleFeatureType memberType) {
        this.id = id == null ? "featureCollection" : id;
        this.schema = memberType;
    }

    protected void fireChange(SimpleFeature[] features, int type) {
        CollectionEvent cEvent = new CollectionEvent((FeatureCollection)this, features, type);
        int ii = this.listeners.size();
        for (int i = 0; i < ii; ++i) {
            ((CollectionListener)this.listeners.get(i)).collectionChanged(cEvent);
        }
    }

    protected void fireChange(SimpleFeature feature, int type) {
        this.fireChange(new SimpleFeature[]{feature}, type);
    }

    protected void fireChange(Collection coll, int type) {
        SimpleFeature[] features = new SimpleFeature[coll.size()];
        features = coll.toArray(features);
        this.fireChange(features, type);
    }

    public FeatureReader<SimpleFeatureType, SimpleFeature> reader() throws IOException {
        return new DelegateFeatureReader<SimpleFeatureType, SimpleFeature>(this.getSchema(), (FeatureIterator<SimpleFeature>)this.features());
    }

    public abstract ReferencedEnvelope getBounds();

    public abstract int getCount() throws IOException;

    protected FeatureWriter<SimpleFeatureType, SimpleFeature> writer() throws IOException {
        return null;
    }

    public SimpleFeatureIterator features() {
        DelegateSimpleFeatureIterator iterator = new DelegateSimpleFeatureIterator((FeatureCollection<SimpleFeatureType, SimpleFeature>)this, this.iterator());
        this.open.add(iterator);
        return iterator;
    }

    public final Iterator<SimpleFeature> iterator() {
        Iterator<SimpleFeature> iterator;
        try {
            iterator = this.openIterator();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.open.add(iterator);
        return iterator;
    }

    protected Iterator<SimpleFeature> openIterator() throws IOException {
        try {
            FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.writer();
            if (writer != null) {
                return new FeatureWriterIterator(this.writer());
            }
        }
        catch (IOException badWriter) {
            return new NoContentIterator(badWriter);
        }
        catch (UnsupportedOperationException readOnly) {
            // empty catch block
        }
        try {
            return new FeatureReaderIterator<SimpleFeature>(this.reader());
        }
        catch (IOException e) {
            return new NoContentIterator(e);
        }
    }

    public final void close(Iterator<SimpleFeature> close) {
        try {
            this.closeIterator(close);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Error closing iterator", e);
        }
        this.open.remove(close);
    }

    protected void closeIterator(Iterator<SimpleFeature> close) throws IOException {
        if (close != null) {
            if (close instanceof FeatureReaderIterator) {
                FeatureReaderIterator iterator = (FeatureReaderIterator)close;
                iterator.close();
            } else if (close instanceof FeatureWriterIterator) {
                FeatureWriterIterator iterator = (FeatureWriterIterator)close;
                iterator.close();
            }
        }
    }

    public void close(FeatureIterator<SimpleFeature> iterator) {
        iterator.close();
        this.open.remove(iterator);
    }

    public int size() {
        try {
            return this.getCount();
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "IOException while calculating size() of FeatureCollection", e);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        Iterator i = this.open.iterator();
        while (i.hasNext()) {
            Object iterator = i.next();
            try {
                if (iterator instanceof Iterator) {
                    this.closeIterator((Iterator)iterator);
                }
                if (!(iterator instanceof FeatureIterator)) continue;
                ((SimpleFeatureIterator)iterator).close();
            }
            catch (Throwable throwable) {}
            continue;
            finally {
                i.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean isEmpty() {
        FeatureReader<SimpleFeatureType, SimpleFeature> reader = null;
        try {
            reader = this.reader();
            try {
                boolean bl = !reader.hasNext();
                return bl;
            }
            catch (IOException e) {
                boolean bl;
                block17: {
                    bl = true;
                    if (reader == null) break block17;
                    try {
                        reader.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                return bl;
                catch (IOException e3) {
                    boolean bl2 = true;
                    return bl2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * Exception decompiling
     */
    public boolean contains(Object o) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [27[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Object[] toArray() {
        return this.toArray(new SimpleFeature[this.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T[] toArray(T[] array) {
        ArrayList<SimpleFeature> list = new ArrayList<SimpleFeature>();
        Iterator<SimpleFeature> i = this.iterator();
        try {
            while (i.hasNext()) {
                list.add(i.next());
            }
        }
        finally {
            this.close(i);
        }
        return list.toArray(array);
    }

    public boolean add(SimpleFeature arg0) {
        return false;
    }

    public boolean remove(Object arg0) {
        return false;
    }

    public boolean containsAll(Collection<?> collection) {
        for (Object o : collection) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection collection) {
        if (collection instanceof FeatureCollection) {
            return this.addAll((FeatureCollection)collection);
        }
        try {
            FeatureWriter<SimpleFeatureType, SimpleFeature> writer = this.writer();
            if (writer == null) {
                return false;
            }
            try {
                while (writer.hasNext()) {
                    Feature feature = writer.next();
                }
                for (Object obj : collection) {
                    if (!(obj instanceof SimpleFeature)) continue;
                    SimpleFeature copy = (SimpleFeature)obj;
                    SimpleFeature feature = (SimpleFeature)writer.next();
                    feature.setAttributes(copy.getAttributes());
                    writer.write();
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
            return true;
        }
        catch (IOException ignore) {
            return false;
        }
    }

    public boolean addAll(FeatureCollection resource) {
        return false;
    }

    public boolean removeAll(Collection arg0) {
        return false;
    }

    public boolean retainAll(Collection arg0) {
        return false;
    }

    public void clear() {
    }

    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        DataUtilities.visit(this, visitor, progress);
    }

    public SimpleFeatureCollection subCollection(Filter filter) {
        if (filter == Filter.INCLUDE) {
            return this;
        }
        return new SubFeatureCollection(this, filter);
    }

    public SimpleFeatureCollection sort(SortBy order) {
        return null;
    }

    public String getID() {
        return this.id;
    }

    public final void addListener(CollectionListener listener) throws NullPointerException {
        this.listeners.add(listener);
    }

    public final void removeListener(CollectionListener listener) throws NullPointerException {
        this.listeners.remove(listener);
    }

    public SimpleFeatureType getSchema() {
        return this.schema;
    }
}

