/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.geotools.data.ResourceInfo;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class DefaultResourceInfo
implements ResourceInfo {
    private String title;
    private URI schema;
    private String name;
    private Set<String> keywords;
    private String description;
    private CoordinateReferenceSystem crs;
    private ReferencedEnvelope bounds;

    public DefaultResourceInfo() {
    }

    public DefaultResourceInfo(ResourceInfo copy) {
        this.title = copy.getTitle();
        this.schema = copy.getSchema();
        this.name = copy.getName();
        this.keywords = new HashSet<String>();
        if (copy.getKeywords() != null) {
            this.keywords.addAll(copy.getKeywords());
        }
        this.description = copy.getDescription();
        this.crs = copy.getCRS();
        this.bounds = copy.getBounds();
    }

    public String getTitle() {
        return this.title;
    }

    public URI getSchema() {
        return this.schema;
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getKeywords() {
        return this.keywords;
    }

    public String getDescription() {
        return this.description;
    }

    public ReferencedEnvelope getBounds() {
        return this.bounds;
    }

    public CoordinateReferenceSystem getCRS() {
        return this.crs;
    }

    public void setCRS(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSchema(URI schema) {
        this.schema = schema;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setKeywords(Set<String> keywords) {
        this.keywords = keywords;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setBounds(ReferencedEnvelope bounds) {
        this.bounds = bounds;
    }
}

