/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.store.ContentState;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class MemoryFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    ContentState state;
    SimpleFeatureType featureType;
    Iterator<SimpleFeature> iterator;

    public MemoryFeatureReader(ContentState state, Query query) throws IOException {
        this.state = state;
        this.featureType = state.getFeatureType();
        String typeName = this.getFeatureType().getTypeName();
        MemoryDataStore store = (MemoryDataStore)state.getEntry().getDataStore();
        this.iterator = store.features(typeName).values().iterator();
    }

    public SimpleFeatureType getFeatureType() {
        return this.state.getFeatureType();
    }

    public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.iterator == null) {
            throw new IOException("Feature Reader has been closed");
        }
        try {
            return SimpleFeatureBuilder.copy((SimpleFeature)this.iterator.next());
        }
        catch (NoSuchElementException end) {
            throw new DataSourceException("There are no more Features", (Throwable)end);
        }
    }

    public boolean hasNext() {
        return this.iterator != null && this.iterator.hasNext();
    }

    public void close() {
        if (this.iterator != null) {
            this.iterator = null;
        }
        if (this.featureType != null) {
            this.featureType = null;
        }
    }
}

