/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.memory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.memory.MemoryFeatureStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

public class MemoryDataStore
extends ContentDataStore {
    protected Map<String, Map<String, SimpleFeature>> memory = new LinkedHashMap<String, Map<String, SimpleFeature>>();
    protected Map<String, SimpleFeatureType> schema = new HashMap<String, SimpleFeatureType>();

    public MemoryDataStore() {
    }

    public MemoryDataStore(SimpleFeatureType featureType) {
        LinkedHashMap featureMap = new LinkedHashMap();
        String typeName = featureType.getTypeName();
        this.schema.put(typeName, featureType);
        this.memory.put(typeName, featureMap);
    }

    public MemoryDataStore(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
        this.addFeatures(collection);
    }

    public MemoryDataStore(SimpleFeatureCollection collection) {
        this.addFeatures((FeatureCollection<SimpleFeatureType, SimpleFeature>)collection);
    }

    public MemoryDataStore(SimpleFeature[] array) {
        this.addFeatures(array);
    }

    public MemoryDataStore(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        this.addFeatures(reader);
    }

    public MemoryDataStore(SimpleFeatureIterator reader) throws IOException {
        this.addFeatures(reader);
    }

    public void addFeatures(FeatureReader<SimpleFeatureType, SimpleFeature> reader) throws IOException {
        try {
            LinkedHashMap<String, SimpleFeature> featureMap = new LinkedHashMap<String, SimpleFeature>();
            SimpleFeature feature = (SimpleFeature)reader.next();
            if (feature == null) {
                throw new IllegalArgumentException("Provided  FeatureReader<SimpleFeatureType, SimpleFeature> is closed");
            }
            SimpleFeatureType featureType = feature.getFeatureType();
            String typeName = featureType.getTypeName();
            featureMap.put(feature.getID(), feature);
            while (reader.hasNext()) {
                feature = (SimpleFeature)reader.next();
                featureMap.put(feature.getID(), feature);
            }
            this.schema.put(typeName, featureType);
            this.memory.put(typeName, featureMap);
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("Problem using reader", (Throwable)e);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatures(SimpleFeatureIterator reader) throws IOException {
        try {
            LinkedHashMap<String, SimpleFeature> featureMap = new LinkedHashMap<String, SimpleFeature>();
            SimpleFeature feature = (SimpleFeature)reader.next();
            if (feature == null) {
                throw new IllegalArgumentException("Provided  FeatureReader<SimpleFeatureType, SimpleFeature> is closed");
            }
            SimpleFeatureType featureType = feature.getFeatureType();
            String typeName = featureType.getTypeName();
            featureMap.put(feature.getID(), feature);
            while (reader.hasNext()) {
                feature = (SimpleFeature)reader.next();
                featureMap.put(feature.getID(), feature);
            }
            this.schema.put(typeName, featureType);
            this.memory.put(typeName, featureMap);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatures(Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException("Provided SimpleFeatureCollection is empty");
        }
        Map<String, Map<String, SimpleFeature>> map = this.memory;
        synchronized (map) {
            Iterator<?> i = collection.iterator();
            while (i.hasNext()) {
                this.addFeatureInternal((SimpleFeature)i.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Provided SimpleFeatureCollection is empty");
        }
        Map<String, Map<String, SimpleFeature>> map = this.memory;
        synchronized (map) {
            try {
                collection.accepts(new FeatureVisitor(){

                    public void visit(Feature feature) {
                        MemoryDataStore.this.addFeatureInternal((SimpleFeature)feature);
                    }
                }, null);
            }
            catch (IOException ignore) {
                this.LOGGER.log(Level.FINE, "Unable to add all features", ignore);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeatures(SimpleFeature[] features) {
        if (features == null || features.length == 0) {
            throw new IllegalArgumentException("Provided features are empty");
        }
        Map<String, Map<String, SimpleFeature>> map = this.memory;
        synchronized (map) {
            for (int i = 0; i < features.length; ++i) {
                this.addFeatureInternal(features[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFeature(SimpleFeature feature) {
        Map<String, Map<String, SimpleFeature>> map = this.memory;
        synchronized (map) {
            this.addFeatureInternal(feature);
        }
    }

    private void addFeatureInternal(SimpleFeature feature) {
        if (feature == null) {
            throw new IllegalArgumentException("Provided Feature is empty");
        }
        SimpleFeatureType featureType = feature.getFeatureType();
        String typeName = featureType.getTypeName();
        if (!this.memory.containsKey(typeName)) {
            try {
                this.createSchema(featureType);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        Map<String, SimpleFeature> featuresMap = this.memory.get(typeName);
        featuresMap.put(feature.getID(), feature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<String, SimpleFeature> features(String typeName) throws IOException {
        Map<String, Map<String, SimpleFeature>> map = this.memory;
        synchronized (map) {
            if (this.memory.containsKey(typeName)) {
                return this.memory.get(typeName);
            }
        }
        throw new IOException("Type name " + typeName + " not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<Name> createTypeNames() {
        Map<String, Map<String, SimpleFeature>> map = this.memory;
        synchronized (map) {
            ArrayList<Name> typeNames = new ArrayList<Name>();
            Iterator<String> i = this.schema.keySet().iterator();
            while (i.hasNext()) {
                typeNames.add((Name)new NameImpl(this.namespaceURI, i.next()));
            }
            return typeNames;
        }
    }

    @Override
    protected ContentFeatureSource createFeatureSource(ContentEntry entry) {
        return this.createFeatureSource(entry, Query.ALL);
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry entry, Query query) {
        return new MemoryFeatureStore(entry, query);
    }

    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        String typeName = featureType.getTypeName();
        if (this.memory.containsKey(typeName)) {
            throw new IOException(typeName + " already exists");
        }
        LinkedHashMap featuresMap = new LinkedHashMap();
        this.schema.put(typeName, featureType);
        this.memory.put(typeName, featuresMap);
    }
}

