/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openforecast.models;

import java.util.Iterator;
import net.sourceforge.openforecast.DataPoint;
import net.sourceforge.openforecast.DataSet;
import net.sourceforge.openforecast.Observation;
import net.sourceforge.openforecast.models.AbstractForecastingModel;
import net.sourceforge.openforecast.models.AbstractTimeBasedModel;

public class DoubleExponentialSmoothingModel
extends AbstractTimeBasedModel {
    private static double DEFAULT_SMOOTHING_CONSTANT_TOLERANCE = 0.001;
    private double alpha;
    private double gamma;
    private DataSet slopeValues;

    public static DoubleExponentialSmoothingModel getBestFitModel(DataSet dataSet) {
        return DoubleExponentialSmoothingModel.getBestFitModel(dataSet, DEFAULT_SMOOTHING_CONSTANT_TOLERANCE, DEFAULT_SMOOTHING_CONSTANT_TOLERANCE);
    }

    public static DoubleExponentialSmoothingModel getBestFitModel(DataSet dataSet, double alphaTolerance, double gammaTolerance) {
        DoubleExponentialSmoothingModel model1 = DoubleExponentialSmoothingModel.findBestGamma(dataSet, 0.0, 0.0, 1.0, gammaTolerance);
        DoubleExponentialSmoothingModel model2 = DoubleExponentialSmoothingModel.findBestGamma(dataSet, 0.5, 0.0, 1.0, gammaTolerance);
        DoubleExponentialSmoothingModel model3 = DoubleExponentialSmoothingModel.findBestGamma(dataSet, 1.0, 0.0, 1.0, gammaTolerance);
        DoubleExponentialSmoothingModel bestModel = DoubleExponentialSmoothingModel.findBest(dataSet, model1, model2, model3, alphaTolerance, gammaTolerance);
        return bestModel;
    }

    private static DoubleExponentialSmoothingModel findBest(DataSet dataSet, DoubleExponentialSmoothingModel modelMin, DoubleExponentialSmoothingModel modelMid, DoubleExponentialSmoothingModel modelMax, double alphaTolerance, double gammaTolerance) {
        double alphaMin = modelMin.getAlpha();
        double alphaMid = modelMid.getAlpha();
        double alphaMax = modelMax.getAlpha();
        if (Math.abs(alphaMid - alphaMin) < alphaTolerance && Math.abs(alphaMax - alphaMid) < alphaTolerance) {
            return modelMid;
        }
        DoubleExponentialSmoothingModel[] model = new DoubleExponentialSmoothingModel[]{modelMin, DoubleExponentialSmoothingModel.findBestGamma(dataSet, (alphaMin + alphaMid) / 2.0, 0.0, 1.0, gammaTolerance), modelMid, DoubleExponentialSmoothingModel.findBestGamma(dataSet, (alphaMid + alphaMax) / 2.0, 0.0, 1.0, gammaTolerance), modelMax};
        int m = 0;
        while (m < 5) {
            model[m].init(dataSet);
            ++m;
        }
        int bestModelIndex = 0;
        int m2 = 1;
        while (m2 < 5) {
            if (model[m2].getMSE() < model[bestModelIndex].getMSE()) {
                bestModelIndex = m2;
            }
            ++m2;
        }
        switch (bestModelIndex) {
            case 1: {
                model[3] = null;
                model[4] = null;
                return DoubleExponentialSmoothingModel.findBest(dataSet, model[0], model[1], model[2], alphaTolerance, gammaTolerance);
            }
            case 2: {
                model[0] = null;
                model[4] = null;
                return DoubleExponentialSmoothingModel.findBest(dataSet, model[1], model[2], model[3], alphaTolerance, gammaTolerance);
            }
            case 3: {
                model[0] = null;
                model[1] = null;
                return DoubleExponentialSmoothingModel.findBest(dataSet, model[2], model[3], model[4], alphaTolerance, gammaTolerance);
            }
        }
        int m3 = 0;
        while (m3 < 5) {
            if (m3 != bestModelIndex) {
                model[m3] = null;
            }
            ++m3;
        }
        return model[bestModelIndex];
    }

    private static DoubleExponentialSmoothingModel findBestGamma(DataSet dataSet, double alpha, double gammaMin, double gammaMax, double gammaTolerance) {
        int stepsPerIteration = 10;
        if (gammaMin < 0.0) {
            gammaMin = 0.0;
        }
        if (gammaMax > 1.0) {
            gammaMax = 1.0;
        }
        DoubleExponentialSmoothingModel bestModel = new DoubleExponentialSmoothingModel(alpha, gammaMin);
        bestModel.init(dataSet);
        double initialMSE = bestModel.getMSE();
        boolean gammaImproving = true;
        double gammaStep = (gammaMax - gammaMin) / (double)stepsPerIteration;
        double gamma = gammaMin + gammaStep;
        while (gamma <= gammaMax || gammaImproving) {
            DoubleExponentialSmoothingModel model = new DoubleExponentialSmoothingModel(alpha, gamma);
            model.init(dataSet);
            if (model.getMSE() < bestModel.getMSE()) {
                bestModel = model;
            } else {
                gammaImproving = false;
            }
            gamma += gammaStep;
            if (!(gamma > 1.0)) continue;
            gammaImproving = false;
        }
        if (bestModel.getMSE() < initialMSE && gammaStep > gammaTolerance) {
            return DoubleExponentialSmoothingModel.findBestGamma(dataSet, bestModel.getAlpha(), bestModel.getGamma() - gammaStep, bestModel.getGamma() + gammaStep, gammaTolerance);
        }
        return bestModel;
    }

    public DoubleExponentialSmoothingModel(double alpha, double gamma) {
        if (alpha < 0.0 || alpha > 1.0) {
            throw new IllegalArgumentException("DoubleExponentialSmoothingModel: Invalid smoothing constant, " + alpha + " - must be in the range 0.0-1.0.");
        }
        if (gamma < 0.0 || gamma > 1.0) {
            throw new IllegalArgumentException("DoubleExponentialSmoothingModel: Invalid smoothing constant, gamma=" + gamma + " - must be in the range 0.0-1.0.");
        }
        this.slopeValues = new DataSet();
        this.alpha = alpha;
        this.gamma = gamma;
    }

    protected double forecast(double t) throws IllegalArgumentException {
        double previousTime = t - this.getTimeInterval();
        if (previousTime < this.getMinimumTimeValue() + AbstractForecastingModel.TOLERANCE) {
            return this.getObservedValue(t);
        }
        try {
            double b = this.getSlope(previousTime);
            double forecast = this.alpha * this.getObservedValue(t) + (1.0 - this.alpha) * (this.getForecastValue(previousTime) + b);
            return forecast;
        }
        catch (IllegalArgumentException iaex) {
            double maxTimeValue = this.getMaximumTimeValue();
            double b = this.getSlope(maxTimeValue - this.getTimeInterval());
            double forecast = this.getForecastValue(maxTimeValue) + (t - maxTimeValue) * b;
            return forecast;
        }
    }

    private double getSlope(double time) throws IllegalArgumentException {
        String timeVariable = this.getTimeVariable();
        Iterator it = this.slopeValues.iterator();
        while (it.hasNext()) {
            DataPoint dp = (DataPoint)it.next();
            double dpTimeValue = dp.getIndependentValue(timeVariable);
            if (!(Math.abs(time - dpTimeValue) < AbstractForecastingModel.TOLERANCE)) continue;
            return dp.getDependentValue();
        }
        double previousTime = time - this.getTimeInterval();
        double slope = 0.0;
        slope = previousTime < this.getMinimumTimeValue() + AbstractForecastingModel.TOLERANCE ? this.getObservedValue(time) - this.getObservedValue(previousTime) : this.gamma * (this.forecast(time) - this.forecast(previousTime)) + (1.0 - this.gamma) * this.getSlope(previousTime);
        Observation dp = new Observation(slope);
        dp.setIndependentValue(timeVariable, time);
        this.slopeValues.add(dp);
        return slope;
    }

    protected int getNumberOfPeriods() {
        return 2;
    }

    protected void calculateAccuracyIndicators(DataSet dataSet) {
        this.initialized = true;
        double sumErr = 0.0;
        double sumAbsErr = 0.0;
        double sumAbsPercentErr = 0.0;
        double sumErrSquared = 0.0;
        String timeVariable = this.getTimeVariable();
        double timeDiff = this.getTimeInterval();
        Iterator it = dataSet.iterator();
        while (it.hasNext()) {
            DataPoint dp = (DataPoint)it.next();
            double x = dp.getDependentValue();
            double time = dp.getIndependentValue(timeVariable);
            double previousTime = time - timeDiff;
            double forecastValue = this.getForecastValue(previousTime) + this.getSlope(previousTime);
            double error = forecastValue - x;
            sumErr += error;
            sumAbsErr += Math.abs(error);
            sumAbsPercentErr += Math.abs(error / x);
            sumErrSquared += error * error;
        }
        int n = dataSet.size();
        this.accuracyIndicators.setBias(sumErr / (double)n);
        this.accuracyIndicators.setMAD(sumAbsErr / (double)n);
        this.accuracyIndicators.setMAPE(sumAbsPercentErr / (double)n);
        this.accuracyIndicators.setMSE(sumErrSquared / (double)n);
        this.accuracyIndicators.setSAE(sumAbsErr);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getGamma() {
        return this.gamma;
    }

    public String getForecastType() {
        return "double exponential smoothing";
    }

    public String toString() {
        return "Double exponential smoothing model, with smoothing constants of alpha=" + this.alpha + ", gamma=" + this.gamma + ", and using an independent variable of " + this.getIndependentVariable();
    }
}

