/*
 * MS3DVertex.java
 *
 * Copyright (C) 2001-2002 Kevin J. Duling (kevin@dark-horse.net)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.glyphein.j3d.loaders.milkshape;

import javax.vecmath.Point3f;

/** Stores an individual vertex.
 *
 * @author  Kevin J. Duling
 * @version $Revision: 1.2 $
 */
final class MS3DVertex
{
	private byte flags;
	private Point3f location;
	private byte boneID;
	private byte refCount;

  /** Creates new MS3DVertex */
  MS3DVertex()
  {
  }
  
  /** Creates new MS3DVertex.  Initializes based on provided parameters.
   * @param x x coordinate
   * @param y y coordinate
   * @param z z coordinate
   * @param boneID id of the bone associated with this vertex
   * @param refCount times this vertex is referenced (?)
   * @param flags  flags set on this bone
   */  
  MS3DVertex(final float x,
             final float y,
             final float z,
             final byte boneID,
             final byte refCount,
             final byte flags)
  {
    this(new Point3f(x, y, z), boneID, refCount, flags);
  }
  
  /** Creates new MS3DVertex.  Initializes based on provided parameters.
   * @param vertex position of this vertex
   * @param boneID id of the bone associated with this vertex
   * @param refCount times this vertex is referenced (?)
   * @param flags  flags set on this bone
   */  
  MS3DVertex(final Point3f location,
             final byte boneID,
             final byte refCount,
             final byte flags)
  {
    setLocation(location);
    setBoneID(boneID);
    setRefCount(refCount);
    setFlags(flags);
  }

  /** Retrieve the position of this vertex.
   * @return  a Point3f
   */  
  final Point3f getLocation()
  {
    return this.location;
  }
  
  /** Sets the location of this vertex.
   * @param location  a Point3f
   */  
  final void setLocation(final Point3f location)
  {
    this.location = location;
  }
  
  /** Retrieve the ID of the associated bone for animation.
   * @return  a byte
   */  
  final byte getBoneID()
  {
    return this.boneID;
  }

  /** Sets the ID of the associated bone used for animation.
   * @param boneID  a byte
   */  
  final void setBoneID(final byte boneID)
  {
    this.boneID = boneID;
  }
  
  /** Retrieve the reference count for this vertex
   * @return  a byte
   */  
  final byte getRefCount()
  {
    return this.refCount;
  }
  
  /** Set the reference count for this vertex
   * @param refCount  a byte
   */  
  final void setRefCount(final byte refCount)
  {
    this.refCount = refCount;
  }
  
  /** Retrieve the flags set on this object
   * @return  a byte
   */  
  final byte getFlags()
  {
    return this.flags;
  }
  
  /** Set the flags on this object
   * @param flags  a byte
   */  
  final void setFlags(final byte flags)
  {
    this.flags = flags;
  }
}