/*
 * MS3DTriangle.java
 *
 * Copyright (C) 2001-2002 Kevin J. Duling (kevin@dark-horse.net)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package com.glyphein.j3d.loaders.milkshape;

import javax.vecmath.Vector3f;

/** Represents a triangle.
 *
 * @author  Kevin J. Duling
 * @version $Revision: 1.2 $
 */
final class MS3DTriangle
{
	private int flags;
	private int vertexIndices[];
	private Vector3f vertexNormals[];
	private float s[];
  private float t[];
	private byte smoothingGroup;
	private byte groupIndex;

  /* Creates a MS3DTriangle */
  MS3DTriangle()
  {
  }

  /** Retrieves this object's flags
   * @return  an int
   */  
  final int getFlags()
  {
    return this.flags;
  }

  /** Sets the flags on this object
   * @param flags  an int
   */  
  final void setFlags(final int flags)
  {
    this.flags = flags;
  }
  
  /** Retrieves the list indicies that point to a list of MS3DVertex objects
   * @return  an array of int
   */  
  final int[] getVertexIndicies()
  {
    return this.vertexIndices;
  }
  
  /** Sets the list of indicies pointing to a list of MS3DVertex objects
   * @param indicies  an array of int
   */  
  final void setVertexIndicies(final int indicies[])
  {
    if (indicies.length != 3)
      throw new IllegalArgumentException("MS3DTriangle: indicies must be a length of 3");
    this.vertexIndices = indicies;
  }
  
  /** Retrieve the horizontal texture coordinates for this triangle
   * @return  an array of floats
   */  
  final float[] getS()
  {
    return this.s;
  }
  
  /** Set the horizontal texture coordinates for this triangle
   * @param s  an array of floats
   */  
  final void setS(final float s[])
  {
    if (s.length != 3)
      throw new IllegalArgumentException("MS3DTriangle: s must be a length of 3");
    this.s = s;
  }
  
  /** Retrieve the smoothing group for this triangle
   * @return  a byte
   */  
  final byte getSmoothingGroup()
  {
    return this.smoothingGroup;
  }
  
  /** Set the smoothing group for this triangle
   * @param smooth  a byte
   */  
  final void setSmoothingGroup(final byte smooth)
  {
    this.smoothingGroup = smooth;
  }
  
  /** Retrieve the index of the group that this triangle is part of
   * @return  a byte
   */  
  final byte getGroupIndex()
  {
    return this.groupIndex;
  }
  
  /** Set the group index to indicate which group this triangle is part of
   * @param index  a byte
   */  
  final void setGroupIndex(final byte index)
  {
    this.groupIndex = index;
  }
  
  /** Retrieve the vertical texture coordinates for this triangle
   * @return  an array of float
   */  
  final float[] getT()
  {
    return this.t;
  }
  
  /** Set the vertical texture coordinates for this triangle
   * @param t  an array of float
   */  
  final void setT(final float t[])
  {
    if (t.length != 3)
      throw new IllegalArgumentException("MS3DTriangle: t must be a length of 3");
    this.t = t;
  }
  
  /** Retrieve the vertex normals for this triangle
   * @return  an array of three Vector3f objects
   */  
  final Vector3f[] getVertexNormals()
  {
    return this.vertexNormals;
  }
  
  /** Sets the vertex normals for this triangle
   * @param normals  an array of three Vector3f objects
   */  
  final void setVertexNormals(final Vector3f normals[])
  {
    if (normals.length != 3)
      throw new IllegalArgumentException("MS3DTriangle: normals must be a length of 3");
    this.vertexNormals = normals;
  }
}