/*
 * Decompiled with CFR 0.152.
 */
package org.josql.functions.regexp;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.functions.regexp.AbstractRegExpWrapper;
import org.josql.functions.regexp.RegExp;

public class ApacheRegExpWrapper
extends AbstractRegExpWrapper
implements RegExp {
    public static final String SUPPORTED_VERSION = "1.3";
    private final String compilerClassName = "org.apache.regexp.RECompiler";
    private final String matcherClassName = "org.apache.regexp.RE";
    private final String programClassName = "org.apache.regexp.REProgram";
    private final String compileMethName = "compile";
    private final String setProgramMethName = "setProgram";
    private final String matchMethName = "match";
    private Method compileMeth = null;
    private Method setProgramMeth = null;
    private Method matchMeth = null;
    private Class compilerClass = null;
    private Class matcherClass = null;
    private Map patterns = new HashMap();

    @Override
    public String getSupportedVersion() {
        return SUPPORTED_VERSION;
    }

    @Override
    public boolean isAvailable(Query q) {
        try {
            q.loadClass(this.compilerClassName);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void init(Query q) throws QueryExecutionException {
        try {
            this.compilerClass = q.loadClass(this.compilerClassName);
            Class[] argTypes = new Class[]{String.class};
            this.compileMeth = this.compilerClass.getMethod(this.compileMethName, argTypes);
            this.matcherClass = q.loadClass(this.matcherClassName);
            Class pc = q.loadClass(this.programClassName);
            Class[] argTypes2 = new Class[]{pc};
            this.setProgramMeth = this.matcherClass.getMethod(this.setProgramMethName, argTypes2);
            this.matchMeth = this.matcherClass.getMethod(this.matchMethName, argTypes);
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to init", e);
        }
    }

    @Override
    public boolean match(String pattern, String val) throws QueryExecutionException {
        try {
            Object o = this.patterns.get(pattern);
            if (o == null) {
                Object c = this.compilerClass.newInstance();
                Object[] args = new Object[]{pattern};
                Object program = this.compileMeth.invoke(c, args);
                Object re = this.matcherClass.newInstance();
                Object[] args2 = new Object[]{program};
                this.setProgramMeth.invoke(re, args2);
                this.patterns.put(pattern, re);
                o = re;
            }
            Object[] args = new Object[]{val};
            return (Boolean)this.matchMeth.invoke(o, args);
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to match value: " + val + " against pattern: " + pattern, e);
        }
    }
}

