/*
 * Decompiled with CFR 0.152.
 */
package org.josql.expressions;

import com.gentlyweb.utils.Getter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryParseException;
import org.josql.QueryResults;
import org.josql.events.BindVariableChangedEvent;
import org.josql.events.BindVariableChangedListener;
import org.josql.events.SaveValueChangedEvent;
import org.josql.events.SaveValueChangedListener;
import org.josql.expressions.Accessor;
import org.josql.expressions.BindVariable;
import org.josql.expressions.ConstantExpression;
import org.josql.expressions.Expression;
import org.josql.expressions.Function;
import org.josql.expressions.SaveValue;
import org.josql.expressions.ValueExpression;

public class SubQueryExpression
extends ValueExpression
implements BindVariableChangedListener,
SaveValueChangedListener {
    private Query q = null;
    private boolean inited = false;
    private String acc = null;
    private Getter get = null;
    private boolean nullQuery = false;

    public SubQueryExpression(Query q) {
        this.q = q;
        this.q.addBindVariableChangedListener(this);
        this.q.addSaveValueChangedListener(this);
    }

    @Override
    public void bindVariableChanged(BindVariableChangedEvent ev) {
        BindVariable bv;
        if (this.q.getFrom() instanceof BindVariable && (bv = (BindVariable)this.q.getFrom()).getName().equalsIgnoreCase(ev.getName())) {
            this.inited = false;
        }
    }

    @Override
    public void saveValueChanged(SaveValueChangedEvent ev) {
        SaveValue sv;
        if (this.q.getFrom() instanceof SaveValue && (sv = (SaveValue)this.q.getFrom()).getName().equalsIgnoreCase(ev.getName())) {
            this.inited = false;
        }
    }

    public Getter getGetter() {
        return this.get;
    }

    public void setAccessor(String acc) {
        this.acc = acc;
    }

    public String getAccessor() {
        return this.acc;
    }

    public Query getQuery() {
        return this.q;
    }

    @Override
    public boolean hasFixedResult(Query q) {
        return false;
    }

    @Override
    public Class getExpectedReturnType(Query q) throws QueryParseException {
        if (this.get != null) {
            return this.get.getType();
        }
        return List.class;
    }

    @Override
    public void init(Query q) throws QueryParseException {
        if (this.acc != null) {
            try {
                this.get = new Getter(this.acc, ArrayList.class);
            }
            catch (Exception e) {
                throw new QueryParseException("Sub-query: " + this + " has accessor: " + this.acc + " however no valid accessor has been found in return type: " + ArrayList.class.getName(), e);
            }
        }
    }

    @Override
    public boolean isTrue(Object o, Query q) throws QueryExecutionException {
        List l = (List)this.getValue(o, q);
        return l.size() > 0;
    }

    private Object innerInitFromFunction(Expression from, Object o, Query q) throws QueryExecutionException {
        try {
            from.init(q);
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to init FROM clause: " + from + " for sub-query: " + q, e);
        }
        return this.q.getFrom().getValue(o, q);
    }

    private Object innerInitFromConstantExpression(Expression from, Object o, Query q) throws QueryExecutionException {
        Object obj = null;
        String g = (String)from.getValue(null, this.q);
        if (!g.equalsIgnoreCase("null")) {
            Accessor acc = new Accessor();
            acc.setAccessor(g);
            this.q.setFrom(acc);
            try {
                acc.init(q);
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to init accessor: " + g + " from class: " + o.getClass() + " for FROM clause, for sub-query: \"" + this.q + "\"", e);
            }
            obj = this.q.getFrom().getValue(o, this.q);
        } else {
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(new Object());
            obj = l;
            this.nullQuery = true;
        }
        return obj;
    }

    private Object innerInitFromBindVariable(Expression from, Object o, Query q) throws QueryExecutionException {
        try {
            from.init(q.getTopLevelQuery());
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to init FROM clause: " + from + " for sub-query: " + this.q, e);
        }
        return from.getValue(o, q.getTopLevelQuery());
    }

    private Object innerInitFromAccessor(Expression from, Object o, Query q) throws QueryExecutionException {
        try {
            from.init(q);
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to init FROM clause: " + from + " for sub-query: " + this.q, e);
        }
        return from.getValue(o, this.q);
    }

    private void innerInit(Object o, Query q) throws QueryExecutionException {
        Object obj = null;
        Expression from = this.q.getFrom();
        if (from instanceof ConstantExpression) {
            obj = this.innerInitFromConstantExpression(from, o, q);
        }
        if (from instanceof Accessor) {
            obj = this.innerInitFromAccessor(from, o, q);
        }
        if (from instanceof Function) {
            obj = this.innerInitFromFunction(from, o, q);
        }
        if (from instanceof SaveValue) {
            obj = from.getValue(o, q.getTopLevelQuery());
        }
        if (from instanceof BindVariable) {
            obj = this.innerInitFromBindVariable(from, o, q);
        }
        if (obj == null) {
            return;
        }
        if (!(obj instanceof Collection)) {
            throw new QueryExecutionException("Expected FROM clause: " + this.q.getFrom() + " for sub-query: " + this.q + " to evaluate to an instance of: " + Collection.class.getName() + ", instead evaluates to: " + obj.getClass().getName() + " using from expression: " + from);
        }
        Collection col = (Collection)obj;
        Iterator iter = col.iterator();
        if (!iter.hasNext()) {
            return;
        }
        Object io = iter.next();
        if (io == null) {
            while (iter.hasNext() && (io = iter.next()) == null) {
            }
        }
        if (io == null) {
            return;
        }
        this.q.setFromObjectClass(io.getClass());
        try {
            this.q.init();
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to init sub-query: " + this.q + " with class: " + io.getClass().getName(), e);
        }
        this.inited = true;
    }

    private List innerGetValue(Object o) throws QueryExecutionException {
        if (this.nullQuery) {
            return Query.nullQueryList;
        }
        Object obj = null;
        try {
            obj = this.q.getFrom().getValue(o, this.q.getTopLevelQuery());
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to evaluate FROM clause accessor: " + this.q.getFrom() + " for sub-query: " + this.q, e);
        }
        if (obj == null) {
            return new ArrayList();
        }
        if (!(obj instanceof Collection)) {
            throw new QueryExecutionException("Evaluation of FROM clause for sub-query: " + this.q + " returns an instance of: " + obj.getClass().getName() + " however only sub-classes of: " + Collection.class.getName() + " are supported.");
        }
        ArrayList l = null;
        l = obj instanceof List ? (ArrayList)obj : new ArrayList((Collection)obj);
        return l;
    }

    @Override
    public Object evaluate(Object o, Query q) throws QueryExecutionException {
        this.q.setParent(q);
        if (!this.inited) {
            this.innerInit(o, q);
        }
        if (this.inited) {
            List l = this.innerGetValue(o);
            QueryResults qr = this.q.execute(l);
            if (this.get != null) {
                try {
                    return this.get.getValue((Object)qr.getResults());
                }
                catch (Exception e) {
                    throw new QueryExecutionException("Unable to get value for accessor: " + this.acc + " from return type: " + ArrayList.class.getName() + " after execution of sub-query: " + this, e);
                }
            }
            return qr.getResults();
        }
        return new ArrayList();
    }

    @Override
    public String toString() {
        return "(" + this.q.toString() + ")";
    }
}

