/*
 * Decompiled with CFR 0.152.
 */
package org.josql.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.josql.Query;
import org.josql.QueryExecutionException;
import org.josql.QueryParseException;
import org.josql.expressions.Expression;
import org.josql.internal.Utilities;

public class SelectItemExpression
extends Expression {
    public static final String KEY = "key";
    public static final String VALUE = "value";
    private Expression exp = null;
    private boolean fixedResult = false;
    private Class addItemsType = null;
    private String addItemsMapType = null;
    private String alias = null;

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String a) {
        this.alias = Utilities.stripQuotes(a);
    }

    @Override
    public boolean hasFixedResult(Query q) {
        return this.fixedResult;
    }

    @Override
    public Class getExpectedReturnType(Query q) throws QueryParseException {
        return this.exp.getExpectedReturnType(q);
    }

    @Override
    public void init(Query q) throws QueryParseException {
        this.exp.init(q);
        this.fixedResult = this.exp.hasFixedResult(q);
    }

    public void setAddMapType(String t) {
        this.addItemsMapType = t;
    }

    public Collection getAddItems(Object v) {
        if (Map.class.isAssignableFrom(this.addItemsType)) {
            boolean k = this.addItemsMapType.equals(KEY);
            Map m = (Map)v;
            if (k) {
                return m.keySet();
            }
            return m.values();
        }
        if (v instanceof Collection) {
            return (Collection)v;
        }
        ArrayList<Object> l = new ArrayList<Object>();
        l.add(v);
        return l;
    }

    public boolean isAddItemsFromCollectionOrMap() {
        return this.addItemsType != null;
    }

    public void setAddItemsType(Class c) {
        this.addItemsType = c;
    }

    public Expression getExpression() {
        return this.exp;
    }

    public void setExpression(Expression exp) {
        this.exp = exp;
    }

    @Override
    public boolean isTrue(Object o, Query q) throws QueryExecutionException {
        return this.exp.isTrue(o, q);
    }

    @Override
    public Object getValue(Object o, Query q) throws QueryExecutionException {
        return this.exp.getValue(o, q);
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        if (this.isAddItemsFromCollectionOrMap()) {
            b.append("[*");
            if (this.addItemsMapType != null) {
                b.append(", ");
                b.append(this.addItemsMapType);
            }
            b.append("] ");
        }
        b.append(this.exp);
        if (this.alias != null) {
            b.append(" ");
            b.append(this.alias);
        }
        return b.toString();
    }
}

