/*
 * Decompiled with CFR 0.152.
 */
package org.josql;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.josql.QueryExecutionException;
import org.josql.QueryParseException;
import org.josql.QueryResults;
import org.josql.events.BindVariableChangedEvent;
import org.josql.events.BindVariableChangedListener;
import org.josql.events.SaveValueChangedEvent;
import org.josql.events.SaveValueChangedListener;
import org.josql.expressions.AliasedExpression;
import org.josql.expressions.BindVariable;
import org.josql.expressions.ConstantExpression;
import org.josql.expressions.Expression;
import org.josql.expressions.Function;
import org.josql.expressions.NewObjectExpression;
import org.josql.expressions.SaveValue;
import org.josql.expressions.SelectItemExpression;
import org.josql.functions.AbstractFunctionHandler;
import org.josql.functions.CollectionFunctions;
import org.josql.functions.ConversionFunctions;
import org.josql.functions.FormattingFunctions;
import org.josql.functions.FunctionHandler;
import org.josql.functions.GroupingFunctions;
import org.josql.functions.MiscellaneousFunctions;
import org.josql.functions.StringFunctions;
import org.josql.internal.GroupByExpressionComparator;
import org.josql.internal.Grouper;
import org.josql.internal.Limit;
import org.josql.internal.ListExpressionComparator;
import org.josql.internal.OrderBy;
import org.josql.parser.JoSQLParser;

public class Query {
    public static String QUERY_BIND_VAR_NAME = "_query";
    public static String PARENT_BIND_VAR_NAME = "_parent";
    public static String CURR_OBJ_VAR_NAME = "_currobj";
    public static String ALL_OBJS_VAR_NAME = "_allobjs";
    public static String GRPBY_OBJ_VAR_NAME = "_grpby";
    public static String GRPBY_OBJ_VAR_NAME_SYNONYM = "_groupby";
    public static final String INT_BIND_VAR_PREFIX = "^^^";
    public static final String ALL = "ALL";
    public static final String RESULTS = "RESULTS";
    public static final String GROUP_BY_RESULTS = "GROUP_BY_RESULTS";
    public static final String WHERE_RESULTS = "WHERE_RESULTS";
    public static final String HAVING_RESULTS = "HAVING_RESULTS";
    public static final String ORDER_BY_ASC = "ASC";
    public static final String ORDER_BY_DESC = "DESC";
    public static final List nullQueryList = new ArrayList();
    private List bfhs = new ArrayList();
    private Map bfhsMap = new HashMap();
    private char wildcardChar = (char)37;
    private Map aliases = new HashMap();
    private List groupBys = null;
    private Comparator orderByComp = null;
    private Comparator groupOrderByComp = null;
    private Grouper grouper = null;
    private List orderBys = null;
    private List groupOrderBys = null;
    private List cols = null;
    private boolean retObjs = false;
    private Expression where = null;
    private Expression having = null;
    private Map bindVars = null;
    private String query = null;
    private boolean wantTimings = false;
    private List functionHandlers = null;
    private int anonVarIndex = 1;
    private Expression from = null;
    private Class objClass = null;
    private Limit limit = null;
    private Limit groupByLimit = null;
    private Map executeOn = null;
    private boolean isParsed = false;
    private boolean distinctResults = false;
    private ClassLoader classLoader = null;
    private Query parent = null;
    private Map listeners = new HashMap();
    private Comparator userComparator = null;
    private transient Object currentObject = null;
    private transient List allObjects = null;
    private transient List currGroupBys = null;
    private QueryResults qd = null;

    public Expression getWhereClause() {
        return this.where;
    }

    public Expression getHavingClause() {
        return this.having;
    }

    public Comparator getOrderByComparator() {
        return this.orderByComp;
    }

    public FunctionHandler getFunctionHandler(String id) {
        if (this.parent != null) {
            return this.parent.getFunctionHandler(id);
        }
        return (FunctionHandler)this.bfhsMap.get(id);
    }

    private void initFunctionHandlers() {
        AbstractFunctionHandler o = new CollectionFunctions();
        o.setQuery(this);
        this.bfhsMap.put("_internal_collection", o);
        this.bfhs.add(o);
        o = new StringFunctions();
        o.setQuery(this);
        this.bfhsMap.put("_internal_string", o);
        this.bfhs.add(o);
        o = new ConversionFunctions();
        o.setQuery(this);
        this.bfhsMap.put("_internal_conversion", o);
        this.bfhs.add(o);
        o = new FormattingFunctions();
        o.setQuery(this);
        this.bfhsMap.put("_internal_formatting", o);
        this.bfhs.add(o);
        o = new GroupingFunctions();
        o.setQuery(this);
        this.bfhsMap.put("_internal_grouping", o);
        this.bfhs.add(o);
        o = new MiscellaneousFunctions();
        o.setQuery(this);
        this.bfhsMap.put("_internal_misc", o);
        this.bfhs.add(o);
    }

    public Map getExecuteOnFunctions() {
        return this.executeOn;
    }

    public void setExecuteOnFunctions(Map ex) {
        this.executeOn = ex;
    }

    public String getAnonymousBindVariableName() {
        if (this.parent != null) {
            return this.parent.getAnonymousBindVariableName();
        }
        String n = INT_BIND_VAR_PREFIX + this.anonVarIndex;
        ++this.anonVarIndex;
        return n;
    }

    public List getDefaultFunctionHandlers() {
        if (this.parent != null) {
            return this.parent.getDefaultFunctionHandlers();
        }
        return new ArrayList(this.bfhs);
    }

    public List getFunctionHandlers() {
        if (this.parent != null) {
            return this.parent.getFunctionHandlers();
        }
        return this.functionHandlers;
    }

    public void addFunctionHandler(Object o) {
        if (this.parent != null) {
            this.parent.addFunctionHandler(o);
        }
        if (this.functionHandlers == null) {
            this.functionHandlers = new ArrayList();
        }
        if (o instanceof FunctionHandler) {
            FunctionHandler fh = (FunctionHandler)o;
            fh.setQuery(this);
        }
        this.functionHandlers.add(o);
    }

    public void setFrom(Expression exp) {
        this.from = exp;
    }

    public Expression getFrom() {
        return this.from;
    }

    public void setClassName(String n) {
        ConstantExpression ce = new ConstantExpression();
        this.from = ce;
        ce.setValue(n);
    }

    public void setOrderByColumns(List cols) {
        this.orderBys = cols;
    }

    public void setGroupByLimit(Limit g) {
        this.groupByLimit = g;
    }

    public void setGroupByOrderColumns(List cols) {
        this.groupOrderBys = cols;
    }

    public List getGroupByColumns() {
        return this.groupBys;
    }

    public void setGroupByColumns(List cols) {
        this.groupBys = cols;
    }

    public List getColumns() {
        return this.cols;
    }

    public void setColumns(List cols) {
        this.cols = cols;
    }

    public void setHaving(Expression be) {
        this.having = be;
    }

    public void setWhere(Expression be) {
        this.where = be;
    }

    public Query() {
        this.initFunctionHandlers();
    }

    public void setWantTimings(boolean v) {
        this.wantTimings = v;
    }

    protected void addTiming(String id, double time) {
        if (this.wantTimings) {
            if (this.qd == null) {
                return;
            }
            if (this.qd.timings == null) {
                this.qd.timings = new LinkedHashMap();
            }
            this.qd.timings.put(id, new Double(time));
        }
    }

    public Object getVariable(int index) {
        if (this.parent != null) {
            return this.parent.getVariable(index);
        }
        return this.getVariable(INT_BIND_VAR_PREFIX + index);
    }

    public Class getVariableClass(String name) {
        String n = name.toLowerCase();
        if (n.equals(QUERY_BIND_VAR_NAME)) {
            return Query.class;
        }
        if (n.equals(PARENT_BIND_VAR_NAME)) {
            return Query.class;
        }
        if (n.equals(CURR_OBJ_VAR_NAME)) {
            return this.objClass;
        }
        if (n.equals(ALL_OBJS_VAR_NAME)) {
            return List.class;
        }
        if (this.parent != null) {
            return this.parent.getVariableClass(n);
        }
        if (this.bindVars == null) {
            return Object.class;
        }
        Object v = this.bindVars.get(n);
        if (v == null) {
            return Object.class;
        }
        return v.getClass();
    }

    public Object getGroupByVariable(int ind) {
        if (this.currGroupBys != null) {
            return this.currGroupBys.get(ind - 1);
        }
        return null;
    }

    public Object getVariable(String name) {
        String n = name.toLowerCase();
        if (n.startsWith(":")) {
            n = n.substring(1);
        }
        if (n.equals(QUERY_BIND_VAR_NAME)) {
            return this;
        }
        if (n.equals(PARENT_BIND_VAR_NAME)) {
            return this.parent;
        }
        if (n.equals(CURR_OBJ_VAR_NAME)) {
            return this.currentObject;
        }
        if (n.equals(ALL_OBJS_VAR_NAME)) {
            return this.allObjects;
        }
        if (this.parent != null) {
            return this.parent.getVariable(name);
        }
        if (this.bindVars == null) {
            return null;
        }
        return this.bindVars.get(n);
    }

    public void setVariable(String name, Object v) {
        if (this.parent != null) {
            this.parent.setVariable(name, v);
            return;
        }
        if (this.bindVars == null) {
            this.bindVars = new HashMap();
        }
        if (name.startsWith(":")) {
            name = name.substring(1);
        }
        this.bindVars.put(name.toLowerCase(), v);
    }

    public void setVariable(int index, Object v) {
        if (this.parent != null) {
            this.parent.setVariable(index, v);
            return;
        }
        this.setVariable(INT_BIND_VAR_PREFIX + index, v);
    }

    public Map getVariables() {
        if (this.parent != null) {
            return this.parent.getVariables();
        }
        return this.bindVars;
    }

    public boolean isWhereTrue(Object o) throws QueryExecutionException {
        if (this.where == null) {
            return true;
        }
        return this.where.isTrue(o, this);
    }

    public void setVariables(Map bVars) {
        if (this.parent != null) {
            this.parent.setVariables(bVars);
            return;
        }
        for (Map.Entry item : bVars.entrySet()) {
            Object k = item.getKey();
            Object v = item.getValue();
            if (k instanceof Number) {
                this.setVariable(((Number)k).intValue(), v);
                continue;
            }
            this.setVariable(k.toString(), v);
        }
    }

    public void doExecuteOn(List l, String t) throws QueryExecutionException {
        if (this.executeOn == null) {
            return;
        }
        if (!this.isParsed) {
            throw new QueryExecutionException("Query has not been initialised.");
        }
        if (this.executeOn != null) {
            this.allObjects = l;
            long s = System.currentTimeMillis();
            List fs = (List)this.executeOn.get(t);
            if (fs != null) {
                int si = fs.size();
                for (int i = 0; i < si; ++i) {
                    AliasedExpression f = (AliasedExpression)fs.get(i);
                    Object o = f.getValue(null, this);
                    String af = f.getAlias();
                    if (af == null) continue;
                    this.setSaveValue(af, o);
                }
                this.addTiming("Total time to execute: " + si + " expression(s) on " + t + " objects", System.currentTimeMillis() - s);
            }
        }
    }

    private void clearResults() {
        this.qd = null;
        this.currentObject = null;
        this.allObjects = null;
        this.currGroupBys = null;
    }

    public QueryResults execute(Iterator iter) throws QueryExecutionException {
        if (iter == null && this.objClass != null) {
            throw new QueryExecutionException("Iterator must be non-null when an object class is specified.");
        }
        ArrayList l = new ArrayList();
        while (iter.hasNext()) {
            l.add(iter.next());
        }
        return this.execute(l);
    }

    public QueryResults execute(Collection objs) throws QueryExecutionException {
        if (objs == null && this.objClass != null) {
            throw new QueryExecutionException("Collection of objects must be non-null when an object class is specified.");
        }
        ArrayList l = new ArrayList(objs.size());
        l.addAll(objs);
        return this.execute(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResults execute(List objs) throws QueryExecutionException {
        if (objs == null && this.objClass != null) {
            throw new QueryExecutionException("List of objects must be non-null when an object class is specified.");
        }
        this.qd = new QueryResults();
        if (this.objClass == null && objs == null) {
            objs = nullQueryList;
        }
        this.allObjects = objs;
        this.doExecuteOn(objs, ALL);
        this.evalWhereClause();
        this.doExecuteOn(this.qd.results, RESULTS);
        this.evalHavingClause();
        if (this.grouper != null) {
            this.evalGroupByClause();
            return this.qd;
        }
        this.evalOrderByClause();
        this.evalLimitClause();
        this.evalSelectClause();
        try {
            QueryResults queryResults = this.qd;
            return queryResults;
        }
        finally {
            this.clearResults();
        }
    }

    private void evalSelectClause() throws QueryExecutionException {
        SelectItemExpression sei;
        boolean retNewObjs = false;
        if (!this.retObjs && this.cols.size() == 1 && (sei = (SelectItemExpression)this.cols.get(0)).getExpression() instanceof NewObjectExpression) {
            retNewObjs = true;
        }
        long s = System.currentTimeMillis();
        if (!this.retObjs && !retNewObjs) {
            AbstractCollection resC = null;
            resC = !this.distinctResults ? new ArrayList(this.qd.results.size()) : new LinkedHashSet(this.qd.results.size());
            this.getColumnValues(this.qd.results, resC);
            this.qd.results = this.distinctResults ? new ArrayList(resC) : (List)((Object)resC);
            this.addTiming("Collection of results took", System.currentTimeMillis() - s);
        } else {
            if (this.retObjs && this.distinctResults) {
                s = System.currentTimeMillis();
                this.qd.results = ((CollectionFunctions)this.getFunctionHandler("_internal_collection")).unique(this.qd.results);
                this.addTiming("Collecting unique results took", System.currentTimeMillis() - s);
            }
            if (retNewObjs) {
                this.qd.results = this.getNewObjectSingleColumnValues(this.qd.results);
            }
        }
    }

    private void evalOrderByClause() throws QueryExecutionException {
        if (this.qd.results.size() > 1 && this.orderByComp != null) {
            long s = System.currentTimeMillis();
            Collections.sort(this.qd.results, this.orderByComp);
            this.addTiming("Total time to order results", System.currentTimeMillis() - s);
        }
        if (this.orderByComp != null) {
            ListExpressionComparator lec = (ListExpressionComparator)this.orderByComp;
            if (lec.getException() != null) {
                throw new QueryExecutionException("Unable to order results", lec.getException());
            }
            lec.clearCache();
        }
    }

    private void evalGroupByClause() throws QueryExecutionException {
        long s = System.currentTimeMillis();
        try {
            Map mres;
            s = System.currentTimeMillis();
            this.qd.groupByResults = mres = this.grouper.group(this.qd.results);
            List<Object> grpBys = new ArrayList(mres.keySet());
            Map origSvs = this.qd.saveValues;
            LinkedHashMap nres = new LinkedHashMap();
            int gs = grpBys.size();
            for (int i = 0; i < gs; ++i) {
                List l = (List)grpBys.get(i);
                List lr = (ArrayList)mres.get(l);
                this.allObjects = lr;
                this.currGroupBys = l;
                if (this.qd.groupBySaveValues == null) {
                    this.qd.groupBySaveValues = new HashMap();
                }
                this.qd.saveValues = new HashMap();
                if (origSvs != null) {
                    this.qd.saveValues.putAll(origSvs);
                }
                this.qd.groupBySaveValues.put(l, this.qd.saveValues);
                this.doExecuteOn(lr, GROUP_BY_RESULTS);
                if (lr.size() > 1 && this.orderByComp != null) {
                    Collections.sort(lr, this.orderByComp);
                    ListExpressionComparator lec = (ListExpressionComparator)this.orderByComp;
                    if (lec.getException() != null) {
                        throw new QueryExecutionException("Unable to order group by results", lec.getException());
                    }
                    lec.clearCache();
                }
                if (!this.retObjs) {
                    AbstractCollection res = null;
                    res = !this.distinctResults ? new ArrayList() : new LinkedHashSet();
                    this.getColumnValues(lr, res);
                    lr = this.distinctResults ? new ArrayList(res) : (List)((Object)res);
                } else if (this.distinctResults) {
                    this.qd.results = ((CollectionFunctions)this.getFunctionHandler("_internal_collection")).unique(this.qd.results);
                }
                nres.put(l, lr);
            }
            this.qd.saveValues = origSvs;
            this.qd.groupByResults = nres;
            long t = System.currentTimeMillis();
            this.addTiming("Group column collection and sort took", t - s);
            s = t;
            if (this.groupOrderByComp != null) {
                origSvs = this.qd.saveValues;
                Collections.sort(grpBys, this.groupOrderByComp);
                this.qd.saveValues = origSvs;
                GroupByExpressionComparator lec = (GroupByExpressionComparator)this.groupOrderByComp;
                if (lec.getException() != null) {
                    throw new QueryExecutionException("Unable to order group bys, remember that the current object here is a java.util.List, not the class defined in the FROM clause, you may need to use the org.josq.functions.CollectionFunctions.get(java.util.List,Number) function to get access to the relevant value from the List.", lec.getException());
                }
                lec.clearCache();
            }
            if (this.groupByLimit != null) {
                s = System.currentTimeMillis();
                ArrayList oGrpBys = grpBys;
                grpBys = this.groupByLimit.getSubList(grpBys, this);
                for (int i = 0; i < oGrpBys.size(); ++i) {
                    List l = (List)oGrpBys.get(i);
                    if (grpBys.contains(l)) continue;
                    this.qd.groupByResults.remove(l);
                }
                this.addTiming("Total time to limit group by results size", System.currentTimeMillis() - s);
            }
            this.addTiming("Group operation took", System.currentTimeMillis() - s);
            this.qd.saveValues = origSvs;
            this.qd.results = grpBys;
            if (this.limit != null) {
                for (int i = 0; i < this.qd.results.size(); ++i) {
                    List lr;
                    List l = (List)this.qd.results.get(i);
                    this.allObjects = lr = (List)this.qd.groupByResults.get(l);
                    this.currGroupBys = l;
                    this.qd.saveValues = (Map)this.qd.groupBySaveValues.get(l);
                    this.qd.groupByResults.put(l, this.limit.getSubList(lr, this));
                }
            }
            this.qd.saveValues = origSvs;
        }
        catch (Exception e) {
            throw new QueryExecutionException("Unable to perform group by operation", e);
        }
    }

    private void evalHavingClause() throws QueryExecutionException {
        if (this.having != null) {
            int si = this.qd.results.size();
            this.qd.havingResults = new ArrayList(si);
            for (int i = 0; i < si; ++i) {
                Object o = this.qd.results.get(i);
                this.currentObject = o;
                if (!this.having.isTrue(o, this)) continue;
                this.qd.havingResults.add(o);
            }
            this.allObjects = this.qd.results = this.qd.havingResults;
        }
    }

    private void evalLimitClause() throws QueryExecutionException {
        if (this.limit != null) {
            long s = System.currentTimeMillis();
            this.qd.results = this.limit.getSubList(this.qd.results, this);
            this.addTiming("Total time to limit results size", System.currentTimeMillis() - s);
        }
    }

    private void evalWhereClause() throws QueryExecutionException {
        long s = System.currentTimeMillis();
        int si = this.allObjects.size();
        if (this.where != null) {
            this.qd.whereResults = new ArrayList(si / 2);
            for (int i = 0; i < si; ++i) {
                Object o = this.allObjects.get(i);
                this.currentObject = o;
                boolean res = this.where.isTrue(o, this);
                if (!res) continue;
                this.qd.whereResults.add(o);
            }
        } else {
            this.qd.whereResults = this.allObjects;
        }
        double wet = (double)System.currentTimeMillis() - (double)s;
        this.addTiming("Total time to execute Where clause on all objects", wet);
        this.addTiming("Where took average over: " + si + " objects", wet / (double)si);
        this.allObjects = this.qd.whereResults;
        this.qd.results = this.qd.whereResults;
    }

    public void setCurrentGroupByObjects(List objs) {
        this.currGroupBys = objs;
    }

    public List getAllObjects() {
        return this.allObjects;
    }

    public void setAllObjects(List objs) {
        this.allObjects = objs;
    }

    public void setCurrentObject(Object o) {
        this.currentObject = o;
    }

    public Object getCurrentObject() {
        return this.currentObject;
    }

    private void getColumnValues(List res, Collection rs) throws QueryExecutionException {
        int s = res.size();
        int cs = this.cols.size();
        boolean addItems = false;
        for (int i = 0; i < s; ++i) {
            Object o = res.get(i);
            this.currentObject = o;
            ArrayList<Object> sRes = new ArrayList<Object>(cs);
            for (int j = 0; j < cs; ++j) {
                SelectItemExpression v = (SelectItemExpression)this.cols.get(j);
                try {
                    if (v.isAddItemsFromCollectionOrMap()) {
                        addItems = true;
                    }
                    Object ov = v.getValue(o, this);
                    if (addItems) {
                        rs.addAll(v.getAddItems(ov));
                    } else {
                        sRes.add(ov);
                    }
                    this.currentObject = o;
                    continue;
                }
                catch (Exception e) {
                    throw new QueryExecutionException("Unable to get value for column: " + j + " for: " + v.toString() + " from result: " + i + " (" + o + ")", e);
                }
            }
            if (addItems) continue;
            rs.add(sRes);
        }
    }

    private List getNewObjectSingleColumnValues(List rows) throws QueryExecutionException {
        int s = rows.size();
        SelectItemExpression nsei = (SelectItemExpression)this.cols.get(0);
        ArrayList<Object> res = new ArrayList<Object>(s);
        for (int i = 0; i < s; ++i) {
            Object o = rows.get(i);
            this.currentObject = o;
            try {
                res.add(nsei.getValue(o, this));
                this.currentObject = o;
                continue;
            }
            catch (Exception e) {
                throw new QueryExecutionException("Unable to get value for column: 1 for: " + nsei.toString() + " from result: " + i + " (" + o + ")", e);
            }
        }
        return res;
    }

    public void setSaveValues(Map s) {
        if (this.parent != null) {
            this.parent.qd.saveValues.putAll(s);
            return;
        }
        this.qd.saveValues = s;
    }

    public void setSaveValue(Object id, Object value) {
        if (this.parent != null) {
            this.parent.setSaveValue(id, value);
            return;
        }
        if (this.qd == null) {
            return;
        }
        if (id instanceof String) {
            id = ((String)id).toLowerCase();
        }
        Object old = this.qd.saveValues.get(id);
        this.qd.saveValues.put(id, value);
        if (old != null) {
            this.fireSaveValueChangedEvent(id, old, value);
        }
    }

    protected void fireSaveValueChangedEvent(Object id, Object from, Object to) {
        List l = (List)this.listeners.get("svs");
        if (l == null || l.size() == 0) {
            return;
        }
        SaveValueChangedEvent svce = new SaveValueChangedEvent(this, id.toString().toLowerCase(), from, to);
        for (int i = 0; i < l.size(); ++i) {
            SaveValueChangedListener svcl = (SaveValueChangedListener)l.get(i);
            svcl.saveValueChanged(svce);
        }
    }

    protected void fireBindVariableChangedEvent(String name, Object from, Object to) {
        List l = (List)this.listeners.get("bvs");
        if (l == null || l.size() == 0) {
            return;
        }
        BindVariableChangedEvent bvce = new BindVariableChangedEvent(this, name, from, to);
        for (int i = 0; i < l.size(); ++i) {
            BindVariableChangedListener bvcl = (BindVariableChangedListener)l.get(i);
            bvcl.bindVariableChanged(bvce);
        }
    }

    public Object getGroupBySaveValue(Object id, List gbs) {
        if (this.parent != null) {
            return this.parent.getGroupBySaveValue(id, gbs);
        }
        Map m = this.getGroupBySaveValues(gbs);
        if (m == null) {
            return null;
        }
        return m.get(id);
    }

    public Map getGroupBySaveValues(List gbs) {
        if (this.parent != null) {
            return this.parent.getGroupBySaveValues(gbs);
        }
        if (this.qd == null || this.qd.groupBySaveValues == null) {
            return null;
        }
        return (Map)this.qd.groupBySaveValues.get(gbs);
    }

    public Object getSaveValue(Object id) {
        if (this.parent != null) {
            return this.parent.getSaveValue(id);
        }
        if (this.qd == null || this.qd.saveValues == null) {
            return null;
        }
        if (id instanceof String) {
            id = ((String)id).toLowerCase();
        }
        return this.qd.saveValues.get(id);
    }

    public String getQuery() {
        return this.query;
    }

    public void setObjectComparator(Comparator c) {
        this.userComparator = c;
    }

    public Comparator getObjectComparator() {
        return this.userComparator;
    }

    public void initOrderByComparator() throws QueryParseException {
        if (this.orderBys != null) {
            this.orderByComp = new ListExpressionComparator(this, this.userComparator, false);
            ListExpressionComparator lec = (ListExpressionComparator)this.orderByComp;
            int si = this.orderBys.size();
            for (int i = 0; i < si; ++i) {
                OrderBy ob = (OrderBy)this.orderBys.get(i);
                Expression e = ob.getExpression();
                if (e == null) {
                    int ci = ob.getIndex();
                    if (ci == 0) {
                        throw new QueryParseException("Order by column indices should start at 1.");
                    }
                    if (this.retObjs) {
                        throw new QueryParseException("Cannot sort on a select column index when the objects are to be returned.");
                    }
                    if (ci > this.cols.size()) {
                        throw new QueryParseException("Invalid order by column index: " + ci + ", only: " + this.cols.size() + " columns are selected to be returned.");
                    }
                    SelectItemExpression sei = (SelectItemExpression)this.cols.get(ci - 1);
                    e = sei.getExpression();
                } else {
                    e.init(this);
                }
                if (e.hasFixedResult(this)) continue;
                lec.addSortItem(e, ob.getType());
            }
        }
    }

    public QueryResults reorder(List objs, SortedMap dirs) throws QueryExecutionException, QueryParseException {
        if (this.isWantObjects()) {
            throw new QueryParseException("Only SQL statements that return columns (not the objects passed in) can be re-ordered.");
        }
        ArrayList<OrderBy> obs = new ArrayList<OrderBy>();
        for (Map.Entry item : dirs.entrySet()) {
            Integer in = (Integer)item.getKey();
            if (in > this.cols.size()) {
                throw new QueryParseException("Cannot reorder: " + dirs.size() + " columns, only: " + this.cols.size() + " are present in the SQL statement.");
            }
            String dir = (String)item.getValue();
            int d = 0;
            if (dir.equals(ORDER_BY_DESC)) {
                d = 1;
            }
            OrderBy ob = new OrderBy();
            ob.setIndex(in);
            ob.setType(d);
            obs.add(ob);
        }
        this.orderBys = obs;
        this.initOrderByComparator();
        return this.execute(objs);
    }

    public QueryResults reorder(List objs, String orderBys) throws QueryParseException, QueryExecutionException {
        String sql = "";
        if (!orderBys.toLowerCase().startsWith("order by")) {
            sql = sql + " ORDER BY ";
        }
        sql = sql + orderBys;
        BufferedReader sr = new BufferedReader(new StringReader(sql));
        JoSQLParser parser = new JoSQLParser(sr);
        List ors = null;
        try {
            ors = parser.OrderBys();
        }
        catch (Exception e) {
            throw new QueryParseException("Unable to parse order bys: " + orderBys, e);
        }
        this.orderBys = ors;
        this.initOrderByComparator();
        return this.execute(objs);
    }

    public void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
            if (this.classLoader == null) {
                this.classLoader = this.getClass().getClassLoader();
            }
        }
        return this.classLoader;
    }

    public Class loadClass(String name) throws Exception {
        return this.getClassLoader().loadClass(name);
    }

    public void parse(String q) throws QueryParseException {
        this.query = q;
        BufferedReader sr = new BufferedReader(new StringReader(q));
        long s = System.currentTimeMillis();
        JoSQLParser parser = new JoSQLParser(sr);
        this.addTiming("Time to init josql parser object", System.currentTimeMillis() - s);
        s = System.currentTimeMillis();
        try {
            parser.parseQuery(this);
        }
        catch (Exception e) {
            throw new QueryParseException("Unable to parse query: " + q, e);
        }
        this.isParsed = true;
        this.addTiming("Time to parse query into object form", System.currentTimeMillis() - s);
        this.init();
    }

    private void initFromObjectClass() throws QueryParseException {
        if (this.parent == null) {
            if (!(this.from instanceof ConstantExpression)) {
                throw new QueryParseException("The FROM clause of the outer-most Query must be a string that denotes a fully-qualified class name, expression: " + this.from + " is not valid.");
            }
            String cn = null;
            try {
                cn = (String)this.from.getValue(null, this);
            }
            catch (Exception e) {
                throw new QueryParseException("Unable to determine FROM clause of the outer-most Query from expression: " + this.from + ", note: this exception shouldn't be able to happen, so something has gone SERIOUSLY wrong!", e);
            }
            if (!cn.equalsIgnoreCase("null")) {
                try {
                    this.objClass = this.loadClass(cn);
                }
                catch (Exception e) {
                    throw new QueryParseException("Unable to load FROM class: " + cn, e);
                }
            }
        }
    }

    public void init() throws QueryParseException {
        long s = System.currentTimeMillis();
        this.initFromObjectClass();
        this.initSelect();
        if (this.where != null) {
            this.where.init(this);
        }
        if (this.having != null) {
            this.having.init(this);
        }
        this.initOrderByComparator();
        if (this.groupBys != null) {
            this.initGroupBys();
        }
        this.initGroupOrderBys();
        if (this.groupByLimit != null) {
            this.groupByLimit.init(this);
        }
        if (this.limit != null) {
            this.limit.init(this);
        }
        this.initExecuteOn();
        this.addTiming("Time to init Query objects", System.currentTimeMillis() - s);
    }

    private void initSelect() throws QueryParseException {
        if (this.retObjs) {
            return;
        }
        int aic = 0;
        int si = this.cols.size();
        this.aliases = new HashMap();
        for (int i = 0; i < si; ++i) {
            String alias;
            SelectItemExpression exp = (SelectItemExpression)this.cols.get(i);
            exp.init(this);
            if (exp.isAddItemsFromCollectionOrMap()) {
                ++aic;
            }
            if ((alias = exp.getAlias()) != null) {
                this.aliases.put(alias, i + 1);
            }
            this.aliases.put(i + 1 + "", i + 1);
        }
        if (aic > 0 && aic != si) {
            throw new QueryParseException("If one or more SELECT clause columns is set to add the items returned from a: " + Map.class.getName() + " or: " + Collection.class.getName() + " then ALL columns must be marked to return the items as well.");
        }
    }

    private void initGroupBys() throws QueryParseException {
        this.grouper = new Grouper(this);
        int si = this.groupBys.size();
        for (int i = 0; i < si; ++i) {
            OrderBy ob = (OrderBy)this.groupBys.get(i);
            Expression e = ob.getExpression();
            if (e == null) {
                int ci = ob.getIndex();
                if (ci == 0) {
                    throw new QueryParseException("Order by column indices should start at 1.");
                }
                if (this.retObjs) {
                    throw new QueryParseException("Cannot sort on a select column index when the objects are to be returned.");
                }
                if (ci > this.cols.size()) {
                    throw new QueryParseException("Invalid order by column index: " + ci + ", only: " + this.cols.size() + " columns are selected to be returned.");
                }
                SelectItemExpression sei = (SelectItemExpression)this.cols.get(ci - 1);
                e = sei.getExpression();
            } else {
                e.init(this);
            }
            this.grouper.addExpression(e);
        }
    }

    private void initExecuteOn() throws QueryParseException {
        AliasedExpression f;
        int si;
        List resultsF;
        if (this.executeOn == null) {
            return;
        }
        List allF = (List)this.executeOn.get(ALL);
        if (allF != null) {
            int si2 = allF.size();
            for (int i = 0; i < si2; ++i) {
                AliasedExpression f2 = (AliasedExpression)allF.get(i);
                f2.init(this);
            }
        }
        if ((resultsF = (List)this.executeOn.get(RESULTS)) != null) {
            si = resultsF.size();
            for (int i = 0; i < si; ++i) {
                f = (AliasedExpression)resultsF.get(i);
                f.init(this);
            }
        }
        if ((resultsF = (List)this.executeOn.get(GROUP_BY_RESULTS)) != null) {
            si = resultsF.size();
            for (int i = 0; i < si; ++i) {
                f = (AliasedExpression)resultsF.get(i);
                f.init(this);
            }
        }
    }

    private void initGroupOrderBys() throws QueryParseException {
        if (this.groupOrderBys == null) {
            return;
        }
        if (this.grouper == null) {
            throw new QueryParseException("Group Order Bys are only valid if 1 or more Group By columns have been specified.");
        }
        Class c = this.objClass;
        this.objClass = List.class;
        this.groupOrderByComp = new GroupByExpressionComparator(this, this.userComparator, false);
        GroupByExpressionComparator lec = (GroupByExpressionComparator)this.groupOrderByComp;
        List grouperExps = this.grouper.getExpressions();
        int si = this.groupOrderBys.size();
        for (int i = 0; i < si; ++i) {
            OrderBy ob = (OrderBy)this.groupOrderBys.get(i);
            if (ob.getIndex() > -1) {
                int ci = ob.getIndex();
                if (ci == 0) {
                    throw new QueryParseException("Group Order by column indices should start at 1.");
                }
                if (ci > grouperExps.size()) {
                    throw new QueryParseException("Invalid Group Order By column index: " + ci + ", only: " + grouperExps.size() + " Group By columns are selected to be returned.");
                }
                lec.addSortItem(null, ci - 1, ob.getType());
                continue;
            }
            Expression e = ob.getExpression();
            boolean cont = true;
            for (int j = 0; j < grouperExps.size(); ++j) {
                Expression exp = (Expression)grouperExps.get(j);
                if (!e.equals(exp)) continue;
                lec.addSortItem(null, j, ob.getType());
                cont = false;
            }
            if (!cont) continue;
            if (e instanceof Function || e instanceof BindVariable || e instanceof SaveValue) {
                e.init(this);
                lec.addSortItem(e, -1, ob.getType());
                continue;
            }
            throw new QueryParseException("If the Group Order By: " + ob + " is not a function, a bind variable or a save value then it must be present in the Group By list.");
        }
        this.objClass = c;
    }

    public void setFromObjectClass(Class c) {
        this.objClass = c;
    }

    public Class getFromObjectClass() {
        return this.objClass;
    }

    public void removeBindVariableChangedListener(BindVariableChangedListener bvl) {
        List l = (List)this.listeners.get("bvs");
        if (l == null) {
            return;
        }
        l.remove(bvl);
    }

    public void addBindVariableChangedListener(BindVariableChangedListener bvl) {
        ArrayList<BindVariableChangedListener> l = (ArrayList<BindVariableChangedListener>)this.listeners.get("bvs");
        if (l == null) {
            l = new ArrayList<BindVariableChangedListener>();
            this.listeners.put("bvs", l);
        }
        if (!l.contains(bvl)) {
            l.add(bvl);
        }
    }

    public void removeSaveValueChangedListener(SaveValueChangedListener svl) {
        List l = (List)this.listeners.get("svs");
        if (l == null) {
            return;
        }
        l.remove(svl);
    }

    public void addSaveValueChangedListener(SaveValueChangedListener svl) {
        ArrayList<SaveValueChangedListener> l = (ArrayList<SaveValueChangedListener>)this.listeners.get("svs");
        if (l == null) {
            l = new ArrayList<SaveValueChangedListener>();
            this.listeners.put("svs", l);
        }
        if (!l.contains(svl)) {
            l.add(svl);
        }
    }

    public Map getAliases() {
        return this.aliases;
    }

    public boolean isWantObjects() {
        return this.retObjs;
    }

    public void setWantObjects(boolean v) {
        this.retObjs = v;
    }

    public char getWildcardCharacter() {
        return this.wildcardChar;
    }

    public void setWildcardCharacter(char c) {
        this.wildcardChar = c;
    }

    public void setLimit(Limit l) {
        this.limit = l;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public boolean parsed() {
        return this.isParsed;
    }

    public void setWantDistinctResults(boolean v) {
        this.distinctResults = v;
    }

    public QueryResults getQueryResults() {
        return this.qd;
    }

    public List getOrderByColumns() {
        return new ArrayList(this.orderBys);
    }

    public void setParent(Query q) {
        this.parent = q;
    }

    public Query getParent() {
        return this.parent;
    }

    public Query getTopLevelQuery() {
        Query q = this;
        Query par = null;
        while ((par = q.getParent()) != null) {
            q = par;
        }
        return q;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("SELECT ");
        if (this.distinctResults) {
            buf.append("DISTINCT ");
        }
        if (this.retObjs) {
            buf.append("*");
        } else {
            for (int i = 0; i < this.cols.size(); ++i) {
                buf.append(" ");
                buf.append(this.cols.get(i));
                if (i >= this.cols.size() - 1) continue;
                buf.append(",");
            }
        }
        buf.append(" FROM ");
        buf.append(this.from);
        if (this.where != null) {
            buf.append(" WHERE ");
            buf.append(this.where);
        }
        return buf.toString();
    }

    public static QueryResults parseAndExec(String query, List objs) throws QueryParseException, QueryExecutionException {
        Query q = new Query();
        q.parse(query);
        return q.execute(objs);
    }

    static {
        nullQueryList.add(new Object());
    }
}

