%% Please kindly cite our paper if you use this code for your research:
%% https://doi.org/10.1016/j.nicl.2025.103939
%% Resting State Functional Connectivity Patterns Associate with Alcohol Use Disorder Characteristics: Insights from the Triple Network Model.
%% (2025) D Guerrero, M Dzemidzic, M Moghaddam, M Liu, A Avena-Koenigsberger, J Harezlak, DA Kareken, MH Plawecki, MA Cyders, J Goñi.
%% NeuroImage Clinical 49, 103939.

%% This package reproduces the PLS results shown in Figure 3
%% please use python notebook spls_fugure.ipynb to replicate the actual Figure
%% Daniel Guerrero. CONNplexity Lab. Purdue University. January 30, 2026


close all
clearvars
clc

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% REQUIRED PACKAGES TO DOWNLOAD
%% Download spls package at: https://github.com/jmmonteiro/spls/blob/master/spls.m 
addpath(fullfile(pwd,'spls-master'));
%% Download npy-matlab package at:https://github.com/kwikteam/npy-matlab/tree/master
addpath(fullfile(pwd,'npy-matlab-master','npy-matlab'));

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% NON-REGULARIZED PLS
x = readNPY('data/pls_input/connectivity.npy');
y = readNPY('data/pls_input/phenotype.npy');
x_reg = inf;
y_reg = inf;

%% Component Drinking/Age
[u,v] = spls(x,y,x_reg,y_reg);
writeNPY(u,'data/pls_output/conn_load_c1.npy'); %% Save connectivity loadings for PLS Component 1
writeNPY(v,'data/pls_output/phen_load_c1.npy'); %% Save phenotype loadings for PLS Component 1
%% Component FHD/Urgency
[x,y] = proj_def(x, y, u, v);
[u,v] = spls(x,y,x_reg,y_reg);
writeNPY(u,'data/pls_output/conn_load_c2.npy'); %% Save connectivity loadings for PLS Component 2
writeNPY(v,'data/pls_output/phen_load_c2.npy'); %% Save phenotype loadings for PLS Component 2
%% Component Alcohol Seeking/Sex
[x,y] = proj_def(x, y, u, v);
[u,v] = spls(x,y,x_reg,y_reg);
writeNPY(u,'data/pls_output/conn_load_c3.npy'); %% Save connectivity loadings for PLS Component 3
writeNPY(v,'data/pls_output/phen_load_c3.npy'); %% Save phenotype loadings for PLS Component 3
%% Component Education
[x,y] = proj_def(x, y, u, v);
[u,v] = spls(x,y,x_reg,y_reg);
writeNPY(u,'data/pls_output/conn_load_c4.npy'); %% Save connectivity loadings for PLS Component 4
writeNPY(v,'data/pls_output/phen_load_c4.npy'); %% Save phenotype loadings for PLS Component 4


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% REGULARIZED PLS
x = readNPY('data/pls_input/connectivity.npy');
y = readNPY('data/pls_input/phenotype.npy');
%% See supplementary material Figures S9 and S10 for the choice of x_reg and y_reg values
x_reg = 49.0;
y_reg = 1.5;

%% Component Drinking/Age
[u,v] = spls(x,y,x_reg,y_reg);
writeNPY(u,'data/pls_output/conn_load_reg_c1.npy'); %% Save regularized connectivity loadings for PLS Component 1
writeNPY(v,'data/pls_output/phen_load_reg_c1.npy'); %% Save regularized phenotype loadings for PLS Component 1
%% Component FHD/Urgency
[x,y] = proj_def(x, y, u, v);
[u,v] = spls(x,y,x_reg,y_reg);
writeNPY(u,'data/pls_output/conn_load_reg_c2.npy'); %% Save regularized connectivity loadings for PLS Component 2
writeNPY(v,'data/pls_output/phen_load_reg_c2.npy'); %% Save regularized phenotype loadings for PLS Component 2
%% Component Alcohol Seeking/Sex
[x,y] = proj_def(x, y, u, v);
[u,v] = spls(x,y,x_reg,y_reg);
writeNPY(u,'data/pls_output/conn_load_reg_c3.npy'); %% Save regularized connectivity loadings for PLS Component 3
writeNPY(v,'data/pls_output/phen_load_reg_c3.npy'); %% Save regularized phenotype loadings for PLS Component 3
%% Component Education
[x,y] = proj_def(x, y, u, v);
[u,v] = spls(x,y,x_reg,y_reg);
writeNPY(u,'data/pls_output/conn_load_reg_c4.npy'); %% Save regularized connectivity loadings for PLS Component 4
writeNPY(v,'data/pls_output/phen_load_reg_c4.npy'); %% Save regularized phenotype loadings for PLS Component 4

%% Use saved regularized loadings with the pyhton notebook spls_figure.ipynb to create Figure 3