function reformat_axes_routine(varargin)
% This function updates the x axis tick labels and the colorbar symbols for 2D plots
% when the x axis contains dates.
% The purpose is to force the desired x axis format and to ensure the colorbar is correct.
% (M.Jokic 2003)

axis_handles=findobj(gcf,'Type','axes');
main_axis_handle=min(axis_handles);
if length(axis_handles)>=2
    colorbar_handle=max(axis_handles); % the colorbar is drawn last so has the higher handle number
    operation=num2str(isequal(colorbar_handle,gca));
else
    operation='no_color_bar';
end

switch operation

case '0'
        
    if isequal(get(gcf,'userdata'),2)
        %edit y axis for zooming
        set(gca,'YTickLabelMode','auto')
        datetick('y',26,'keeplimits')
    end
    
    %locate current x axis text labels and remove
    label_handles=findobj(gcf,'Tag','label');
    delete(label_handles);
    
    axes(main_axis_handle)
    x_ticks=get(main_axis_handle,'XTick');
    x_ticks_date=datestr(x_ticks,26);
    min_y_axis=min(get(main_axis_handle,'YLim'));
    for ii=1:size(x_ticks,2)
        text(x_ticks(ii), min_y_axis, x_ticks_date(ii,:),'Rotation',-20,'VerticalAlignment','Top','FontSize',10,...
            'Tag','label')
    end
    
    axes(colorbar_handle)
    % update colorbar if symbols present - only symbols appear to be removed from the colorbar during plot manipulation
    primary_symbol=findobj(colorbar_handle,'Marker','o');
    if ~isempty(primary_symbol)
        % an observed trick to return symbols to the foreground
        h=get(colorbar_handle,'Children');
        w=sort(h);
        set(colorbar_handle,'Children',w)
        set(colorbar_handle,'Children',h)
    end
    
case '1'
    
    % An emergency reformat of the colorbar if symbols go missing
    
    axes(colorbar_handle)
    % update colorbar if symbols present - only symbols appear to be removed from the colorbar during plot manipulation
    primary_symbol=findobj(colorbar_handle,'Marker','o');
    if ~isempty(primary_symbol)
        % an observed trick to return symbols to the foreground
        h=get(colorbar_handle,'Children');
        w=sort(h);
        set(colorbar_handle,'Children',w)
        set(colorbar_handle,'Children',h)
    end
    
case 'no_color_bar'
    
    % reformat axes only
    if isequal(get(gcf,'userdata'),2)
        %edit y axis for zooming
        set(gca,'YTickLabelMode','auto')
        datetick('y',26,'keeplimits')
    end
    
    %locate current x axis text labels and remove
    label_handles=findobj(gcf,'Tag','label');
    delete(label_handles);
    
    axes(main_axis_handle)
    x_ticks=get(main_axis_handle,'XTick');
    x_ticks_date=datestr(x_ticks,26);
    min_y_axis=min(get(main_axis_handle,'YLim'));
    for ii=1:size(x_ticks,2)
        text(x_ticks(ii), min_y_axis, x_ticks_date(ii,:),'Rotation',-20,'VerticalAlignment','Top','FontSize',10,...
            'Tag','label')
    end
    
end