function plotting_3D_routine(control_panel_numbers,control_panel_strings,handles)
%% --------------------------------------------------------------------
%  3D PLOTTING CODE
%% --------------------------------------------------------------------
% The inputs from the control panel are used to manipulate the data obained from the AUTO1 file.
% 3D plots are generated, which represent 3 or 4 dimensions of data.
% (M.Jokic 2003)

global AUTO1_data path_vector simulation_information_array path_events_string_labels
global MENU_EVENT_STRING PLANET_DATA_LABELS MANEUVER_DATA_LABELS
global FIGURE_NUMBER PLOT_SYMBOLS PLOT_NUMBERS COLOR_SCHEME AXIS_LABELS FONT_SIZE

% flags
dim2_is_x_axis_flag=0;
dim4_is_plotted_flag=0;
manuever_flag=isequal(get(handles.tag_pop_dim1_prop,'String'),MANEUVER_DATA_LABELS);
X_is_date=0; %flag to determine if date requested
Y_is_date=0;
Z_is_date=0;
DIM4_is_date=0;

%text parameters
label_connection=': ';

% matrix sizes for data location in AUTO1_data
auto1_data_size=size(AUTO1_data);
planet_data_labels_size=size(PLANET_DATA_LABELS);
maneuver_data_labels_size=size(MANEUVER_DATA_LABELS);
number_of_events=max(size(path_vector));
number_of_trajectories=floor(auto1_data_size(1)/number_of_events);
% print warning if unexpected number of trajectories
if rem(auto1_data_size(1),number_of_events)~=0
    set(handles.tag_text_message,'String','*** Unexpected Number of Trajectories ***')
end

%%%%%% redefine PLOT NUMBERS
PLOT_NUMBERS=str2num(control_panel_strings(8,:));
%%%%%% redefine PLOT SYMBOLS
PLOT_SYMBOLS=PLOT_SYMBOLS(1:str2num(control_panel_strings(9,:)));

% ---
% X-axis data points
% ---

% ---
% find row and column indexes of data
row_x_axis_data=control_panel_numbers(1)-1;
if isequal(get(handles.tag_pop_dim1_prop,'String'),MANEUVER_DATA_LABELS) % maneuver selected
    if control_panel_numbers(2)==1 %delta V 
        column_x_axis_data=5;
        row_x_axis_data=control_panel_numbers(1)-1;
        text_x_label=[deblank(path_events_string_labels(control_panel_numbers(1)-1,:))...
                label_connection deblank(AXIS_LABELS(end,:))];
    elseif control_panel_numbers(2)==2 %date 
        X_is_date=1;
        column_x_axis_data=auto1_data_size(2);
        row_x_axis_data=control_panel_numbers(1)-2;
        text_x_label=[deblank(path_events_string_labels(control_panel_numbers(1)-1,:))...
                label_connection deblank(AXIS_LABELS(1,:))];
    else % all other options
        column_x_axis_data=control_panel_numbers(2)+4;
        text_x_label=[deblank(path_events_string_labels(control_panel_numbers(1)-1,:))...
                label_connection deblank(AXIS_LABELS(control_panel_numbers(2)+1,:))];
    end
else % planet event selected
    if control_panel_numbers(2)==1 %date 
        X_is_date=1;
        if control_panel_numbers(1)~=2
            column_x_axis_data=auto1_data_size(2);
            row_x_axis_data=control_panel_numbers(1)-2;
        else
            row_x_axis_data=control_panel_numbers(1)-1;
            column_x_axis_data=1;
        end
    elseif control_panel_numbers(2)==2 %Vinf 
        column_x_axis_data=6 ;
    elseif control_panel_numbers(2)==3|control_panel_numbers(2)==4 % theta or altitude
        column_x_axis_data=control_panel_numbers(2)+1;
    elseif control_panel_numbers(2)==planet_data_labels_size(1) %TOF
        column_x_axis_data=auto1_data_size(2);
        row_x_axis_data=control_panel_numbers(1)-2;
    else  %the rest
        column_x_axis_data=control_panel_numbers(2)+2;
    end
    if isequal(control_panel_numbers(1),2) %launch event
        text_x_label=[deblank(path_events_string_labels(control_panel_numbers(1)-1,:))...
                ' Launch' label_connection deblank(AXIS_LABELS(control_panel_numbers(2),:))];
    elseif isequal(control_panel_numbers(1)-1,max(size(path_vector))) %arrival event
        text_x_label=[deblank(path_events_string_labels(control_panel_numbers(1)-1,:))...
                ' Arrival' label_connection deblank(AXIS_LABELS(control_panel_numbers(2),:))];
    else
        text_x_label=[deblank(path_events_string_labels(control_panel_numbers(1)-1,:))...
                label_connection deblank(AXIS_LABELS(control_panel_numbers(2),:))];
    end
end
% ---
% check conditions: >= <= == ALL
if control_panel_numbers(3)~=1
    if control_panel_numbers(3)==2
        data=AUTO1_data(row_x_axis_data:number_of_events:end,column_x_axis_data);
        index_match=find(data<=str2num(control_panel_strings(1,:)));
        X_axis_indexes=index_match*number_of_events-number_of_events+row_x_axis_data;
    elseif control_panel_numbers(3)==3
        data=AUTO1_data(row_x_axis_data:number_of_events:end,column_x_axis_data);
        index_match=find(data>=str2num(control_panel_strings(1,:)));
        X_axis_indexes=index_match*number_of_events-number_of_events+row_x_axis_data;
    elseif control_panel_numbers(3)==4
        data=AUTO1_data(row_x_axis_data:number_of_events:end,column_x_axis_data);
        index_match=find(data==str2num(control_panel_strings(1,:)));
        X_axis_indexes=index_match*number_of_events-number_of_events+row_x_axis_data;
    end
else
    X_axis_indexes=[row_x_axis_data:number_of_events:auto1_data_size(1)];
end

% ---
% Y-axis data points
% ---

% ---
% find row and column indexes of data
row_y_axis_data=control_panel_numbers(4)-1;
if isequal(get(handles.tag_pop_dim2_prop,'String'),MANEUVER_DATA_LABELS) % maneuver selected
    if control_panel_numbers(5)==1 %delta V 
        column_y_axis_data=5;
        row_y_axis_data=control_panel_numbers(4)-1;
        text_y_label=[deblank(path_events_string_labels(control_panel_numbers(4)-1,:))...
                label_connection deblank(AXIS_LABELS(end,:))];
    elseif control_panel_numbers(5)==2 %date 
        Y_is_date=1;
        column_y_axis_data=auto1_data_size(2);
        row_y_axis_data=control_panel_numbers(4)-2;
        text_y_label=[deblank(path_events_string_labels(control_panel_numbers(4)-1,:))...
                label_connection deblank(AXIS_LABELS(1,:))];
    else % all other options
        column_y_axis_data=control_panel_numbers(2)+4;
        text_y_label=[deblank(path_events_string_labels(control_panel_numbers(4)-1,:))...
                label_connection deblank(AXIS_LABELS(control_panel_numbers(5)+1,:))];
    end
else % planet event selected
    if control_panel_numbers(5)==1 %date 
        Y_is_date=1;
        if control_panel_numbers(4)~=2
            column_y_axis_data=auto1_data_size(2);
            row_y_axis_data=control_panel_numbers(4)-2;
        else
            row_y_axis_data=control_panel_numbers(4)-1;
            column_y_axis_data=1;
        end
    elseif control_panel_numbers(5)==2 %Vinf 
        column_y_axis_data=6; 
    elseif control_panel_numbers(5)==3|control_panel_numbers(5)==4 % theta or altitude
        column_y_axis_data=control_panel_numbers(5)+1;
    elseif control_panel_numbers(5)==planet_data_labels_size(1) %TOF
        column_y_axis_data=auto1_data_size(2);
        row_y_axis_data=control_panel_numbers(4)-2;
    else  %the rest
        column_y_axis_data=control_panel_numbers(4)+2;
    end
    if isequal(control_panel_numbers(4),2) %launch event
        text_y_label=[deblank(path_events_string_labels(control_panel_numbers(4)-1,:))...
                ' Launch' label_connection deblank(AXIS_LABELS(control_panel_numbers(5),:))];
    elseif isequal(control_panel_numbers(4)-1,max(size(path_vector))) %arrival event
        text_y_label=[deblank(path_events_string_labels(control_panel_numbers(4)-1,:))...
                ' Arrival' label_connection deblank(AXIS_LABELS(control_panel_numbers(5),:))];
    else
        text_y_label=[deblank(path_events_string_labels(control_panel_numbers(4)-1,:))...
                label_connection deblank(AXIS_LABELS(control_panel_numbers(5),:))];
    end
end
    % ---
% check conditions: >= <= == ALL
if control_panel_numbers(6)~=1
    if control_panel_numbers(6)==2
        data=AUTO1_data(row_y_axis_data:number_of_events:end,column_y_axis_data);
        index_match=find(data<=str2num(control_panel_strings(2,:)));
        Y_axis_indexes=index_match*number_of_events-number_of_events+row_y_axis_data;
    elseif control_panel_numbers(6)==3
        data=AUTO1_data(row_y_axis_data:number_of_events:end,column_y_axis_data);
        index_match=find(data>=str2num(control_panel_strings(2,:)));
        Y_axis_indexes=index_match*number_of_events-number_of_events+row_y_axis_data;
    elseif control_panel_numbers(6)==4
        data=AUTO1_data(row_y_axis_data:number_of_events:end,column_y_axis_data);
        index_match=find(data==str2num(control_panel_strings(2,:)));
        Y_axis_indexes=index_match*number_of_events-number_of_events+row_y_axis_data;
    end
else
    Y_axis_indexes=[row_y_axis_data:number_of_events:auto1_data_size(1)];
end

% ---
% Z-axis data points
% ---

% ---
% find row and column indexes of data
row_z_axis_data=control_panel_numbers(7)-1;

if isequal(get(handles.tag_pop_dim3_prop,'String'),MANEUVER_DATA_LABELS) % maneuver selected
    if control_panel_numbers(8)==1 %delta V 
        column_z_axis_data=5;
        row_z_axis_data=control_panel_numbers(7)-1;
        text_z_label=[deblank(path_events_string_labels(control_panel_numbers(7)-1,:))...
                label_connection deblank(AXIS_LABELS(end,:))];
    elseif control_panel_numbers(8)==2 %date 
        Z_is_date=1;
        column_z_axis_data=auto1_data_size(2);
        row_z_axis_data=control_panel_numbers(7)-2;
        text_z_label=[deblank(path_events_string_labels(control_panel_numbers(7)-1,:))...
                label_connection deblank(AXIS_LABELS(1,:))];
    else % all other options
        column_z_axis_data=control_panel_numbers(8)+4;
        text_z_label=[deblank(path_events_string_labels(control_panel_numbers(7)-1,:))...
                label_connection deblank(AXIS_LABELS(control_panel_numbers(8)+1,:))];
    end
else % planet event selected
    if control_panel_numbers(8)==1 %date 
        Z_is_date=1;
        if control_panel_numbers(7)~=2
            column_z_axis_data=auto1_data_size(2);
            row_z_axis_data=control_panel_numbers(7)-2;
        else
            row_z_axis_data=control_panel_numbers(7)-1
            column_z_axis_data=1;
        end
    elseif control_panel_numbers(8)==2 %Vinf 
        column_z_axis_data=6; 
    elseif control_panel_numbers(8)==3|control_panel_numbers(8)==4 % theta or altitude
        column_z_axis_data=control_panel_numbers(8)+1;
    elseif control_panel_numbers(8)==planet_data_labels_size(1) %TOF
        column_z_axis_data=auto1_data_size(2);
        row_z_axis_data=control_panel_numbers(7)-2;
    else  %the rest
        column_z_axis_data=control_panel_numbers(8)+2;
    end
    if isequal(control_panel_numbers(7),2) %launch event
        text_z_label=[deblank(path_events_string_labels(control_panel_numbers(7)-1,:))...
                ' Launch' label_connection deblank(AXIS_LABELS(control_panel_numbers(8),:))];
    elseif isequal(control_panel_numbers(7)-1,max(size(path_vector))) %arrival event
        text_z_label=[deblank(path_events_string_labels(control_panel_numbers(7)-1,:))...
                ' Arrival' label_connection deblank(AXIS_LABELS(control_panel_numbers(8),:))];
    else
        text_z_label=[deblank(path_events_string_labels(control_panel_numbers(7)-1,:))...
                label_connection deblank(AXIS_LABELS(control_panel_numbers(8),:))];
    end
end
% ---
% check conditions: >= <= == ALL
if control_panel_numbers(9)~=1
    if control_panel_numbers(9)==2
        data=AUTO1_data(row_z_axis_data:number_of_events:end,column_z_axis_data);
        index_match=find(data<=str2num(control_panel_strings(3,:)));
        Z_axis_indexes=index_match*number_of_events-number_of_events+row_z_axis_data;
    elseif control_panel_numbers(9)==3
        data=AUTO1_data(row_z_axis_data:number_of_events:end,column_z_axis_data);
        index_match=find(data>=str2num(control_panel_strings(3,:)));
        Z_axis_indexes=index_match*number_of_events-number_of_events+row_z_axis_data;
    elseif control_panel_numbers(9)==4
        data=AUTO1_data(row_z_axis_data:number_of_events:end,column_z_axis_data);
        index_match=find(data==str2num(control_panel_strings(3,:)));
        Z_axis_indexes=index_match*number_of_events-number_of_events+row_z_axis_data;
    end
else
    Z_axis_indexes=[row_z_axis_data:number_of_events:auto1_data_size(1)];
end

% ---
% DIM4 data points
% ---

if control_panel_numbers(10)~=1
    dim4_is_plotted_flag=1;
    % ---
    % find row and column indexes of data
    row_dim4_data=control_panel_numbers(10)-1;
    if isequal(get(handles.tag_pop_dim4_prop,'String'),MANEUVER_DATA_LABELS) % maneuver selected
        if control_panel_numbers(11)==1 %delta V 
            column_dim4_data=5;
            row_dim4_data=control_panel_numbers(10)-1;
            text_dim4_label=[deblank(path_events_string_labels(control_panel_numbers(10)-1,:))...
                    label_connection deblank(AXIS_LABELS(end,:))];
        elseif control_panel_numbers(11)==2 %date 
            DIM4_is_date=1;
            column_dim4_data=auto1_data_size(2);
            row_dim4_data=control_panel_numbers(10)-2;
            text_dim4_label=[deblank(path_events_string_labels(control_panel_numbers(10)-1,:))...
                    label_connection deblank(AXIS_LABELS(1,:))];
        else % all other options
            column_dim4_data=control_panel_numbers(11)+4;
            text_dim4_label=[deblank(path_events_string_labels(control_panel_numbers(10)-1,:))...
                    label_connection deblank(AXIS_LABELS(control_panel_numbers(11)+1,:))];
        end
    else % planet event selected
        if control_panel_numbers(11)==1 %date 
            DIM4_is_date=1;
            if control_panel_numbers(10)~=2
                column_dim4_data=auto1_data_size(2);
                row_dim4_data=control_panel_numbers(10)-2;
            else %launch
                row_dim4_data=control_panel_numbers(10)-1;
                column_dim4_data=1;
            end
        elseif control_panel_numbers(11)==2 %Vinf 
            column_dim4_data=6; 
        elseif control_panel_numbers(11)==3|control_panel_numbers(11)==4 % theta or altitude
            column_dim4_data=control_panel_numbers(11)+1;
        elseif control_panel_numbers(11)==planet_data_labels_size(1) %TOF
            column_dim4_data=auto1_data_size(2);
            row_dim4_data=control_panel_numbers(10)-2;
        else  %the rest
            column_dim4_data=control_panel_numbers(11)+2;
        end
        if isequal(control_panel_numbers(10),2) %launch event
            text_dim4_label=[deblank(path_events_string_labels(control_panel_numbers(10)-1,:))...
                    ' Launch' label_connection deblank(AXIS_LABELS(control_panel_numbers(10),:))];
        elseif isequal(control_panel_numbers(10)-1,max(size(path_vector))) %arrival event
            text_dim4_label=[deblank(path_events_string_labels(control_panel_numbers(10)-1,:))...
                    ' Arrival' label_connection deblank(AXIS_LABELS(control_panel_numbers(11),:))];
        else
            text_dim4_label=[deblank(path_events_string_labels(control_panel_numbers(10)-1,:))...
                    label_connection deblank(AXIS_LABELS(control_panel_numbers(11),:))];
        end
    end
    % ---
    % check conditions: >= <= == ALL
    if control_panel_numbers(12)~=1
        if control_panel_numbers(12)==2
            data=AUTO1_data(row_dim4_data:number_of_events:end,column_dim4_data);
            index_match=find(data<=str2num(control_panel_strings(4,:)));
            DIM4_indexes=index_match*number_of_events-number_of_events+row_dim4_data;
        elseif control_panel_numbers(12)==3
            data=AUTO1_data(row_dim4_data:number_of_events:end,column_dim4_data);
            index_match=find(data>=str2num(control_panel_strings(4,:)));
            DIM4_indexes=index_match*number_of_events-number_of_events+row_dim4_data;
        elseif control_panel_numbers(12)==4
            data=AUTO1_data(row_dim4_data:number_of_events:end,column_dim4_data);
            index_match=find(data==str2num(control_panel_strings(4,:)))
            DIM4_indexes=index_match*number_of_events-number_of_events+row_dim4_data
        end
    else
        DIM4_indexes=[row_dim4_data:number_of_events:auto1_data_size(1)];
    end
end

% find valid trajectory numbers if 3D plot possible
if ~isempty(X_axis_indexes)&dim4_is_plotted_flag==1
    X_trajectories=ceil((X_axis_indexes)/number_of_events);
    Y_trajectories=ceil((Y_axis_indexes)/number_of_events);
    Z_trajectories=ceil((Z_axis_indexes)/number_of_events);
    DIM4_trajectories=ceil((DIM4_indexes)/number_of_events);
else
    DIM4_trajectories=[];  
    X_trajectories=ceil((X_axis_indexes)/number_of_events);
    Y_trajectories=ceil((Y_axis_indexes)/number_of_events);
    Z_trajectories=ceil((Z_axis_indexes)/number_of_events);
end

% ---
% General Trajectory Checks - called if minimum altitude or maximum TOF set
% ---
%check for minium altitude constraint
if ~isequal(control_panel_numbers(17),1)
    limit_value=str2num(control_panel_strings(6,:));
    column_to_check=4; %minimum altitude of flybys
    index_launch=1:number_of_events:auto1_data_size(1);
    index_arrival=number_of_events:number_of_events:auto1_data_size(1);
    if ismember(0,path_vector)
        maneuver_positions=find(path_vector==0);
        for ii=1:max(size(maneuver_positions))
            maneuver_indexes_find(ii,:)=maneuver_positions(ii):number_of_events:auto1_data_size(1);
        end
        maneuver_indexes=unique(maneuver_indexes_find(1:end));
    else
        maneuver_indexes=[];
    end
    if isequal(control_panel_numbers(17),2) %<=
        index_match=find(AUTO1_data(1:end,column_to_check)>limit_value);
        index_match_arrival=setdiff(index_match,index_arrival);
        index_match_launch=setdiff(index_match_arrival,index_launch);
        index_match_manuever=setdiff(index_match_launch,maneuver_indexes);
    elseif isequal(control_panel_numbers(17),3) %>=
        index_match=find(AUTO1_data(1:end,column_to_check)<limit_value);
        index_match_arrival=setdiff(index_match,index_arrival);
        index_match_launch=setdiff(index_match_arrival,index_launch);
        index_match_manuever=setdiff(index_match_launch,maneuver_indexes);
    elseif isequal(control_panel_numbers(17),4) %==
        index_match=find(AUTO1_data(1:end,column_to_check)~=limit_value);
        index_match_arrival=setdiff(index_match,index_arrival);
        index_match_launch=setdiff(index_match_arrival,index_launch);
        index_match_manuever=setdiff(index_match_launch,maneuver_indexes);
    end
    %check against X axis trajectories
    invalid_trajectories=unique(ceil(index_match_manuever/number_of_events));
    checked_against_x_trajectories=setdiff(X_trajectories,invalid_trajectories);
    X_trajectories=checked_against_x_trajectories;
         
end
%check for TOF constraint
if ~isequal(control_panel_numbers(18),1)
    limit_value=str2num(control_panel_strings(7,:));
    column_to_check=11; %minimum altitude of flybys - last column
    index_launch=1:number_of_events:auto1_data_size(1);
    index_arrival_tof=number_of_events-1:number_of_events:auto1_data_size(1);

    if isequal(control_panel_numbers(18),2) %<=
        index_match=find(AUTO1_data(index_arrival_tof,column_to_check)<=limit_value);
    elseif isequal(control_panel_numbers(18),3) %>=
        index_match=find(AUTO1_data(index_arrival_tof,column_to_check)>=limit_value);
    elseif isequal(control_panel_numbers(18),4) %==
        index_match=find(AUTO1_data(index_arrival_tof,column_to_check)==limit_value);
    end
    %check against X axis trajectories
    valid_tof_trajectories=unique(ceil(((index_match*number_of_events)-1)/number_of_events));
    checked_against_x_trajectories=intersect(valid_tof_trajectories,X_trajectories);
    X_trajectories=checked_against_x_trajectories;
         
end

% evaluate valid indexes for plotting
if ~isempty(X_trajectories)&~isempty(Y_trajectories)&~isempty(Z_trajectories)&~isempty(DIM4_trajectories);
    common_x_y_trajectories=intersect(X_trajectories,Y_trajectories);
    common_dim4_x_y_trajectories=intersect(common_x_y_trajectories,DIM4_trajectories);
    common_dim4_x_y_z_trajectories=intersect(common_dim4_x_y_trajectories,Z_trajectories);
    valid_trajectories=common_dim4_x_y_z_trajectories;
    if ~isempty(common_dim4_x_y_z_trajectories)
        plotting_status='go_4_dim';
        set(handles.tag_text_numpoints,'String',num2str(max(size(common_dim4_x_y_z_trajectories))))
        final_X_axis_indexes=(common_dim4_x_y_z_trajectories*number_of_events)-number_of_events+row_x_axis_data;
        final_Y_axis_indexes=(common_dim4_x_y_z_trajectories*number_of_events)-number_of_events+row_y_axis_data;
        final_Z_axis_indexes=(common_dim4_x_y_z_trajectories*number_of_events)-number_of_events+row_z_axis_data;
        final_DIM4_indexes=(common_dim4_x_y_z_trajectories*number_of_events)-number_of_events+row_dim4_data;
    else
        plotting_status='stop'
        set(handles.tag_text_message,'String','*** No trajectories found ***')
    end
elseif isequal(dim4_is_plotted_flag,1)&isempty(DIM4_trajectories)
        plotting_status='stop'
        set(handles.tag_text_message,'String','*** No trajectories found ***')
elseif ~isempty(X_trajectories)&~isempty(Y_trajectories)&~isempty(Z_trajectories)
    common_x_y_trajectories=intersect(X_trajectories,Y_trajectories);
    common_x_y_z_trajectories=intersect(common_x_y_trajectories,Y_trajectories);
    valid_trajectories=common_x_y_z_trajectories;
    if ~isempty(common_x_y_trajectories)
        plotting_status='go_3_dim';
        set(handles.tag_text_numpoints,'String',num2str(max(size(common_x_y_trajectories))))
        final_X_axis_indexes=(common_x_y_z_trajectories*number_of_events)-number_of_events+row_x_axis_data;
        final_Y_axis_indexes=(common_x_y_z_trajectories*number_of_events)-number_of_events+row_y_axis_data;
        final_Z_axis_indexes=(common_x_y_z_trajectories*number_of_events)-number_of_events+row_z_axis_data;
    else
        plotting_status='stop';
        set(handles.tag_text_message,'String','*** No trajectories found ***')
    end
else
    plotting_status='stop'
    set(handles.tag_text_message,'String','*** No trajectories found ***')
end

%%% Define Data Points
if isequal(plotting_status,'go_4_dim')|isequal(plotting_status,'go_3_dim')
    % check if date requested but only TOF data available
    if column_x_axis_data~=1&X_is_date==1
        X_DATA=AUTO1_data(final_X_axis_indexes,column_x_axis_data)+AUTO1_data(final_X_axis_indexes-row_x_axis_data+1,1);
    else
        X_DATA=AUTO1_data(final_X_axis_indexes,column_x_axis_data);
    end
    
    if column_y_axis_data~=1&Y_is_date==1
        Y_DATA=AUTO1_data(final_Y_axis_indexes,column_y_axis_data)+AUTO1_data(final_Y_axis_indexes-row_y_axis_data+1,1);
    else
        Y_DATA=AUTO1_data(final_Y_axis_indexes,column_y_axis_data);
    end

    if column_z_axis_data~=1&Z_is_date==1
        Z_DATA=AUTO1_data(final_Z_axis_indexes,column_z_axis_data)+AUTO1_data(final_Z_axis_indexes-row_z_axis_data+1,1);
    else
        Z_DATA=AUTO1_data(final_Z_axis_indexes,column_z_axis_data);
    end
    
    if isequal(plotting_status,'go_4_dim')&column_dim4_data~=1&DIM4_is_date==1
        DIM4_DATA=AUTO1_data(final_DIM4_indexes,column_dim4_data)+AUTO1_data(final_DIM4_indexes-row_dim4_data+1,1);
    elseif isequal(plotting_status,'go_4_dim')
        DIM4_DATA=AUTO1_data(final_DIM4_indexes,column_dim4_data);
    end
end

% -----------------------------------------------------------------
% Time to start plotting now that the data has been found!
% -----------------------------------------------------------------

% ---
% plot for 3 axes and Dimension 4 data
% ---
if isequal(plotting_status,'go_4_dim')
    % DIM4 limits
    upper_limit_dim4=max(DIM4_DATA);
    lower_limit_dim4=min(DIM4_DATA);
    DIM4_data_range=upper_limit_dim4-lower_limit_dim4;
    if isequal(DIM4_data_range,0)
        plotting_status='go_3_dim';
    end
    
    %create large figure
    screen_size=get(0,'ScreenSize');
    FIGURE_NUMBER=figure('Position',[100 60 0.8*screen_size(3) 0.8*screen_size(4)]);
    hold on
%%%%% ---
    % set color information
%%%%% ---
    control_panel_color_number=str2num(control_panel_strings(5,:));
    cmap=COLOR_SCHEME(fix([1:size(COLOR_SCHEME,1)/control_panel_color_number:size(COLOR_SCHEME,1)]),:);
    colormap(cmap);
    %check for white
    totals_cmap=sum(cmap,2);
    white_check=find(totals_cmap==3);
    if ~isempty(white_check)
        cmap(white_check,:)=rand(1,3);
        colormap(cmap);
    end
%%%% ---

    % Plot number characters
    if length(PLOT_NUMBERS)<10
        for ii=1:PLOT_NUMBERS
            plot_number_vector(ii)={[num2str(ii)]};
        end
    else
        for ii=1:PLOT_NUMBERS
            plot_number_vector(ii)={['(' num2str(ii) ')']};
        end
    end
    % create plot steps
    if DIM4_data_range~=0
        color_step=DIM4_data_range/control_panel_color_number;
        color_indication_vector=ceil((DIM4_DATA...
            -lower_limit_dim4)/color_step);
        %check for 0 results
        indication_0_check=find(color_indication_vector<1);
        if ~isempty(indication_0_check)
            color_indication_vector(indication_0_check)=1;
        else
            indication_0_check=[];
        end
        number_step=DIM4_data_range/PLOT_NUMBERS;
        number_indication_vector=ceil((DIM4_DATA...
            -lower_limit_dim4)/number_step);
        %check for 0 results
        indication_0_check=find(number_indication_vector<1);
        if ~isempty(indication_0_check)
            number_indication_vector(indication_0_check)=1;
        else
            indication_0_check=[];
        end
        symbol_step=DIM4_data_range/str2num(control_panel_strings(9,:));
        symbol_indication_vector=ceil((DIM4_DATA...
            -lower_limit_dim4)/symbol_step);
        %check for 0 results
        indication_0_check=find(symbol_indication_vector<1);
        if ~isempty(indication_0_check)
            symbol_indication_vector(indication_0_check)=1;
        else
            indication_0_check=[];
        end
    end

%%%%%begin plotting
    index_limit=max(size(common_dim4_x_y_z_trajectories));
    if isequal(control_panel_numbers(14),1)&isequal(control_panel_numbers(16),1) % Numbers and Color 
        if plotting_status=='go_3_dim' %only 1 value to plot
            for jj=1:max(size(common_dim4_x_y_z_trajectories))
                text(X_DATA(jj),Y_DATA(jj),Z_DATA(jj),...
                    plot_number_vector(1),'HorizontalAlignment','Center','Color',[0 0 1],'FontWeight','bold',...
                    'ButtonDownFcn','FIND_TRAJECTORY','UserData',valid_trajectories(jj));
            end
        else
            for jj=1:index_limit
                text(X_DATA(jj),Y_DATA(jj),Z_DATA(jj),...
                    plot_number_vector(number_indication_vector(jj)),'HorizontalAlignment','Center',...
                    'Color',cmap(color_indication_vector(jj),:),'FontWeight','bold','Clipping','on',...
                    'ButtonDownFcn','FIND_TRAJECTORY','UserData',valid_trajectories(jj));
            end
        end
    elseif isequal(control_panel_numbers(14),1) % Numbers only
        if plotting_status=='go_3_dim'
            for jj=1:index_limit
                text(X_DATA(jj),Y_DATA(jj),Z_DATA(jj),...
                    plot_number_vector(1),'HorizontalAlignment','Center','Color','k','FontWeight','bold','Clipping','on',...
                    'ButtonDownFcn','FIND_TRAJECTORY','UserData',valid_trajectories(jj));
            end
        else
            for jj=1:index_limit
                text(X_DATA(jj),Y_DATA(jj),Z_DATA(jj),...
                    plot_number_vector(number_indication_vector(jj)),'HorizontalAlignment',...
                    'Center','Color',[0 0 0],'FontWeight','bold','Clipping','on',...
                    'ButtonDownFcn','FIND_TRAJECTORY','UserData',valid_trajectories(jj));
            end
        end
    elseif isequal(control_panel_numbers(15),1)&~isequal(control_panel_numbers(16),1) % Symbols only
        if plotting_status=='go_3_dim'
            for jj=1:index_limit
                plot3(X_DATA(jj),Y_DATA(jj),Z_DATA(jj),...
                    'ko','MarkerSize',7,'ButtonDownFcn','FIND_TRAJECTORY','UserData',valid_trajectories(jj));
            end
        else
            for jj=1:index_limit
                plot3(X_DATA(jj),Y_DATA(jj),Z_DATA(jj),...
                    'Marker',PLOT_SYMBOLS(symbol_indication_vector(jj)),'Color',[0 0 0],'MarkerSize',7,'LineWidth',1.5,...
                    'ButtonDownFcn','FIND_TRAJECTORY','UserData',valid_trajectories(jj));
            end
        end
    elseif isequal(control_panel_numbers(15),1)&isequal(control_panel_numbers(16),1) % Symbols and Colors
        if plotting_status=='go_3_dim'
            for jj=1:index_limit
                plot3(X_DATA(jj),Y_DATA(jj),Z_DATA(jj),...
                    'Marker',PLOT_SYMBOLS(1),'LineStyle','none',...
                    'Color',[0 0 1],'MarkerSize',7,'LineWidth',1.5,...
                    'ButtonDownFcn','FIND_TRAJECTORY','UserData',valid_trajectories(jj));
            end
        else
            for jj=1:index_limit
                plot3(X_DATA(jj),Y_DATA(jj),Z_DATA(jj),...
                    'Marker',PLOT_SYMBOLS(symbol_indication_vector(jj)),'LineStyle','none',...
                    'MarkerSize',7,'Color',cmap(color_indication_vector(jj),:),'LineWidth',1.5,...
                    'ButtonDownFcn','FIND_TRAJECTORY','UserData',valid_trajectories(jj));
            end
        end
    elseif isequal(control_panel_numbers(16),1) % Colors
        if plotting_status=='go_3_dim'
            for jj=1:index_limit
                plot3(X_DATA(jj),Y_DATA(jj),Z_DATA(jj),...
                    'Marker',PLOT_SYMBOLS(1),'LineStyle','none',...
                    'Color',[0 0 1],'MarkerSize',7,'LineWidth',1.5,...
                    'ButtonDownFcn','FIND_TRAJECTORY','UserData',valid_trajectories(jj));
            end
        else
            for jj=1:index_limit
                plot3(X_DATA(jj),Y_DATA(jj),Z_DATA(jj),...
                    'Marker',PLOT_SYMBOLS(1),'LineStyle','none',...
                    'MarkerSize',7,'Color',cmap(color_indication_vector(jj),:),'LineWidth',1.5,...
                    'ButtonDownFcn','FIND_TRAJECTORY','UserData',valid_trajectories(jj));
            end
        end
    end
% ---    
% plot for 3 axes.  No DIM4 data.
% ---
elseif isequal(plotting_status,'go_3_dim')
    screen_size=get(0,'ScreenSize');
    FIGURE_NUMBER=figure('Position',[100 60 0.8*screen_size(3) 0.8*screen_size(4)]);
    hold on
    for ii=1:PLOT_NUMBERS
        plot_number_vector(ii)={['(' num2str(ii) ')']};
    end
    cmap=colormap(jet(str2num(control_panel_strings(5,:))+5));
    
    index_limit=max(size(common_x_y_z_trajectories));
    if isequal(control_panel_numbers(14),1) % Numbers 
            for jj=1:index_limit
                text(X_DATA(jj),Y_DATA(jj),Z_DATA(jj),...
                    plot_number_vector(1),'HorizontalAlignment','Center','Color',[0 0 0],'FontWeight','bold','Clipping','on',...
                    'ButtonDownFcn','FIND_TRAJECTORY','UserData',valid_trajectories(jj));
            end
    elseif isequal(control_panel_numbers(15),1) % Symbols 
        for jj=1:index_limit
            plot3(X_DATA(jj),Y_DATA(jj),Z_DATA(jj),...
                'ko','MarkerSize',7,'LineWidth',1.5,...
                'ButtonDownFcn','FIND_TRAJECTORY','UserData',valid_trajectories(jj));
        end
    elseif isequal(control_panel_numbers(16),1) % Colors
        for jj=1:index_limit
            plot3(X_DATA(jj),Y_DATA(jj),Z_DATA(jj),...
                'Marker',PLOT_SYMBOLS(1),'LineStyle','none',...
                'Color',[0 0 1],'MarkerSize',7,'LineWidth',1.5,...
                'ButtonDownFcn','FIND_TRAJECTORY','UserData',valid_trajectories(jj));
        end
    end
end
    
%
%
% ----------------------------------------------------------------------------------------------------------------------------
% Formatting for 3D plots
if isequal(plotting_status,'go_3_dim')|isequal(plotting_status,'go_4_dim')
    %axis
    box on
    set(gca,'FontSize',FONT_SIZE(5))
    view(3) %3D view
    %title
    title_text=strvcat([upper(deblank(simulation_information_array(1,:))) blanks(5) deblank(simulation_information_array(4,:)) ...
            blanks(5) deblank(simulation_information_array(6,:))],...
        [deblank(simulation_information_array(3,:)) blanks(5)  deblank(simulation_information_array(5,:))]);
    title(title_text,'FontSize',FONT_SIZE(1),'Units','normalized','Position',[0.55 1.01 0],'HorizontalAlignment','center')
    %axis labels
    xlabel(text_x_label,'FontSize',FONT_SIZE(2))
    ylabel(text_y_label,'FontSize',FONT_SIZE(3))
    zlabel(text_z_label,'FontSize',FONT_SIZE(4))
    
    %limits
    percent_limit_for_x_axis=0.1*(max(X_DATA)-min(X_DATA));
    if percent_limit_for_x_axis==0;
        percent_limit_for_x_axis=0.1*max(X_DATA);
    end
    percent_limit_for_y_axis=0.1*(max(Y_DATA)-min(Y_DATA));
    if percent_limit_for_y_axis==0;
        percent_limit_for_y_axis=0.1*max(Y_DATA);
    end
    percent_limit_for_z_axis=0.1*(max(Z_DATA)-min(Z_DATA));
    if percent_limit_for_z_axis==0;
        percent_limit_for_z_axis=0.1*max(Z_DATA);
    end
    axis([min(X_DATA)-percent_limit_for_x_axis...
            max(X_DATA)+percent_limit_for_x_axis...
            min(Y_DATA)-percent_limit_for_y_axis...
            max(Y_DATA)+percent_limit_for_y_axis...
            min(Z_DATA)-percent_limit_for_z_axis...
            max(Z_DATA)+percent_limit_for_z_axis])
    if isequal(Y_is_date,1)
        datetick('y',26,'keeplimits')
    end
    if isequal(X_is_date,1)
        datetick('x',26,'keeplimits')
    end
    if isequal(Z_is_date,1)
        datetick('z',26,'keeplimits')
    end
    
    check_colorbar=isequal(control_panel_numbers(16),1)|isequal(control_panel_numbers(13),1);
    if  check_colorbar==1&isequal(plotting_status,'go_4_dim') %colorbar if contour or color plot and multiple DIM4 points
        handle_colorbar=colorbar;
        if isequal(control_panel_numbers(15),1) %include symbols 
            set(handle_colorbar,'NextPlot','add','ButtonDownFcn','reformat_axes_routine')
            axes(handle_colorbar)
            symbols_to_plot=PLOT_SYMBOLS;
            tick_step=size(cmap,1)/max(size(symbols_to_plot));
            set(handle_colorbar,'YTick',[1:tick_step:size(cmap,1)+1])
            tick_labels=round(1000*[lower_limit_dim4:symbol_step:upper_limit_dim4])/1000;
            set(handle_colorbar,'YTickLabel',tick_labels,'YGrid','on','GridLineStyle','-')
            if DIM4_is_date==1
                tick_labels=datestr(lower_limit_dim4:symbol_step:upper_limit_dim4,26);
                set(handle_colorbar,'YTickLabel',tick_labels,'YGrid','on','GridLineStyle','-')
            end
            max_colorbar=size(cmap,1);
            symbol_colorbar_location=1-tick_step/2; %plot mid-region
            for ii=1:max(size(symbols_to_plot))
                symbol_colorbar_location=symbol_colorbar_location+tick_step;
                plot(0,symbol_colorbar_location,'Marker',PLOT_SYMBOLS(ii),...
                    'Color',[0 0 0],'MarkerSize',7,'LineWidth',1.5)
            end
        elseif isequal(control_panel_numbers(14),1) %include numbers
            set(handle_colorbar,'NextPlot','add')
            axes(handle_colorbar)
            tick_step=size(cmap,1)/PLOT_NUMBERS;
            set(handle_colorbar,'YTick',[1:tick_step:size(cmap,1)+1])
            tick_labels=round(1000*[lower_limit_dim4:number_step:upper_limit_dim4])/1000;
            set(handle_colorbar,'YTickLabel',tick_labels,'YGrid','on','GridLineStyle','-')
            max_colorbar=size(cmap,1);
            number_colorbar_location=1-tick_step/2; %plot mid-region
            for ii=1:PLOT_NUMBERS
                number_colorbar_location=number_colorbar_location+tick_step;
                text(0,number_colorbar_location,plot_number_vector(ii),...
                    'HorizontalAlignment','Center','Color',[0 0 0],'FontWeight','bold');
            end
        else
            set(handle_colorbar,'YTick',[1:(size(cmap,1)+1)])
            tick_labels=round(1000*[lower_limit_dim4:color_step:upper_limit_dim4])/1000;
            set(handle_colorbar,'YTickLabel',tick_labels)
        end
        % colorbar label
        ylabel(text_dim4_label,'FontSize',FONT_SIZE(6))
    elseif isequal(control_panel_numbers(15),1)&isequal(plotting_status,'go_4_dim') %symbol scale - no color
        symbols_to_plot=PLOT_SYMBOLS;
        cmap=colormap([1 1 1]);
        handle_colorbar=colorbar;
        tick_step=size(cmap,1)/max(size(symbols_to_plot));
        set(handle_colorbar,'YTick',[1:tick_step:size(cmap,1)+1])
        tick_labels=round(1000*[lower_limit_dim4:symbol_step:upper_limit_dim4])/1000;
        set(handle_colorbar,'YTickLabel',tick_labels,'YGrid','on','GridLineStyle','-')
        set(handle_colorbar,'NextPlot','add','ButtonDownFcn','reformat_axes_routine')
        axes(handle_colorbar)
        max_colorbar=size(cmap,1);%max(get(handle_colorbar,'YTick'))
        symbol_colorbar_location=1-tick_step/2; %plot mid-region 
        for ii=1:max(size(symbols_to_plot))
            symbol_colorbar_location=symbol_colorbar_location+tick_step;
            plot(0,symbol_colorbar_location,'Marker',PLOT_SYMBOLS(ii),...
                'Color',[0 0 0],'MarkerSize',7,'LineWidth',1.5)
        end
        % colorbar label
        ylabel(text_dim4_label,'FontSize',FONT_SIZE(6))
    elseif isequal(control_panel_numbers(14),1)&isequal(plotting_status,'go_4_dim') %number scale - no color
        cmap=colormap([1 1 1]);
        handle_colorbar=colorbar;
        tick_step=size(cmap,1)/PLOT_NUMBERS;
        set(handle_colorbar,'YTick',[1:tick_step:size(cmap,1)+1])
        tick_labels=round(1000*[lower_limit_dim4:number_step:upper_limit_dim4])/1000;
        set(handle_colorbar,'YTickLabel',tick_labels,'YGrid','on','GridLineStyle','-')
        set(handle_colorbar,'NextPlot','add')
        axes(handle_colorbar)
        max_colorbar=size(cmap,1);%max(get(handle_colorbar,'YTick'))
        number_colorbar_location=1-tick_step/2; %plot mid-region
        for ii=1:PLOT_NUMBERS
            number_colorbar_location=number_colorbar_location+tick_step;
            text(0,number_colorbar_location,plot_number_vector(ii),...
                'HorizontalAlignment','Center','Color',[0 0 0],'FontWeight','bold');
        end
        % colorbar label
        ylabel(text_dim4_label,'FontSize',FONT_SIZE(6))
    end
    set(handle_colorbar,'FontSize',FONT_SIZE(5))
end

