function varargout = STOUR_PLOT(varargin)
% --------------------------------------------------------------------
% STOUR_PLOT (version 2.0)is the application M-file for STOUR_PLOT.fig.  This program is the core
% of the plotting program as it processes the inputs on the control panel and calls functions 
% to generate 2D or 3D plots representing the trajectories contained in the STOUR AUTO1 file.
%
% The following files are used:
%%% STOUR PLOTS-->
% plotting_2D_routine.m     %
% plotting_3D_routine.m     %
% CREDITS.m                 %
% ReadAUTO1.m               %
% reformat_axes_routine.m   %
% FIND_TRAJECTORY.m         %
%%% TRAJECTORY PLOTS-->
% trajplot.m                %
% ephem.m                   %
% lambert.m                 %
% planetdata.m              %
% twobody.m                 %
% trajcal.m                 %
% - the sun.jpg file is used in the trajectory plot.  If it is not present, a default image is used.
%
%
% The program is capable of handling ballistic trajectories and trajectories with maneuvers.
% (M.Jokic 2003)
% --------------------------------------------------------------------

% --------------------------------------------------------------------
% GLOBAL VARIABLES - FROM ReadAUTO1.m
global AUTO1_data path_vector simulation_information_array path_events_string_labels

global handles %so handles can be seen in workspace

global MENU_EVENT_STRING PLANET_DATA_LABELS MANEUVER_DATA_LABELS

global FIGURE_NUMBER PLOT_SYMBOLS PLOT_NUMBERS COLOR_SCHEME AXIS_LABELS FONT_SIZE

global TRAJECTORY_SELECTION_FLAG

% --------------------------------------------------------------------
% PLOT SETTINGS
% --------------------------------------------------------------------
PLOT_SYMBOLS=['o' '.' 'x' '+' '*' 's' '<' '>' 'd' 'v'];

PLOT_NUMBERS=20;

% color map scheme
color_RG=0.3:0.05:1;
color_scheme_column_G=[ 1-color_RG zeros(size(color_RG))]';
color_scheme_column_R=[ zeros(size(color_RG)) color_RG]';
color_B_half=[0.3:0.05:1];
color_B=[ 0.2 0.2 color_B_half(2:end) 1-color_B_half(3:end)];
color_scheme_column_B=[color_B 0]';
COLOR_SCHEME=[color_scheme_column_R...
        color_scheme_column_G...
        color_scheme_column_B];

% axis labels
AXIS_LABELS=strvcat('Date, yyyy/mm/dd',...
        'V_{\infty}, km/s',...
        'Periapsis Altitude, km',...
        'B-Plane Angle, deg.',...
        'Orbit Period, days',...
        'Orbit Periapsis, AU/Central Body Radius',...
        'Orbit Apoapsis, AU/Central Body Radius',...
        'Time of Flight Since Last Event, days',...
       'Total Time of Flight, days',...
       '{\Delta}V, km/s'); 
   
% font sizes
% [title, xlabel, ylabel, zlabel, axis tick labels, colorbar ylabel]
FONT_SIZE=[12 14 14 14 12 14];

% --------------------------------------------------------------------
% MAIN PROGRAM - INITIALISATION and CALLBACK functions
% --------------------------------------------------------------------

if nargin == 0  % LAUNCH GUI - and initialise variables

	fig = openfig(mfilename,'reuse');

	% Generate a structure of handles to pass to callbacks, and store it. 
	handles = guihandles(fig);
	guidata(fig, handles);

	if nargout > 0
		varargout{1} = fig;
	end
    
    %set panel message
    set(handles.tag_text_message,'String',['Welcome! Today is ' datestr(date,1)])
    
    % Check for existing AUTO1 file
    if ~isempty(AUTO1_data)
        disp('AUTO1 file already loaded')
        set(handles.tag_text_message,'String',['AUTO1 file already loaded!'])
        initialise_control_panel(handles)
    end
    
    
elseif ischar(varargin{1}) % INVOKE NAMED SUBFUNCTION OR CALLBACK

	try
		[varargout{1:nargout}] = feval(varargin{:}); % FEVAL switchyard
	catch
		disp(lasterr);
	end

end


%| ABOUT CALLBACKS:
%| GUIDE automatically appends subfunction prototypes to this file, and 
%| sets objects' callback properties to call them through the FEVAL 
%| switchyard above. This comment describes that mechanism.
%|
%| Each callback subfunction declaration has the following form:
%| <SUBFUNCTION_NAME>(H, EVENTDATA, HANDLES, VARARGIN)
%|
%| The subfunction name is composed using the object's Tag and the 
%| callback type separated by '_', e.g. 'slider2_Callback',
%| 'figure1_CloseRequestFcn', 'axis1_ButtondownFcn'.
%|
%| H is the callback object's handle (obtained using GCBO).
%|
%| EVENTDATA is empty, but reserved for future use.
%|
%| HANDLES is a structure containing handles of components in GUI using
%| tags as fieldnames, e.g. handles.figure1, handles.slider2. This
%| structure is created at GUI startup using GUIHANDLES and stored in
%| the figure's application data using GUIDATA. A copy of the structure
%| is passed to each callback.  You can store additional information in
%| this structure at GUI startup, and you can change the structure
%| during callbacks.  Call guidata(h, handles) after changing your
%| copy to replace the stored original so that subsequent callbacks see
%| the updates. Type "help guihandles" and "help guidata" for more
%| information.
%|
%| VARARGIN contains any extra arguments you have passed to the
%| callback. Specify the extra arguments by editing the callback
%| property in the inspector. By default, GUIDE sets the property to:
%| <MFILENAME>('<SUBFUNCTION_NAME>', gcbo, [], guidata(gcbo))
%| Add any extra arguments after the last argument, before the final
%| closing parenthesis.

% --------------------------------------------------------------------
% Initialise the control panel
% --------------------------------------------------------------------

function vargout=initialise_control_panel(handles)
global AUTO1_data path_vector simulation_information_array path_events_string_labels
global MENU_EVENT_STRING PLANET_DATA_LABELS MANEUVER_DATA_LABELS
global TRAJECTORY_SELECTION_FLAG

% check to see if AUTO1 loaded properly
if isempty(AUTO1_data)|isempty(path_vector)|isempty(simulation_information_array)
    set(handles.tag_text_message,'String',['Error: AUTO1 file not loaded correctly'])
    error('AUTO1 file not loaded correctly')
end

%set panel message
set(handles.tag_text_message,'String',['Welcome! Today is ' datestr(date,1)])

%set trajectory information
set(handles.tag_text_info,'String',deblank(simulation_information_array))

%set dimension4 checkboxes
set(handles.tag_check_dim4_S,'Value',1)
set(handles.tag_check_dim4_C,'Value',1)

% set control panel configuration
set(handles.tag_pop_dim1_event,'Value',1); 
set(handles.tag_pop_dim1_prop,'Value',1); 
set(handles.tag_pop_dim1_prop,'String','None'); 
set(handles.tag_pop_dim1_relate,'Value',1); %All
set(handles.tag_input_dim1_value,'String','Enter Value');

set(handles.tag_pop_dim2_event,'Value',1); 
set(handles.tag_pop_dim2_prop,'Value',1); 
set(handles.tag_pop_dim2_prop,'String','None'); 
set(handles.tag_pop_dim2_relate,'Value',1); %All
set(handles.tag_input_dim2_value,'String','Enter Value');

set(handles.tag_pop_dim3_event,'Value',1);
set(handles.tag_pop_dim3_prop,'Value',1); 
set(handles.tag_pop_dim3_prop,'String','None');
set(handles.tag_pop_dim3_relate,'Value',1);
set(handles.tag_input_dim3_value,'String','Enter Value');

set(handles.tag_pop_dim4_event,'Value',1);
set(handles.tag_pop_dim4_prop,'Value',1);
set(handles.tag_pop_dim4_prop,'String','None'); 
set(handles.tag_pop_dim4_relate,'Value',1);
set(handles.tag_input_dim4_value,'String','Enter Value');
set(handles.tag_check_dim4_cont,'Value',0); %contour plot
set(handles.tag_check_dim4_N,'Value',1);
set(handles.tag_check_dim4_S,'Value',0);
set(handles.tag_check_dim4_C,'Value',1);
set(handles.tag_input_dim4_colors,'String','10');

set(handles.tag_pop_min_alt,'Value',1);
set(handles.tag_input_min_alt,'String','Enter Value');
set(handles.tag_pop_arrival_tof,'Value',1);
set(handles.tag_input_arrival_tof,'String','Enter Value');

% set trajectory select flag
set(handles.tag_check_traj_plot,'Value',1)
TRAJECTORY_SELECTION_FLAG=1;

%set popup menu options - path event
MENU_EVENT_STRING=char('None',path_events_string_labels);
set(handles.tag_pop_dim1_event,'String',MENU_EVENT_STRING);
set(handles.tag_pop_dim2_event,'String',MENU_EVENT_STRING);
set(handles.tag_pop_dim3_event,'String',MENU_EVENT_STRING);
set(handles.tag_pop_dim4_event,'String',MENU_EVENT_STRING);

%set popup menu options - event property
% ----
% data labels
% ----
PLANET_DATA_LABELS=strvcat('Event Date','Event Vinf','Periapse Altitude','Theta',...
    'Orbit period','Orbit periapse','Orbit apoapse','Time since previous event','Time of flight');
MANEUVER_DATA_LABELS=strvcat('Delta V',...
    'Maneuver Date','Orbit period','Orbit periapse','Orbit apoapse','Time to next event','Time of flight');


% --------------------------------------------------------------------
function varargout = tag_menu_dim1_body_Callback(h, eventdata, handles, varargin)
% Stub for event menu - DIM1.
global AUTO1_data path_vector simulation_information_array path_events_string_labels
global MENU_EVENT_STRING PLANET_DATA_LABELS MANEUVER_DATA_LABELS

% check to see if maneuver selected
if get(handles.tag_pop_dim1_event,'Value')~=1
    menu_maneuver_check=isequal(path_vector(get(handles.tag_pop_dim1_event,'Value')-1),0);
end

% update property menu based on event selection
if get(handles.tag_pop_dim1_event,'Value')==1
    set(handles.tag_pop_dim1_prop,'Value',1)
    set(handles.tag_pop_dim1_prop,'String','None')
elseif menu_maneuver_check==1
    set(handles.tag_pop_dim1_prop,'String',MANEUVER_DATA_LABELS)
elseif get(handles.tag_pop_dim1_event,'Value')==2
    set(handles.tag_pop_dim1_prop,'Value',1)
    set(handles.tag_pop_dim1_prop,'String',PLANET_DATA_LABELS(1:end-2,:))
else
    set(handles.tag_pop_dim1_prop,'String',PLANET_DATA_LABELS)
end  
    
% --------------------------------------------------------------------
function varargout = tag_menu_dim3_body_Callback(h, eventdata, handles, varargin)
% Stub for event menu - DIM3.
global AUTO1_data path_vector simulation_information_array path_events_string_labels
global MENU_EVENT_STRING PLANET_DATA_LABELS MANEUVER_DATA_LABELS

% check to see if maneuver selected
if get(handles.tag_pop_dim3_event,'Value')~=1
    menu_maneuver_check=isequal(path_vector(get(handles.tag_pop_dim3_event,'Value')-1),0);
end

% update property menu based on event selection
if get(handles.tag_pop_dim3_event,'Value')==1
    set(handles.tag_pop_dim3_prop,'Value',1)
    set(handles.tag_pop_dim3_prop,'String','None')
elseif menu_maneuver_check==1
    set(handles.tag_pop_dim3_prop,'String',MANEUVER_DATA_LABELS)
elseif get(handles.tag_pop_dim3_event,'Value')==2
    set(handles.tag_pop_dim3_prop,'Value',1)
    set(handles.tag_pop_dim3_prop,'String',PLANET_DATA_LABELS(1:end-2,:))
else
    set(handles.tag_pop_dim3_prop,'String',PLANET_DATA_LABELS)
end  

% --------------------------------------------------------------------
function varargout = tag_menu_dim4_body_Callback(h, eventdata, handles, varargin)
% Stub for event menu - DIM4.
global AUTO1_data path_vector simulation_information_array path_events_string_labels
global MENU_EVENT_STRING PLANET_DATA_LABELS MANEUVER_DATA_LABELS

% check to see if maneuver selected
if get(handles.tag_pop_dim4_event,'Value')~=1
    menu_maneuver_check=isequal(path_vector(get(handles.tag_pop_dim4_event,'Value')-1),0);
end

% update property menu based on event selection
if get(handles.tag_pop_dim4_event,'Value')==1
    set(handles.tag_pop_dim4_prop,'Value',1)
    set(handles.tag_pop_dim4_prop,'String','None')
elseif menu_maneuver_check==1
    set(handles.tag_pop_dim4_prop,'String',MANEUVER_DATA_LABELS)
elseif get(handles.tag_pop_dim4_event,'Value')==2
    set(handles.tag_pop_dim4_prop,'Value',1)
    set(handles.tag_pop_dim4_prop,'String',PLANET_DATA_LABELS(1:end-2,:))
else
    set(handles.tag_pop_dim4_prop,'String',PLANET_DATA_LABELS)
end  

% --------------------------------------------------------------------
function varargout = tag_menu_dim2_body_Callback(h, eventdata, handles, varargin)
% Stub for event menu - DIM2.
global AUTO1_data path_vector simulation_information_array path_events_string_labels
global MENU_EVENT_STRING PLANET_DATA_LABELS MANEUVER_DATA_LABELS

% check to see if maneuver selected
if get(handles.tag_pop_dim2_event,'Value')~=1
    menu_maneuver_check=isequal(path_vector(get(handles.tag_pop_dim2_event,'Value')-1),0);
end

% update property menu based on event selection
if get(handles.tag_pop_dim2_event,'Value')==1
    set(handles.tag_pop_dim2_prop,'Value',1)
    set(handles.tag_pop_dim2_prop,'String','None')
elseif menu_maneuver_check==1
    set(handles.tag_pop_dim2_prop,'String',MANEUVER_DATA_LABELS)
elseif get(handles.tag_pop_dim2_event,'Value')==2
    set(handles.tag_pop_dim2_prop,'Value',1)
    set(handles.tag_pop_dim2_prop,'String',PLANET_DATA_LABELS(1:end-2,:))
else
    set(handles.tag_pop_dim2_prop,'String',PLANET_DATA_LABELS)
end  

% --------------------------------------------------------------------
function varargout = tag_menu_dim1_prop_Callback(h, eventdata, handles, varargin)
% Stub for property menu - DIM1.
global AUTO1_data path_vector simulation_information_array path_events_string_labels
global MENU_EVENT_STRING PLANET_DATA_LABELS MANEUVER_DATA_LABELS

%check to see if date entered for comparison
if isequal(path_vector(get(handles.tag_pop_dim1_event,'Value')-1),0)&get(handles.tag_pop_dim1_prop,'Value')==2
    set(handles.tag_input_dim1_value,'String','mm/dd/yyyy');
elseif get(handles.tag_pop_dim1_prop,'Value')==1
    set(handles.tag_input_dim1_value,'String','mm/dd/yyyy');
else
    set(handles.tag_input_dim1_value,'String','Enter Value');
end
    
% --------------------------------------------------------------------
function varargout = tag_menu_dim2_prop_Callback(h, eventdata, handles, varargin)
% Stub for property menu - dim2.
global AUTO1_data path_vector simulation_information_array path_events_string_labels
global MENU_EVENT_STRING PLANET_DATA_LABELS MANEUVER_DATA_LABELS

%check to see if date entered for comparison
if isequal(path_vector(get(handles.tag_pop_dim2_event,'Value')-1),0)&get(handles.tag_pop_dim2_prop,'Value')==2
    set(handles.tag_input_dim2_value,'String','mm/dd/yyyy');
elseif get(handles.tag_pop_dim2_prop,'Value')==1
    set(handles.tag_input_dim2_value,'String','mm/dd/yyyy');
else
    set(handles.tag_input_dim2_value,'String','Enter Value');
end

% --------------------------------------------------------------------
function varargout = tag_menu_dim3_prop_Callback(h, eventdata, handles, varargin)
% Stub for property menu - dim3.
global AUTO1_data path_vector simulation_information_array path_events_string_labels
global MENU_EVENT_STRING PLANET_DATA_LABELS MANEUVER_DATA_LABELS

%check to see if date entered for comparison
if isequal(path_vector(get(handles.tag_pop_dim3_event,'Value')-1),0)&get(handles.tag_pop_dim3_prop,'Value')==2
    set(handles.tag_input_dim3_value,'String','mm/dd/yyyy');
elseif get(handles.tag_pop_dim3_prop,'Value')==1
    set(handles.tag_input_dim3_value,'String','mm/dd/yyyy');
else
    set(handles.tag_input_dim3_value,'String','Enter Value');
end

% --------------------------------------------------------------------
function varargout = tag_menu_dim4_prop_Callback(h, eventdata, handles, varargin)
% Stub for property menu - dim4.
global AUTO1_data path_vector simulation_information_array path_events_string_labels
global MENU_EVENT_STRING PLANET_DATA_LABELS MANEUVER_DATA_LABELS

%check to see if date entered for comparison
if isequal(path_vector(get(handles.tag_pop_dim4_event,'Value')-1),0)&get(handles.tag_pop_dim4_prop,'Value')==2
    set(handles.tag_input_dim4_value,'String','mm/dd/yyyy');
elseif get(handles.tag_pop_dim4_prop,'Value')==1
    set(handles.tag_input_dim4_value,'String','mm/dd/yyyy');
else
    set(handles.tag_input_dim4_value,'String','Enter Value');
end


% --------------------------------------------------------------------
function varargout = check_number_Callback(h, eventdata, handles, varargin)
% Stub for number checkbox.
%turn off contour and symbol checkboxes if checked
if isequal(get(handles.tag_check_dim4_N,'Value'),0)&isequal(get(handles.tag_check_dim4_S,'Value'),0)
    set(handles.tag_check_dim4_S,'Value',1);
else
    set(handles.tag_check_dim4_S,'Value',0);
end
%set(handles.tag_check_dim4_cont,'Value',0);
%set text in color checkbox
set(handles.tag_check_dim4_C,'String','Color (<=30)');


% --------------------------------------------------------------------
function varargout = check_symbol_Callback(h, eventdata, handles, varargin)
% Stub for symbol checkbox.
%turn off number and contour checkboxes if checked
if isequal(get(handles.tag_check_dim4_N,'Value'),0)&isequal(get(handles.tag_check_dim4_S,'Value'),0)
    set(handles.tag_check_dim4_N,'Value',1);
else
    set(handles.tag_check_dim4_N,'Value',0);
end
%set(handles.tag_check_dim4_cont,'Value',0);
%set text in color checkbox
set(handles.tag_check_dim4_C,'String','Color (<=30)');


% --------------------------------------------------------------------
% % function varargout = check_contour_Callback(h, eventdata, handles, varargin)
% % Stub for Callback of the uicontrol handles.checkbox2.
% % turn off number and symbol checkboxes
% set(handles.tag_check_dim4_N,'Value',0);
% set(handles.tag_check_dim4_S,'Value',0);
% % set color check box: string = fill color and value = 1
% % set input field - contour uses automatic color selection
% if get(handles.tag_check_dim4_cont,'Value')==1
%     set(handles.tag_check_dim4_C,'Value',1);
%     set(handles.tag_check_dim4_C,'String','Fill Color');
%     set(handles.tag_input_dim4_colors,'String','Auto');
% else
%     set(handles.tag_check_dim4_C,'Value',1);
%     set(handles.tag_check_dim4_C,'String','Color');
%     set(handles.tag_input_dim4_colors,'String','Auto');
% end

% --------------------------------------------------------------------
function varargout = pushbutton_savefig_Callback(h, eventdata, handles, varargin)
% Stub for Callback of the uicontrol handles.pushbutton1.
global FIGURE_NUMBER


if find(get(0,'Children')==FIGURE_NUMBER)
    file_name=['STOUR_' datestr(now,1) '.fig'];
    [newfile,newpath] = uiputfile(file_name,'Save figure as');
else
    set(handles.tag_text_message,'String','*** Cannot find last plot ***');
end


% --------------------------------------------------------------------
% PLOT Button Pushed
% --------------------------------------------------------------------

function varargout = pushbutton_plot_Callback(h, eventdata, handles, varargin)
% Stub for Callback of the uicontrol handles.tag_push_plot.
global AUTO1_data path_vector simulation_information_array path_events_string_labels
global MENU_EVENT_STRING PLANET_DATA_LABELS MANEUVER_DATA_LABELS
global FIGURE_NUMBER

% initialise flags and variables
no_plot_flag=0;

[control_panel_numbers,control_panel_strings]=catch_panel_configuration(handles);

% check to see if plotting is possible (must have at least 2 axes defined)
check_plotting_possible=max(size(find([control_panel_numbers(1) control_panel_numbers(4) control_panel_numbers(7)]~=1)));
if check_plotting_possible<2  %not enough input - use default plot settings
    set(handles.tag_text_message,'String','*** Not enough input - default options used ***')
    default_plot_settings(handles)
elseif isequal(check_plotting_possible,2) % 2D plot 
    set(handles.tag_text_message,'String','Plotting ....')
    plotting_2D_routine(control_panel_numbers,control_panel_strings,handles)
elseif isequal(check_plotting_possible,3)
    set(handles.tag_text_message,'String','Plotting ....')
    plotting_3D_routine(control_panel_numbers,control_panel_strings,handles)
end
% indicate finished status if no warning messages entered
if isequal(get(handles.tag_text_message,'String'),'Plotting ....')
    set(handles.tag_text_message,'String','Request Completed!')
end
  

% --------------------------------------------------------------------
% Default PLOT settings
% --------------------------------------------------------------------
function default_plot_settings(handles)
% set control panel for default plot 
% X axis - launch date
% Y axis - arrival date
% Contour - launch Vinf
global AUTO1_data path_vector simulation_information_array path_events_string_labels
global MENU_EVENT_STRING PLANET_DATA_LABELS MANEUVER_DATA_LABELS
global FIGURE_NUMBER


% set control panel configuration
set(handles.tag_pop_dim1_event,'Value',2); %Launch
set(handles.tag_pop_dim1_prop,'String',PLANET_DATA_LABELS); 
set(handles.tag_pop_dim1_prop,'Value',1); %Date 
set(handles.tag_pop_dim1_relate,'Value',1); %All
set(handles.tag_input_dim1_value,'String','mm/dd/yyyy');

set(handles.tag_pop_dim2_event,'Value',size(MENU_EVENT_STRING,1)); %Arrival
set(handles.tag_pop_dim2_prop,'String',PLANET_DATA_LABELS); 
set(handles.tag_pop_dim2_prop,'Value',1); % Date
set(handles.tag_pop_dim2_relate,'Value',1); %All
set(handles.tag_input_dim2_value,'String','mm/dd/yyyy');

set(handles.tag_pop_dim3_event,'Value',1);
set(handles.tag_pop_dim3_prop,'String','None');
set(handles.tag_pop_dim3_relate,'Value',1);
set(handles.tag_input_dim3_value,'String','Enter Value');

set(handles.tag_pop_dim4_event,'Value',2);
set(handles.tag_pop_dim4_prop,'String',PLANET_DATA_LABELS); 
set(handles.tag_pop_dim4_prop,'Value',2);
set(handles.tag_pop_dim4_relate,'Value',1);
set(handles.tag_input_dim4_value,'String','Enter Value');
set(handles.tag_check_dim4_cont,'Value',0); %contour plot
set(handles.tag_check_dim4_N,'Value',0);
set(handles.tag_check_dim4_S,'Value',1);
set(handles.tag_check_dim4_C,'Value',1);
set(handles.tag_input_dim4_colors,'String','10');
set(handles.tag_input_dim4_numbers,'String','20');
set(handles.tag_input_dim4_symbols,'String','10');


set(handles.tag_pop_min_alt,'Value',1);
set(handles.tag_input_min_alt,'String','Enter Value');
set(handles.tag_pop_arrival_tof,'Value',1);
set(handles.tag_input_arrival_tof,'String','Enter Value');

% read variable values
[control_panel_numbers,control_panel_strings]=catch_panel_configuration(handles);

plotting_2D_routine(control_panel_numbers,control_panel_strings,handles)

% --------------------------------------------------------------------
% Read the control panel configuration
% --------------------------------------------------------------------
function [control_panel_numbers,control_panel_strings]=catch_panel_configuration(handles)
% read control panel data and store in variables.  corrections are made if
% the input is invalid.
global MENU_EVENT_STRING PLANET_DATA_LABELS MANEUVER_DATA_LABELS

% read control panel configuration
control_panel_numbers(1)=get(handles.tag_pop_dim1_event,'Value');
control_panel_numbers(2)=get(handles.tag_pop_dim1_prop,'Value');
control_panel_numbers(3)=get(handles.tag_pop_dim1_relate,'Value');
%check for date comparison
if control_panel_numbers(3)~=1&ismember(get(handles.tag_pop_dim1_prop,'String'),PLANET_DATA_LABELS)&control_panel_numbers(2)==1
    if length(findstr('/',get(handles.tag_input_dim1_value,'String')))~=2
        set(handles.tag_text_message,'String','*** Invalid Date Entered ***');
    else
        dim1_condition_value=datenum(get(handles.tag_input_dim1_value,'String'));
    end
elseif control_panel_numbers(3)~=1&ismember(get(handles.tag_pop_dim1_prop,'String'),MANEUVER_DATA_LABELS)&control_panel_numbers(2)==2
    if length(findstr('/',get(handles.tag_input_dim1_value,'String')))~=2
        set(handles.tag_text_message,'String','*** Invalid Date Entered ***');
    else
        dim1_condition_value=datenum(get(handles.tag_input_dim1_value,'String'));
    end
else
    dim1_condition_value=str2num(get(handles.tag_input_dim1_value,'String'));
end

control_panel_numbers(4)=get(handles.tag_pop_dim2_event,'Value');
control_panel_numbers(5)=get(handles.tag_pop_dim2_prop,'Value');
control_panel_numbers(6)=get(handles.tag_pop_dim2_relate,'Value');
%check for date comparison
if control_panel_numbers(6)~=1&isequal(get(handles.tag_pop_dim2_prop,'String'),PLANET_DATA_LABELS)&control_panel_numbers(5)==1
    if length(findstr('/',get(handles.tag_input_dim2_value,'String')))~=2
        set(handles.tag_text_message,'String','*** Invalid Date Entered ***');
    else
        dim2_condition_value=datenum(get(handles.tag_input_dim2_value,'String'));
    end
elseif control_panel_numbers(6)~=1&isequal(get(handles.tag_pop_dim2_prop,'String'),MANEUVER_DATA_LABELS)&control_panel_numbers(3)==2
    if length(findstr('/',get(handles.tag_input_dim2_value,'String')))~=2
        set(handles.tag_text_message,'String','*** Invalid Date Entered ***');
    else
        dim2_condition_value=datenum(get(handles.tag_input_dim2_value,'String'));
    end
else
    dim2_condition_value=str2num(get(handles.tag_input_dim2_value,'String'));
end

control_panel_numbers(7)=get(handles.tag_pop_dim3_event,'Value');
control_panel_numbers(8)=get(handles.tag_pop_dim3_prop,'Value');
control_panel_numbers(9)=get(handles.tag_pop_dim3_relate,'Value');
%check for date comparison
if control_panel_numbers(9)~=1&isequal(get(handles.tag_pop_dim3_prop,'String'),PLANET_DATA_LABELS)&control_panel_numbers(8)==1
    if length(findstr('/',get(handles.tag_input_dim2_value,'String')))~=2
        set(handles.tag_text_message,'String','*** Invalid Date Entered ***');
    else
        dim2_condition_value=datenum(get(handles.tag_input_dim2_value,'String'));
    end
elseif control_panel_numbers(9)~=1&isequal(get(handles.tag_pop_dim3_prop,'String'),MANEUVER_DATA_LABELS)&control_panel_numbers(8)==2
    if length(findstr('/',get(handles.tag_input_dim3_value,'String')))~=2
        set(handles.tag_text_message,'String','*** Invalid Date Entered ***');
    else
        dim2_condition_value=datenum(get(handles.tag_input_dim3_value,'String'));
    end
else
    dim3_condition_value=str2num(get(handles.tag_input_dim3_value,'String'));
end

control_panel_numbers(10)=get(handles.tag_pop_dim4_event,'Value');
control_panel_numbers(11)=get(handles.tag_pop_dim4_prop,'Value');
control_panel_numbers(12)=get(handles.tag_pop_dim4_relate,'Value');
%check for date comparison
if control_panel_numbers(12)~=1&isequal(get(handles.tag_pop_dim4_prop,'String'),PLANET_DATA_LABELS)&control_panel_numbers(11)==1
    if length(findstr('/',get(handles.tag_input_dim4_value,'String')))~=2
        set(handles.tag_text_message,'String','*** Invalid Date Entered ***');
    else
        dim2_condition_value=datenum(get(handles.tag_input_dim4_value,'String'));
    end
elseif control_panel_numbers(12)~=1&isequal(get(handles.tag_pop_dim4_prop,'String'),MANEUVER_DATA_LABELS)&control_panel_numbers(11)==2
    if length(findstr('/',get(handles.tag_input_dim4_value,'String')))~=2
        set(handles.tag_text_message,'String','*** Invalid Date Entered ***');
    else
        dim2_condition_value=datenum(get(handles.tag_input_dim4_value,'String'));
    end
else
    dim4_condition_value=str2num(get(handles.tag_input_dim4_value,'String'));
end

control_panel_numbers(13)=get(handles.tag_check_dim4_cont,'Value');
control_panel_numbers(14)=get(handles.tag_check_dim4_N,'Value');
control_panel_numbers(15)=get(handles.tag_check_dim4_S,'Value');
control_panel_numbers(16)=get(handles.tag_check_dim4_C,'Value');
dim4_format_color_number=str2num(get(handles.tag_input_dim4_colors,'String'));
dim4_format_number_number=str2num(get(handles.tag_input_dim4_numbers,'String'));
dim4_format_symbol_number=str2num(get(handles.tag_input_dim4_symbols,'String'));

control_panel_numbers(17)=get(handles.tag_pop_min_alt,'Value'); %altitude condition
value_min_alt=str2num(get(handles.tag_input_min_alt,'String'));

control_panel_numbers(18)=get(handles.tag_pop_arrival_tof,'Value'); % TOF condition
value_arrival_tof=str2num(get(handles.tag_input_arrival_tof,'String'));

% check that correct values entered into fields if required
if control_panel_numbers(1)~=1&control_panel_numbers(3)~=1&isempty(dim1_condition_value) %DIM1 check
    set(handles.tag_pop_dim1_relate,'Value',1);
    control_panel_numbers(3)=1;
    set(handles.tag_text_message,'String','*** Invalid Value Entered ***');
    dim1_condition_value='None';
elseif isempty(dim1_condition_value)|control_panel_numbers(3)==1
    dim1_condition_value='None';
    set(handles.tag_input_dim1_value,'String','Enter Value')
else
    dim1_condition_value=num2str(dim1_condition_value);
end

if control_panel_numbers(4)~=1&control_panel_numbers(6)~=1&isempty(dim2_condition_value) %DIM2
    set(handles.tag_pop_dim2_relate,'Value',1);
    control_panel_numbers(6)=1;
    set(handles.tag_text_message,'String','*** Invalid Value Entered ***');
    dim2_condition_value='None';
elseif isempty(dim2_condition_value)|control_panel_numbers(6)==1
    dim2_condition_value='None';
    set(handles.tag_input_dim2_value,'String','Enter Value')
else
    dim2_condition_value=num2str(dim2_condition_value);
end

if control_panel_numbers(7)~=1&control_panel_numbers(9)~=1&isempty(dim3_condition_value) %DIM3
    set(handles.tag_pop_dim3_relate,'Value',1);
    control_panel_numbers(9)=1;
    set(handles.tag_text_message,'String','*** Invalid Value Entered ***');
    dim3_condition_value='None';
elseif isempty(dim3_condition_value)|control_panel_numbers(9)==1
    dim3_condition_value='None';
    set(handles.tag_input_dim3_value,'String','Enter Value')
else
    dim3_condition_value=num2str(dim3_condition_value);
end

if control_panel_numbers(10)~=1&control_panel_numbers(12)~=1&isempty(dim4_condition_value) %DIM4
    set(handles.tag_pop_dim4_relate,'Value',1);
    control_panel_numbers(12)=1;
    set(handles.tag_text_message,'String','*** Invalid Value Entered ***');
    dim4_condition_value=get(handles.tag_input_dim4_value,'String');
elseif isempty(dim4_condition_value)|control_panel_numbers(12)==1
    dim4_condition_value='None';
    set(handles.tag_input_dim4_value,'String','Enter Value')
else
    dim4_condition_value=num2str(dim4_condition_value);
end

if control_panel_numbers(13)~=1&isempty(dim4_format_color_number) %number of colors
    set(handles.tag_input_dim4_colors,'String','10');
    dim4_format_color_number='10';
    set(handles.tag_text_message,'String','*** Invalid Value Entered ***');
elseif isempty(dim4_format_color_number)
    dim4_format_color_number='10';
elseif dim4_format_color_number>30
    set(handles.tag_input_dim4_colors,'String','30');
    dim4_format_color_number='30';
    set(handles.tag_text_message,'String','*** Invalid Value Entered ***');
else
    dim4_format_color_number=num2str(dim4_format_color_number);
end

if control_panel_numbers(14)~=1&isempty(dim4_format_number_number) %number of numbers
    set(handles.tag_input_dim4_numbers,'String','20');
    dim4_format_number_number='20';
    set(handles.tag_text_message,'String','*** Invalid Value Entered ***');
elseif isempty(dim4_format_number_number)
    dim4_format_number_number='20';
% elseif dim4_format_numberr_number>20
%     set(handles.tag_input_dim4_numbers,'String',10);
%     dim4_format_number_number='20';
%     set(handles.tag_text_message,'String','*** Invalid Value Entered ***');
else
    dim4_format_number_number=num2str(dim4_format_number_number);
end

if control_panel_numbers(15)~=1&isempty(dim4_format_symbol_number) %number of symbols
    set(handles.tag_input_dim4_symbols,'String',10);
    dim4_format_symbol_number='10';
    set(handles.tag_text_message,'String','*** Invalid Value Entered ***');
elseif isempty(dim4_format_symbol_number)
    dim4_format_symbol_number='10';
elseif dim4_format_symbol_number>10
    set(handles.tag_input_dim4_numbers,'String',10);
    dim4_format_number_number='10';
    set(handles.tag_text_message,'String','*** Invalid Value Entered ***');
else
    dim4_format_symbol_number=num2str(dim4_format_symbol_number);
end

if control_panel_numbers(17)~=1&isempty(value_min_alt) %general check flyby alt
    set(handles.tag_pop_min_alt,'Value',1);
    control_panel_numbers(17)=1;
    set(handles.tag_text_message,'String','*** Invalid Value Entered ***');
    value_min_alt='None';
elseif isempty(value_min_alt)
    value_min_alt='None';
else
    value_min_alt=num2str(value_min_alt);
end


if control_panel_numbers(18)~=1&isempty(value_arrival_tof) %general check TOF total
    set(handles.tag_pop_arrival_tof,'Value',1);
    control_panel_numbers(18)=1;
    set(handles.tag_text_message,'String','*** Invalid Value Entered ***');
    value_arrival_tof='None';
elseif isempty(value_arrival_tof)
    value_arrival_tof='None';
else
    value_arrival_tof=num2str(value_arrival_tof);
end

control_panel_strings=char(dim1_condition_value,dim2_condition_value,dim3_condition_value,dim4_condition_value,...
    dim4_format_color_number,value_min_alt,value_arrival_tof,dim4_format_number_number,dim4_format_symbol_number);


% --------------------------------------------------------------------
function varargout = tag_push_credits_Callback(h, eventdata, handles, varargin)
% Stub for Callback of the uicontrol handles.tag_push_credits.

%display program credits
CREDITS

% --------------------------------------------------------------------
function varargout = tag_check_traj_plot_Callback(h, eventdata, handles, varargin)
global TRAJECTORY_SELECTION_FLAG
% Stub for Callback of the uicontrol handles.tag_check_traj_plot.

% Set trajectory selection flag.  If the checkbox value is 1, trajectory information
% can be retrieved by selecting the a data point on the plot.

TRAJECTORY_SELECTION_FLAG=get(handles.tag_check_traj_plot,'Value');


% --------------------------------------------------------------------
function varargout = tag_push_locate_Callback(h, eventdata, handles, varargin)
% Stub for Callback of the uicontrol handles.tag_push_locate.
% locate AUTO1 File and load
global AUTO1_data path_vector simulation_information_array path_events_string_labels
global MENU_EVENT_STRING PLANET_DATA_LABELS MANEUVER_DATA_LABELS

% Read AUTO1 file
if ~isempty(AUTO1_data)
    disp('AUTO1 file already loaded')
    set(handles.tag_text_message,'String',['Warning: AUTO1 file already loaded!'])
end
%check for AUTO1 file (independently of ReadAUTO1.m)
[file_name,path_name] = uigetfile('*.*','Locate AUTO1 File');

if ~isequal(path_name,0)
    fid_check=fopen([path_name file_name],'rt');
    if fid_check==-1
        set(handles.tag_text_message,'String','***** Error: Unable to open AUTO1 file *****');
    else
        fclose(fid_check);
    end
    
    ReadAUTO1(path_name,file_name)
    
    %Set control panel information
    initialise_control_panel(handles)
end