function varargout = FIND_TRAJECTORY(varargin)
% FIND_TRAJECTORY generates a GUI to display information relating to the selected trajectory point.
% The data corresponding to the selected trajectory is retrieved and processed for a trajectory plot.
% To assist trajectory selection, a selected data point can be hidden from view in the plot.  All the "hidden"
% points can be restored in the current plot.
% M.Jokic 2003

global TRAJECTORY_SELECTION_FLAG POINT_HANDLE

% FIND_TRAJECTORY Application M-file for FIND_TRAJECTORY.fig
%    FIG = FIND_TRAJECTORY launch FIND_TRAJECTORY GUI.
%    FIND_TRAJECTORY('callback_name', ...) invoke the named callback.

% Last Modified by GUIDE v2.0 22-Apr-2003 01:51:01

if nargin == 0  % LAUNCH GUI only if trajectory selection flag is 1.
    
    if isequal(TRAJECTORY_SELECTION_FLAG,1)

        fig = openfig(mfilename,'reuse');
        
        % Generate a structure of handles to pass to callbacks, and store it. 
        handles = guihandles(fig);
        guidata(fig, handles);
        
        if nargout > 0
            varargout{1} = fig;
        end
        
        locate_trajectory(handles)
    end
        
elseif ischar(varargin{1}) % INVOKE NAMED SUBFUNCTION OR CALLBACK

	try
		[varargout{1:nargout}] = feval(varargin{:}); % FEVAL switchyard
	catch
		disp(lasterr);
	end
    
end


%| ABOUT CALLBACKS:
%| GUIDE automatically appends subfunction prototypes to this file, and 
%| sets objects' callback properties to call them through the FEVAL 
%| switchyard above. This comment describes that mechanism.
%|
%| Each callback subfunction declaration has the following form:
%| <SUBFUNCTION_NAME>(H, EVENTDATA, HANDLES, VARARGIN)
%|
%| The subfunction name is composed using the object's Tag and the 
%| callback type separated by '_', e.g. 'slider2_Callback',
%| 'figure1_CloseRequestFcn', 'axis1_ButtondownFcn'.
%|
%| H is the callback object's handle (obtained using GCBO).
%|
%| EVENTDATA is empty, but reserved for future use.
%|
%| HANDLES is a structure containing handles of components in GUI using
%| tags as fieldnames, e.g. handles.figure1, handles.slider2. This
%| structure is created at GUI startup using GUIHANDLES and stored in
%| the figure's application data using GUIDATA. A copy of the structure
%| is passed to each callback.  You can store additional information in
%| this structure at GUI startup, and you can change the structure
%| during callbacks.  Call guidata(h, handles) after changing your
%| copy to replace the stored original so that subsequent callbacks see
%| the updates. Type "help guihandles" and "help guidata" for more
%| information.
%|
%| VARARGIN contains any extra arguments you have passed to the
%| callback. Specify the extra arguments by editing the callback
%| property in the inspector. By default, GUIDE sets the property to:
%| <MFILENAME>('<SUBFUNCTION_NAME>', gcbo, [], guidata(gcbo))
%| Add any extra arguments after the last argument, before the final
%| closing parenthesis.

% --------------------------------------------------------------------
function locate_trajectory(handles)

%Function to locate a trajectory from a point selected on the STOUR plot

global AUTO1_data path_vector simulation_information_array path_events_string_labels

global MENU_EVENT_STRING PLANET_DATA_LABELS MANEUVER_DATA_LABELS

global FIGURE_NUMBER PLOT_SYMBOLS PLOT_NUMBERS COLOR_SCHEME AXIS_LABELS POINT_HANDLE

global trajectory_data

% get data from the selected point 
trajectory_number=get(gco,'UserData');
POINT_HANDLE=gco;
point_type=get(POINT_HANDLE,'Type');
axis_handle=gca;


%plot representation of the point in the figure
axes_children_traj_find=get(handles.tag_axes,'Children');
delete(axes_children_traj_find);
if isequal(point_type,'line')
    plot(0.5,0.5,'Color',get(POINT_HANDLE,'Color'),'Marker',get(POINT_HANDLE,'Marker'),'LineWidth',get(POINT_HANDLE,'LineWidth'),...
        'Parent',handles.tag_axes,'MarkerSize',20)
else
    text(0.5,0.5,get(POINT_HANDLE,'String'),'FontSize',14,'FontWeight',get(POINT_HANDLE,'FontWeight'),...
        'HorizontalAlignment',get(POINT_HANDLE,'HorizontalAlignment'),'VerticalAlignment',get(POINT_HANDLE,'VerticalAlignment'),...
        'Parent',handles.tag_axes,'color',get(POINT_HANDLE,'color'))
end
    
% define working variables - used to move around AUTO1_data
number_of_events=max(size(path_vector));
auto1_data_size=size(AUTO1_data);

trajectory_index=number_of_events*trajectory_number-number_of_events+1;
trajectory_data=AUTO1_data(trajectory_index:trajectory_index+number_of_events-1,:);
trajectory_data_text=num2str(trajectory_data);

% data lables
data_titles=char('Launch Date ', 'Launch Vinf ', 'Path Event ', 'Periapse Height ',...
        'Theta/DV ', 'Vinf/TotDV', 'Period ',...
        'Periapse ', 'Apoapse ', 'TOF ', 'TotTOF ');
data_units=char('yyyy/mm/dd ','(km/s) ',' ','(km) ','(deg.)/(km/s) ','(km/s) ','(days) ',...
        '(AU/CBody R) ','(AU/CBody R) ','(days) ','(days) ');
%
%
    
column_number=1;
for ii=1:11
    information_string=char(data_titles(ii,:),data_units(ii,:),'-----------',num2str(trajectory_data(:,ii)));
    if isequal(ii,1)
        information_string=char(data_titles(ii,:),data_units(ii,:),'-----------',datestr(trajectory_data(1,ii),26),...
            num2str(zeros(number_of_events-1,1)));
    end
    column_plus=size(information_string,2);
    trajectory_display(:,column_number:column_number-1+column_plus)=information_string;
    column_number=size(trajectory_display,2)+1;
    if isequal(ii,1)
        set(handles.tag_information_1,'String',information_string(1:4,:))
    elseif isequal(ii,2)
        set(handles.tag_information_2,'String',information_string(1:4,:))
    elseif isequal(ii,3)
        set(handles.tag_information_3,'String',char(data_titles(ii,:),data_units(ii,:),'-----------',...
            path_events_string_labels))
    elseif isequal(ii,4)
        set(handles.tag_information_4,'String',information_string(1:end-1,:))
    elseif isequal(ii,5)
        set(handles.tag_information_5,'String',information_string(1:end-1,:))
    elseif isequal(ii,6)
        set(handles.tag_information_6,'String',information_string(1:end,:))
    elseif isequal(ii,7)
        set(handles.tag_information_7,'String',information_string(1:end-1,:))
    elseif isequal(ii,8)
        set(handles.tag_information_8,'String',information_string(1:end-1,:))
    elseif isequal(ii,9)
        set(handles.tag_information_9,'String',information_string(1:end-1,:))
    elseif isequal(ii,10)
        set(handles.tag_information_10,'String',information_string(1:end-1,:))
    elseif isequal(ii,11)
        set(handles.tag_information_11,'String',information_string(1:end-1,:))
    end

end



% trajectory_display=char(data_titles,data_units,num2str(trajectory_data))
% trajectory_display=strvcat(char(data_labels),trajectory_data_text);


set(handles.tag_text_title,'String',['Trajectory number: ' num2str(trajectory_number)])

%-------
%print trajectory information to the screen
%-------
disp('-----------------------------------------------------')
disp(['Trajectory number: ' num2str(trajectory_number)])
disp(trajectory_display)
disp('-----------------------------------------------------')



% --------------------------------------------------------------------
function varargout = tag_push_hide_Callback(h, eventdata, handles, varargin)
% Stub for Callback of the uicontrol handles.tag_push_hide.
global POINT_HANDLE

set(POINT_HANDLE,'Visible','off')


% --------------------------------------------------------------------
function varargout = tag_push_restore_Callback(h, eventdata, handles, varargin)
% Stub for Callback of the uicontrol handles.tag_push_restore.

h=get(gca,'Children');
set(h,'Visible','on')

% --------------------------------------------------------------------
function varargout = tag_push_plot_traj_Callback(h, eventdata, handles, varargin)
% Stub for Callback of the uicontrol handles.tag_push_plot_traj.
global AUTO1_data path_vector simulation_information_array path_events_string_labels
global trajectory_data

%bodies to input into trajectory plot
if ismember(path_vector,[0 1 2 3 4 5 6 7 8 9])
    jj=0;
    for ii=1:max(size(path_vector))
        if path_vector(ii)~=0
            jj=jj+1;
            body_vector_no_maneuver(jj)=path_vector(ii);
        end
    end
    bodies=[0 body_vector_no_maneuver];
end

%find dates
jj=0;
for ii=1:max(size(path_vector))-1
    if path_vector(ii+1)~=0
        jj=jj+1;
        date_vector_no_maneuver(jj)=trajectory_data(ii,end);
    end
end
dates=[trajectory_data(1,1) trajectory_data(1,1)+date_vector_no_maneuver];

%determine number of revs
jj=0;
last_date=trajectory_data(1,1);
for ii=1:max(size(path_vector))-1
    if path_vector(ii)~=0
        jj=jj+1;
        if ~isequal(trajectory_data(ii,end-4),0)
            rev_vector_no_maneuver(jj)=floor((trajectory_data(ii,end)+trajectory_data(1,1)-last_date)/trajectory_data(ii,end-4));
        else
            rev_vector_no_maneuver(jj)=0;
        end
        last_date=trajectory_data(ii,end)+trajectory_data(1,1);
    end
end
revs=rev_vector_no_maneuver;

% -------------------------------------------------------------------------------------------
% Plot the trajectory - the "trajplot" code plots the selected trajectory. 
% D. Landau 2003
% -------------------------------------------------------------------------------------------
trajectory_figure=trajplot(dates,bodies,revs);
% -------------------------------------------------------------------------------------------

%--------------
% trajectory plot formatting
% Plot the Sun
% sun = image([-1 1]*1.5e7,[-1 1]*1.5e7,imread('sun.jpg'));

% set figure background to white - easy to view
set(trajectory_figure,'color',[1 1 1])

% plot the sun
plot3(0,0,0,'.','markersize',40,'color',[1 0.8 0])

title(['Trajectory Path: ' num2str(path_vector)],'FontSize',12,'Units','normalized','position',[0.1 1.02 0])
set(trajectory_figure,'numbertitle','off','name','Trajectory Plot')
hold off